/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.hints.errors;

import com.sun.source.util.TreePath;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.SourceVersion;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.EditableProperties;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public class EnablePreviewAntProj
implements ErrorRule<Void> {
    private static final Set<String> ERROR_CODES = new HashSet<String>(Arrays.asList("compiler.err.preview.feature.disabled", "compiler.err.preview.feature.disabled.plural"));
    private static final String ENABLE_PREVIEW_FLAG = "--enable-preview";
    private static final String JAVAC_COMPILER_ARGS = "javac.compilerargs";
    private static final String RUN_JVMARGS = "run.jvmargs";

    public Set<String> getCodes() {
        return Collections.unmodifiableSet(ERROR_CODES);
    }

    @NonNull
    public List<Fix> run(CompilationInfo compilationInfo, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        if (SourceVersion.latest() != compilationInfo.getSourceVersion()) {
            return Collections.emptyList();
        }
        FileObject file = compilationInfo.getFileObject();
        ResolveAntFix fix = null;
        if (file != null) {
            Project prj = FileOwnerQuery.getOwner((FileObject)file);
            fix = this.isAntProject(prj) ? new ResolveAntFix(prj) : null;
        }
        return fix != null ? Collections.singletonList(fix) : Collections.emptyList();
    }

    public String getId() {
        return EnablePreviewAntProj.class.getName();
    }

    public String getDisplayName() {
        return NbBundle.getMessage(EnablePreviewAntProj.class, (String)"FIX_EnablePreviewFeature");
    }

    public String getDescription() {
        return NbBundle.getMessage(EnablePreviewAntProj.class, (String)"FIX_EnablePreviewFeature");
    }

    public void cancel() {
    }

    private static void storeEditableProperties(final Project prj, final String propertiesPath, final EditableProperties ep) throws IOException {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    FileObject propertiesFo = prj.getProjectDirectory().getFileObject(propertiesPath);
                    if (propertiesFo != null) {
                        try (OutputStream os = null;){
                            os = propertiesFo.getOutputStream();
                            ep.store(os);
                        }
                    }
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            // empty catch block
        }
    }

    private static EditableProperties getEditableProperties(final Project prj, final String propertiesPath) throws IOException {
        try {
            return (EditableProperties)ProjectManager.mutex().readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<EditableProperties>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public EditableProperties run() throws IOException {
                    FileObject propertiesFo = prj.getProjectDirectory().getFileObject(propertiesPath);
                    EditableProperties ep = null;
                    if (propertiesFo != null) {
                        ep = new EditableProperties(false);
                        try (InputStream is = null;){
                            is = propertiesFo.getInputStream();
                            ep.load(is);
                        }
                    }
                    return ep;
                }
            });
        }
        catch (MutexException ex) {
            return null;
        }
    }

    private boolean isAntProject(Project prj) {
        if (prj == null) {
            return false;
        }
        FileObject prjDir = prj.getProjectDirectory();
        if (prjDir == null) {
            return false;
        }
        ArrayList<FileObject> antProjectFiles = new ArrayList<FileObject>();
        antProjectFiles.add(prjDir.getFileObject("build.xml"));
        antProjectFiles.add(prjDir.getFileObject("nbproject/project.properties"));
        antProjectFiles.add(prjDir.getFileObject("nbproject/project.xml"));
        boolean isAntProject = true;
        for (FileObject file : antProjectFiles) {
            if (file != null && file.isValid()) continue;
            isAntProject = false;
            break;
        }
        return isAntProject;
    }

    private static final class ResolveAntFix
    implements Fix {
        private final Project prj;

        ResolveAntFix(@NonNull Project prj) {
            Parameters.notNull((CharSequence)"prj", (Object)prj);
            this.prj = prj;
        }

        public String getText() {
            return NbBundle.getMessage(EnablePreviewAntProj.class, (String)"FIX_EnablePreviewFeature");
        }

        public ChangeInfo implement() throws Exception {
            EditableProperties ep = EnablePreviewAntProj.getEditableProperties(this.prj, "nbproject/project.properties");
            String compilerArgs = ep.getProperty(EnablePreviewAntProj.JAVAC_COMPILER_ARGS);
            compilerArgs = compilerArgs != null ? compilerArgs + " " + EnablePreviewAntProj.ENABLE_PREVIEW_FLAG : EnablePreviewAntProj.ENABLE_PREVIEW_FLAG;
            String runJVMArgs = ep.getProperty(EnablePreviewAntProj.RUN_JVMARGS);
            if (runJVMArgs == null) {
                runJVMArgs = EnablePreviewAntProj.ENABLE_PREVIEW_FLAG;
            } else if (!runJVMArgs.contains(EnablePreviewAntProj.ENABLE_PREVIEW_FLAG)) {
                runJVMArgs = runJVMArgs + " " + EnablePreviewAntProj.ENABLE_PREVIEW_FLAG;
            }
            ep.setProperty(EnablePreviewAntProj.JAVAC_COMPILER_ARGS, compilerArgs);
            ep.setProperty(EnablePreviewAntProj.RUN_JVMARGS, runJVMArgs);
            EnablePreviewAntProj.storeEditableProperties(this.prj, "nbproject/project.properties", ep);
            return null;
        }
    }
}

