/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.marker;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.netbeans.lib.profiler.marker.Mark;
import org.netbeans.lib.profiler.marker.Marker;
import org.netbeans.lib.profiler.results.cpu.marking.MarkMapping;

public class CompositeMarker
implements Marker {
    private Set delegates = new LinkedHashSet();

    public CompositeMarker() {
    }

    public CompositeMarker(Set markerList) {
        this();
        this.delegates.addAll(markerList);
    }

    @Override
    public MarkMapping[] getMappings() {
        HashSet<MarkMapping> markerMethods = new HashSet<MarkMapping>();
        for (Marker delegate : this.delegates) {
            MarkMapping[] mMethods = delegate.getMappings();
            markerMethods.addAll(Arrays.asList(mMethods));
        }
        return markerMethods.toArray(new MarkMapping[0]);
    }

    @Override
    public Mark[] getMarks() {
        HashSet<Mark> allMarks = new HashSet<Mark>();
        for (Marker delegate : this.delegates) {
            Mark[] marks = delegate.getMarks();
            allMarks.addAll(Arrays.asList(marks));
        }
        return allMarks.toArray(new Mark[0]);
    }

    public void addMarker(Marker marker) {
        if (marker == null) {
            return;
        }
        this.delegates.add(marker);
    }

    public void addMarkers(Collection markers) {
        if (markers == null) {
            return;
        }
        this.delegates.addAll(markers);
    }

    public void removeMarker(Marker marker) {
        if (marker == null) {
            return;
        }
        this.delegates.remove(marker);
    }

    public void removeMarkers(Collection markers) {
        if (markers == null) {
            return;
        }
        this.delegates.removeAll(markers);
    }
}

