/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.wireprotocol;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class Command {
    public static final int CHECK_CONNECTION = 1;
    public static final int START_TARGET_APP = 2;
    public static final int CLASS_LOADED = 3;
    public static final int SET_CHANGEABLE_INSTR_PARAMS = 4;
    public static final int SET_UNCHANGEABLE_INSTR_PARAMS = 5;
    public static final int CPU_RESULTS_EXIST = 6;
    public static final int INSTRUMENT_METHOD_GROUP = 7;
    public static final int GET_CODE_REGION_CPU_RESULTS = 8;
    public static final int DEACTIVATE_INJECTED_CODE = 9;
    public static final int SUSPEND_TARGET_APP = 10;
    public static final int RESUME_TARGET_APP = 11;
    public static final int TERMINATE_TARGET_JVM = 12;
    public static final int INITIATE_PROFILING = 13;
    public static final int MESSAGE = 14;
    public static final int SHUTDOWN_OK = 15;
    public static final int GET_THREAD_LIVENESS_STATUS = 16;
    public static final int ROOT_CLASS_LOADED = 17;
    public static final int SHUTDOWN_INITIATED = 18;
    public static final int SHUTDOWN_COMPLETED = 19;
    public static final int INSTRUMENT_REFLECTION = 20;
    public static final int DEINSTRUMENT_REFLECTION = 21;
    public static final int METHOD_LOADED = 22;
    public static final int METHOD_INVOKED_FIRST_TIME = 23;
    public static final int GET_INTERNAL_STATS = 24;
    public static final int DETACH = 25;
    public static final int EVENT_BUFFER_DUMPED = 26;
    public static final int DUMP_EXISTING_RESULTS = 27;
    public static final int GET_VM_PROPERTIES = 28;
    public static final int RESET_PROFILER_COLLECTORS = 29;
    public static final int GET_OBJECT_ALLOCATION_RESULTS = 30;
    public static final int GET_METHOD_NAMES_FOR_JMETHOD_IDS = 31;
    public static final int GET_MONITORED_NUMBERS = 32;
    public static final int RUN_GC = 33;
    public static final int RUN_CALIBRATION_AND_GET_DATA = 34;
    public static final int GET_DEFINING_CLASS_LOADER = 35;
    public static final int CLASS_LOADER_UNLOADING = 36;
    public static final int GET_STORED_CALIBRATION_DATA = 37;
    public static final int RESULTS_AVAILABLE = 38;
    public static final int TAKE_SNAPSHOT = 39;
    public static final int DUMP_EXISTING_RESULTS_LIVE = 40;
    public static final int TAKE_HEAP_DUMP = 41;
    public static final int GET_CLASSID = 42;
    public static final int STILL_ALIVE = 43;
    public static final int PREPARE_DETACH = 44;
    public static final int GET_HEAP_HISTOGRAM = 45;
    public static final int TAKE_THREAD_DUMP = 46;
    public static final int GET_CLASS_FILE_BYTES = 47;
    private int type;

    public Command(int type) {
        this.type = type;
    }

    Command() {
    }

    public int getType() {
        return this.type;
    }

    public static String cmdTypeToString(int type) {
        switch (type) {
            case 1: {
                return "CHECK_CONNECTION";
            }
            case 2: {
                return "START_TARGET_APP";
            }
            case 3: {
                return "CLASS_LOADED";
            }
            case 4: {
                return "SET_CHANGEABLE_INSTR_PARAMS";
            }
            case 5: {
                return "SET_UNCHANGEABLE_INSTR_PARAMS";
            }
            case 6: {
                return "CPU_RESULTS_EXIST";
            }
            case 7: {
                return "INSTRUMENT_METHOD_GROUP";
            }
            case 8: {
                return "GET_CODE_REGION_CPU_RESULTS";
            }
            case 9: {
                return "DEACTIVATE_INJECTED_CODE";
            }
            case 10: {
                return "SUSPEND_TARGET_APP";
            }
            case 11: {
                return "RESUME_TARGET_APP";
            }
            case 12: {
                return "TERMINATE_TARGET_JVM";
            }
            case 13: {
                return "INITIATE_PROFILING";
            }
            case 14: {
                return "MESSAGE";
            }
            case 15: {
                return "SHUTDOWN_OK";
            }
            case 16: {
                return "GET_THREAD_LIVENESS_STATUS";
            }
            case 17: {
                return "ROOT_CLASS_LOADED";
            }
            case 18: {
                return "SHUTDOWN_INITIATED";
            }
            case 19: {
                return "SHUTDOWN_COMPLETED";
            }
            case 20: {
                return "INSTRUMENT_REFLECTION";
            }
            case 21: {
                return "DEINSTRUMENT_REFLECTION";
            }
            case 22: {
                return "METHOD_LOADED";
            }
            case 23: {
                return "METHOD_INVOKED_FIRST_TIME";
            }
            case 24: {
                return "GET_INTERNAL_STATS";
            }
            case 25: {
                return "DETACH";
            }
            case 26: {
                return "EVENT_BUFFER_DUMPED";
            }
            case 27: {
                return "DUMP_EXISTING_RESULTS";
            }
            case 28: {
                return "GET_VM_PROPERTIES";
            }
            case 29: {
                return "RESET_PROFILER_COLLECTORS";
            }
            case 30: {
                return "GET_OBJECT_ALLOCATION_RESULTS";
            }
            case 31: {
                return "GET_METHOD_NAMES_FOR_JMETHOD_IDS";
            }
            case 32: {
                return "MONITORED_NUMBERS";
            }
            case 33: {
                return "RUN_GC";
            }
            case 34: {
                return "RUN_CALIBRATION_AND_GET_DATA";
            }
            case 35: {
                return "GET_DEFINING_CLASSLOADER";
            }
            case 36: {
                return "CLASS_LOADER_UNLOADING";
            }
            case 37: {
                return "GET_STORED_CALIBRATION_DATA";
            }
            case 38: {
                return "RESULTS_AVAILABLE";
            }
            case 39: {
                return "TAKE_SNAPSHOT";
            }
            case 40: {
                return "DUMP_EXISTING_RESULTS_LIVE";
            }
            case 41: {
                return "TAKE_HEAP_DUMP";
            }
            case 42: {
                return "GET_CLASSID";
            }
            case 43: {
                return "STILL_ALIVE";
            }
            case 44: {
                return "PREPARE_DETACH";
            }
            case 45: {
                return "GET_HEAP_HISTOGRAM";
            }
            case 46: {
                return "TAKE_THREAD_DUMP";
            }
            case 47: {
                return "GET_CLASS_FILE_BYTES";
            }
        }
        return "Unknown command";
    }

    public String toString() {
        return Command.cmdTypeToString(this.type);
    }

    void setType(int type) {
        this.type = type;
    }

    void readObject(ObjectInputStream in) throws IOException {
    }

    void writeObject(ObjectOutputStream out) throws IOException {
    }
}

