/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.memory;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.client.ClientUtils;

public class JMethodIdTable {
    static String NATIVE_SUFFIX = "[native]";
    private static JMethodIdTable defaultTable;
    private JMethodIdTableEntry[] entries;
    private boolean staticTable = false;
    private int incompleteEntries;
    private int nElements;
    private int size;
    private int threshold;

    public JMethodIdTable() {
        this.size = 97;
        this.threshold = this.size * 3 / 4;
        this.nElements = 0;
        this.entries = new JMethodIdTableEntry[this.size];
    }

    public JMethodIdTable(JMethodIdTable otherTable) {
        this.staticTable = true;
        this.threshold = otherTable.nElements + 1;
        this.size = this.threshold * 4 / 3;
        this.nElements = 0;
        this.entries = new JMethodIdTableEntry[this.size];
        for (int i = 0; i < otherTable.entries.length; ++i) {
            JMethodIdTableEntry entry = otherTable.entries[i];
            if (entry == null) continue;
            this.addEntry(entry.methodId, entry.className, entry.methodName, entry.methodSig, entry.isNative);
        }
    }

    public static synchronized JMethodIdTable getDefault() {
        if (defaultTable == null) {
            defaultTable = new JMethodIdTable();
        }
        return defaultTable;
    }

    public static synchronized void reset() {
        defaultTable = null;
    }

    public synchronized String debug() {
        if (this.entries == null) {
            return "Entries = null, size = " + this.size + ", nElements = " + this.nElements + ", threshold = " + this.threshold + ", incompleteEntries = " + this.incompleteEntries;
        }
        return "Entries.length = " + this.entries.length + ", size = " + this.size + ", nElements = " + this.nElements + ", threshold = " + this.threshold + ", incompleteEntries = " + this.incompleteEntries;
    }

    public synchronized void readFromStream(DataInputStream in) throws IOException {
        this.size = in.readInt();
        this.nElements = in.readInt();
        this.threshold = in.readInt();
        this.entries = new JMethodIdTableEntry[this.size];
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            int methodId = in.readInt();
            String className = in.readUTF();
            String methodName = in.readUTF();
            String methodSig = in.readUTF();
            boolean isNative = false;
            if (methodName.endsWith(NATIVE_SUFFIX)) {
                methodName = methodName.substring(0, methodName.length() - NATIVE_SUFFIX.length());
                isNative = true;
            }
            this.addEntry(methodId, className, methodName, methodSig, isNative);
        }
    }

    public synchronized void writeToStream(DataOutputStream out) throws IOException {
        int i;
        out.writeInt(this.size);
        out.writeInt(this.nElements);
        out.writeInt(this.threshold);
        int count = 0;
        for (i = 0; i < this.entries.length; ++i) {
            if (this.entries[i] == null) continue;
            ++count;
        }
        out.writeInt(count);
        for (i = 0; i < this.entries.length; ++i) {
            JMethodIdTableEntry entry = this.entries[i];
            if (entry == null) continue;
            out.writeInt(entry.methodId);
            out.writeUTF(entry.className);
            out.writeUTF(entry.isNative ? entry.methodName.concat(NATIVE_SUFFIX) : entry.methodName);
            out.writeUTF(entry.methodSig);
        }
    }

    public synchronized JMethodIdTableEntry getEntry(int methodId) {
        int pos = this.hash(methodId) % this.size;
        while (this.entries[pos] != null && this.entries[pos].methodId != methodId) {
            pos = (pos + 1) % this.size;
        }
        return this.entries[pos];
    }

    public synchronized void getNamesForMethodIds(ProfilerClient profilerClient) throws ClientUtils.TargetAppOrVMTerminated {
        if (this.staticTable) {
            throw new IllegalStateException("Attempt to update snapshot JMethodIdTable");
        }
        if (this.incompleteEntries == 0) {
            return;
        }
        int[] missingNameMethodIds = new int[this.incompleteEntries];
        int idx = 0;
        for (int i = 0; i < this.entries.length; ++i) {
            if (this.entries[i] == null || this.entries[i].className != null) continue;
            missingNameMethodIds[idx++] = this.entries[i].methodId;
        }
        String[][] methodClassNameAndSig = profilerClient.getMethodNamesForJMethodIds(missingNameMethodIds);
        for (int i = 0; i < missingNameMethodIds.length; ++i) {
            this.completeEntry(missingNameMethodIds[i], methodClassNameAndSig[0][i], methodClassNameAndSig[1][i], methodClassNameAndSig[2][i], this.getBoolean(methodClassNameAndSig[3][i]));
        }
        this.incompleteEntries = 0;
    }

    void addEntry(int methodId, String className, String methodName, String methodSig, boolean isNative) {
        this.checkMethodId(methodId);
        this.completeEntry(methodId, className, methodName, methodSig, isNative);
    }

    public synchronized void checkMethodId(int methodId) {
        int pos = this.hash(methodId) % this.size;
        while (this.entries[pos] != null) {
            if (this.entries[pos].methodId == methodId) {
                return;
            }
            pos = (pos + 1) % this.size;
        }
        if (this.nElements < this.threshold) {
            this.entries[pos] = new JMethodIdTableEntry(methodId);
            ++this.nElements;
            ++this.incompleteEntries;
            return;
        }
        this.growTable();
        this.checkMethodId(methodId);
    }

    private synchronized void completeEntry(int methodId, String className, String methodName, String methodSig, boolean isNative) {
        int pos = this.hash(methodId) % this.size;
        while (this.entries[pos].methodId != methodId) {
            pos = (pos + 1) % this.size;
        }
        this.entries[pos].className = className;
        this.entries[pos].methodName = methodName;
        this.entries[pos].methodSig = methodSig;
        this.entries[pos].isNative = isNative;
    }

    private void growTable() {
        JMethodIdTableEntry[] oldEntries = this.entries;
        this.size = this.size * 2 + 1;
        this.threshold = this.size * 3 / 4;
        this.entries = new JMethodIdTableEntry[this.size];
        for (int i = 0; i < oldEntries.length; ++i) {
            if (oldEntries[i] == null) continue;
            int pos = this.hash(oldEntries[i].methodId) % this.size;
            while (this.entries[pos] != null) {
                pos = (pos + 1) % this.size;
            }
            this.entries[pos] = oldEntries[i];
        }
    }

    private int hash(int x) {
        return (x >> 2) * 123457 & 0xFFFFFFF;
    }

    private boolean getBoolean(String boolStr) {
        return "1".equals(boolStr);
    }

    public static class JMethodIdTableEntry {
        public String className;
        public String methodName;
        public String methodSig;
        public transient boolean isNative;
        int methodId;

        JMethodIdTableEntry(int methodId) {
            this.methodId = methodId;
        }
    }
}

