/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.netbeans.lib.profiler.heap.ClassDump;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.LongBuffer;
import org.netbeans.lib.profiler.heap.LongHashMap;
import org.netbeans.lib.profiler.heap.LongIterator;
import org.netbeans.lib.profiler.heap.LongMap;
import org.netbeans.lib.profiler.heap.LongSet;
import org.netbeans.lib.profiler.heap.ObjectFieldValue;
import org.netbeans.lib.profiler.heap.Systems;

class DominatorTree {
    private static final int BUFFER_SIZE = 8192;
    private static final int ADDITIONAL_IDS_THRESHOLD = 30;
    private static final int ADDITIONAL_IDS_THRESHOLD_DIRTYSET_SAME_SIZE = 5;
    private HprofHeap heap;
    private LongBuffer multipleParents;
    private LongBuffer revertedMultipleParents;
    private LongBuffer currentMultipleParents;
    private LongHashMap map;
    private LongSet dirtySet;
    private int dirtySetSameSize;
    private Map canContainItself;
    private Map nearestGCRootCache = new NearestGCRootCache(400000);

    DominatorTree(HprofHeap h, LongBuffer multiParents) {
        this.heap = h;
        this.currentMultipleParents = this.multipleParents = multiParents;
        this.map = new LongHashMap(multiParents.getSize());
        this.dirtySet = new LongSet();
        try {
            this.revertedMultipleParents = multiParents.revertBuffer();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex.getLocalizedMessage(), ex);
        }
    }

    synchronized void computeDominators() {
        boolean changed = true;
        try {
            boolean igonoreDirty;
            do {
                this.currentMultipleParents.rewind();
                igonoreDirty = !changed;
                changed = this.computeOneLevel(igonoreDirty);
                this.switchParents();
            } while (changed || !igonoreDirty);
        }
        catch (IOException ex) {
            Systems.printStackTrace(ex);
        }
        this.deleteBuffers();
        this.dirtySet = new LongSet();
    }

    private boolean computeOneLevel(boolean ignoreDirty) throws IOException {
        boolean changed = false;
        LongSet newDirtySet = new LongSet(this.map.size() / 10);
        ArrayList<Long> additionalIds = new ArrayList<Long>();
        int additionalIndex = 0;
        while (true) {
            long oldIdom;
            long instanceId;
            if ((instanceId = this.readLong()) == 0L) {
                if (additionalIndex >= additionalIds.size()) {
                    if (additionalIndex <= 0) break;
                    break;
                }
                instanceId = (Long)additionalIds.get(additionalIndex++);
            }
            if ((oldIdom = this.map.get(instanceId)) != -1L && (oldIdom <= 0L || !ignoreDirty && !this.dirtySet.contains(oldIdom) && !this.dirtySet.contains(instanceId))) continue;
            LongMap.Entry entry = this.heap.idToOffsetMap.get(instanceId);
            LongIterator refIt = entry.getReferences();
            long newIdomId = refIt.next();
            boolean dirty = false;
            while (refIt.hasNext() && newIdomId != 0L) {
                long refIdObj = refIt.next();
                newIdomId = this.intersect(newIdomId, refIdObj);
            }
            if (oldIdom == -1L) {
                this.map.put(instanceId, newIdomId);
                if (newIdomId != 0L) {
                    newDirtySet.add(newIdomId);
                }
                changed = true;
                continue;
            }
            if (oldIdom == newIdomId) continue;
            newDirtySet.add(oldIdom);
            if (newIdomId != 0L) {
                newDirtySet.add(newIdomId);
            }
            this.map.put(instanceId, newIdomId);
            if (this.dirtySet.size() < 30 || this.dirtySetSameSize >= 5) {
                this.updateAdditionalIds(instanceId, additionalIds);
            }
            changed = true;
        }
        this.dirtySetSameSize = this.dirtySet.size() != newDirtySet.size() ? 0 : ++this.dirtySetSameSize;
        this.dirtySet = newDirtySet;
        return changed;
    }

    private void updateAdditionalIds(long instanceId, List<Long> additionalIds) {
        Instance i = this.heap.getInstanceByID(instanceId);
        if (i != null) {
            for (Object v : i.getFieldValues()) {
                Instance val;
                if (!(v instanceof ObjectFieldValue) || (val = ((ObjectFieldValue)v).getInstance()) == null) continue;
                long idp = val.getInstanceId();
                Long idO = new Long(idp);
                long idomO = this.map.get(idp);
                if (idomO <= 0L) continue;
                additionalIds.add(idO);
            }
        }
    }

    private void deleteBuffers() {
        this.multipleParents.delete();
        this.revertedMultipleParents.delete();
    }

    private long readLong() throws IOException {
        return this.currentMultipleParents.readLong();
    }

    long getIdomId(long instanceId, LongMap.Entry entry) {
        long idomEntry = this.map.get(instanceId);
        if (idomEntry != -1L) {
            return idomEntry;
        }
        if (entry == null) {
            entry = this.heap.idToOffsetMap.get(instanceId);
        }
        return entry.getNearestGCRootPointer();
    }

    boolean hasInstanceInChain(int tag, Instance i) {
        if (tag == 35) {
            return false;
        }
        ClassDump javaClass = (ClassDump)i.getJavaClass();
        if (this.canContainItself == null) {
            this.canContainItself = new HashMap(this.heap.getAllClasses().size() / 2);
        }
        if (tag == 33) {
            Boolean canContain = (Boolean)this.canContainItself.get(javaClass);
            if (canContain == null) {
                canContain = javaClass.canContainItself();
                this.canContainItself.put(javaClass, canContain);
            }
            if (!canContain.booleanValue()) {
                return false;
            }
        }
        long instanceId = i.getInstanceId();
        long idom = this.getIdomId(instanceId);
        while (idom != 0L) {
            Instance ip = this.heap.getInstanceByID(idom);
            JavaClass cls = ip.getJavaClass();
            if (javaClass.equals(cls)) {
                return true;
            }
            idom = this.getIdomId(idom);
        }
        return false;
    }

    private Long getNearestGCRootPointer(Long instanceIdLong) {
        Long nearestGCLong = (Long)this.nearestGCRootCache.get(instanceIdLong);
        if (nearestGCLong != null) {
            return nearestGCLong;
        }
        LongMap.Entry entry = this.heap.idToOffsetMap.get(instanceIdLong);
        Long nearestGC = entry.getNearestGCRootPointer();
        this.nearestGCRootCache.put(instanceIdLong, nearestGC);
        return nearestGC;
    }

    private long getIdomId(long instanceIdLong) {
        long idom = this.map.get(instanceIdLong);
        if (idom != -1L) {
            return idom;
        }
        return this.getNearestGCRootPointer(instanceIdLong);
    }

    private long intersect(long idomId, long refId) {
        if (idomId == refId) {
            return idomId;
        }
        if (idomId == 0L || refId == 0L) {
            return 0L;
        }
        LongSet leftIdoms = new LongSet(200);
        LongSet rightIdoms = new LongSet(200);
        long leftIdom = idomId;
        long rightIdom = refId;
        leftIdoms.add(leftIdom);
        rightIdoms.add(rightIdom);
        while (rightIdom != 0L || leftIdom != 0L) {
            if (leftIdom != 0L && (leftIdom = this.getIdomId(leftIdom)) != 0L) {
                if (rightIdoms.contains(leftIdom)) {
                    return leftIdom;
                }
                leftIdoms.add(leftIdom);
            }
            if (rightIdom == 0L || (rightIdom = this.getIdomId(rightIdom)) == 0L) continue;
            if (leftIdoms.contains(rightIdom)) {
                return rightIdom;
            }
            rightIdoms.add(rightIdom);
        }
        return 0L;
    }

    private void switchParents() {
        this.currentMultipleParents = this.currentMultipleParents == this.revertedMultipleParents ? this.multipleParents : this.revertedMultipleParents;
    }

    private void printObjs(List<Long> changedIds, List<Long> oldDomIds, List<Long> newDomIds, List<Boolean> addedByDirtySet, List<Long> changedIdx) {
        if (changedIds.size() > 20) {
            return;
        }
        TreeMap<Integer, String> m = new TreeMap<Integer, String>();
        for (int i = 0; i < changedIds.size(); ++i) {
            Long iid = changedIds.get(i);
            Long oldDom = oldDomIds.get(i);
            Long newDom = newDomIds.get(i);
            Long index = changedIdx.get(i);
            Boolean addedByDirt = addedByDirtySet.get(i);
            Instance ii = this.heap.getInstanceByID(iid);
            int number = ii.getInstanceNumber();
            String text = "Index: " + index + (addedByDirt != false ? " New " : " Old ") + this.printInstance(iid);
            text = text + " OldDom " + this.printInstance(oldDom);
            text = text + " NewDom: " + this.printInstance(newDom);
            m.put(number, text);
        }
        for (Integer in : m.keySet()) {
            Systems.debug((String)m.get(in));
        }
    }

    String printInstance(Long instanceid) {
        if (instanceid == null || instanceid == 0L) {
            return "null";
        }
        Instance ii = this.heap.getInstanceByID(instanceid);
        return ii.getJavaClass().getName() + "#" + ii.getInstanceNumber();
    }

    void writeToStream(DataOutputStream out) throws IOException {
        this.map.writeToStream(out);
    }

    DominatorTree(HprofHeap h, DataInputStream dis) throws IOException {
        this.heap = h;
        this.map = new LongHashMap(dis);
    }

    private static final class NearestGCRootCache
    extends LinkedHashMap {
        private final int maxSize;

        private NearestGCRootCache(int size) {
            super(size, 0.75f, true);
            this.maxSize = size;
        }

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > this.maxSize;
        }
    }
}

