/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.SwingUtilities;

public final class HeapProgress {
    public static final int PROGRESS_MAX = 1000;
    private static ThreadLocal progressThreadLocal = new ThreadLocal();

    private HeapProgress() {
    }

    public static BoundedRangeModel getProgress() {
        ModelInfo info = (ModelInfo)progressThreadLocal.get();
        if (info == null) {
            info = new ModelInfo();
            progressThreadLocal.set(info);
        }
        return info.model;
    }

    static void progress(long counter, long startOffset, long value, long endOffset) {
        if (counter % 100000L == 0L) {
            HeapProgress.progress(value, endOffset, startOffset);
        }
    }

    static void progress(long value, long endValue) {
        HeapProgress.progress(value, 0L, value, endValue);
    }

    private static void progress(long value, long endOffset, long startOffset) {
        ModelInfo info = (ModelInfo)progressThreadLocal.get();
        if (info != null) {
            if (info.level > info.divider) {
                info.divider = info.level;
            }
            long val = 1000L * (value - startOffset) / (endOffset - startOffset);
            int modelVal = (int)((long)info.offset + val / (long)info.divider);
            HeapProgress.setValue(info.model, modelVal);
        }
    }

    private static int levelAdd(ModelInfo info, int diff) {
        ModelInfo modelInfo = info;
        modelInfo.level = modelInfo.level + diff;
        return info.level;
    }

    static void progressStart() {
        ModelInfo info = (ModelInfo)progressThreadLocal.get();
        if (info != null) {
            HeapProgress.levelAdd(info, 1);
        }
    }

    static void progressFinish() {
        ModelInfo info = (ModelInfo)progressThreadLocal.get();
        if (info != null) {
            int level = HeapProgress.levelAdd(info, -1);
            assert (level >= 0);
            if (level == 0) {
                progressThreadLocal.remove();
            }
            info.offset = info.model.getValue();
        }
    }

    private static void setValue(final BoundedRangeModel model, final int val) {
        if (SwingUtilities.isEventDispatchThread()) {
            model.setValue(val);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    model.setValue(val);
                }
            });
        }
    }

    private static class ModelInfo {
        private BoundedRangeModel model = new DefaultBoundedRangeModel(0, 0, 0, 1000);
        private int level;
        private int divider;
        private int offset;

        private ModelInfo() {
        }
    }
}

