/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.charts.xy;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.charts.ChartConfigurationListener;
import org.netbeans.lib.profiler.charts.PaintersModel;
import org.netbeans.lib.profiler.charts.Timeline;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYChart;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItemsModel;
import org.netbeans.modules.profiler.api.icons.Icons;

public class ProfilerXYChart
extends SynchronousXYChart {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.charts.xy.Bundle");
    private static final String ZOOM_IN_STRING = messages.getString("ProfilerXYChart_ZoomInString");
    private static final String ZOOM_OUT_STRING = messages.getString("ProfilerXYChart_ZoomOutString");
    private static final String FIXED_SCALE_STRING = messages.getString("ProfilerXYChart_FixedScaleString");
    private static final String SCALE_TO_FIT_STRING = messages.getString("ProfilerXYChart_ScaleToFitString");
    private static final Icon ZOOM_IN_ICON = Icons.getIcon((String)"GeneralIcons.ZoomIn");
    private static final Icon ZOOM_OUT_ICON = Icons.getIcon((String)"GeneralIcons.ZoomOut");
    private static final Icon FIXED_SCALE_ICON = Icons.getIcon((String)"GeneralIcons.Zoom");
    private static final Icon SCALE_TO_FIT_ICON = Icons.getIcon((String)"GeneralIcons.ScaleToFit");
    private ZoomInAction zoomInAction;
    private ZoomOutAction zoomOutAction;
    private ToggleViewAction toggleViewAction;

    public ProfilerXYChart(SynchronousXYItemsModel itemsModel, PaintersModel paintersModel) {
        super(itemsModel, paintersModel);
        this.setBottomBased(true);
        this.setFitsHeight(true);
        this.setMousePanningEnabled(false);
        this.addConfigurationListener((ChartConfigurationListener)new VisibleBoundsListener());
    }

    public Action zoomInAction() {
        if (this.zoomInAction == null) {
            this.zoomInAction = new ZoomInAction();
        }
        return this.zoomInAction;
    }

    public Action zoomOutAction() {
        if (this.zoomOutAction == null) {
            this.zoomOutAction = new ZoomOutAction();
        }
        return this.zoomOutAction;
    }

    public Action toggleViewAction() {
        if (this.toggleViewAction == null) {
            this.toggleViewAction = new ToggleViewAction();
        }
        return this.toggleViewAction;
    }

    private class VisibleBoundsListener
    extends ChartConfigurationListener.Adapter {
        private VisibleBoundsListener() {
        }

        public void dataBoundsChanged(long dataOffsetX, long dataOffsetY, long dataWidth, long dataHeight, long oldDataOffsetX, long oldDataOffsetY, long oldDataWidth, long oldDataHeight) {
            if (ProfilerXYChart.this.zoomInAction != null) {
                ProfilerXYChart.this.zoomInAction.updateAction();
            }
            if (ProfilerXYChart.this.zoomOutAction != null) {
                ProfilerXYChart.this.zoomOutAction.updateAction();
            }
        }

        public void scaleChanged(double oldScaleX, double oldScaleY, double newScaleX, double newScaleY) {
            if (ProfilerXYChart.this.zoomInAction != null) {
                ProfilerXYChart.this.zoomInAction.updateAction();
            }
            if (ProfilerXYChart.this.zoomOutAction != null) {
                ProfilerXYChart.this.zoomOutAction.updateAction();
            }
        }
    }

    private class ToggleViewAction
    extends AbstractAction {
        private long origOffsetX = -1L;
        private double origScaleX = -1.0;

        public ToggleViewAction() {
            this.updateAction();
            ProfilerXYChart.this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (SwingUtilities.isMiddleMouseButton(e)) {
                        ToggleViewAction.this.actionPerformed(null);
                    }
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean fitsWidth = ProfilerXYChart.this.fitsWidth();
            if (!fitsWidth) {
                this.origOffsetX = ProfilerXYChart.this.getOffsetX();
                if (ProfilerXYChart.this.tracksDataWidth() && this.origOffsetX == ProfilerXYChart.this.getMaxOffsetX()) {
                    this.origOffsetX = Long.MAX_VALUE;
                }
                this.origScaleX = ProfilerXYChart.this.getScaleX();
            }
            ProfilerXYChart.this.setFitsWidth(!fitsWidth);
            if (fitsWidth && this.origOffsetX != -1L && this.origScaleX != -1.0) {
                ProfilerXYChart.this.setScale(this.origScaleX, ProfilerXYChart.this.getScaleY());
                ProfilerXYChart.this.setOffset(this.origOffsetX, ProfilerXYChart.this.getOffsetY());
            }
            this.updateAction();
            if (ProfilerXYChart.this.zoomInAction != null) {
                ProfilerXYChart.this.zoomInAction.updateAction();
            }
            if (ProfilerXYChart.this.zoomOutAction != null) {
                ProfilerXYChart.this.zoomOutAction.updateAction();
            }
            ProfilerXYChart.this.repaintDirty();
        }

        private void updateAction() {
            boolean fitsWidth = ProfilerXYChart.this.fitsWidth();
            Icon icon = fitsWidth ? FIXED_SCALE_ICON : SCALE_TO_FIT_ICON;
            String name = fitsWidth ? FIXED_SCALE_STRING : SCALE_TO_FIT_STRING;
            this.putValue("ShortDescription", name);
            this.putValue("SmallIcon", icon);
        }
    }

    private class ZoomOutAction
    extends AbstractAction {
        public ZoomOutAction() {
            this.putValue("ShortDescription", ZOOM_OUT_STRING);
            this.putValue("SmallIcon", ZOOM_OUT_ICON);
            this.updateAction();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean followsWidth = ProfilerXYChart.this.currentlyFollowingDataWidth();
            ProfilerXYChart.this.zoom(ProfilerXYChart.this.getWidth() / 2, ProfilerXYChart.this.getHeight() / 2, 0.5);
            if (followsWidth) {
                ProfilerXYChart.this.setOffset(ProfilerXYChart.this.getMaxOffsetX(), ProfilerXYChart.this.getOffsetY());
            }
            ProfilerXYChart.this.repaintDirty();
        }

        private void updateAction() {
            Timeline timeline = ((SynchronousXYItemsModel)ProfilerXYChart.this.getItemsModel()).getTimeline();
            this.setEnabled(timeline.getTimestampsCount() > 1 && !ProfilerXYChart.this.fitsWidth());
        }
    }

    private class ZoomInAction
    extends AbstractAction {
        public ZoomInAction() {
            this.putValue("ShortDescription", ZOOM_IN_STRING);
            this.putValue("SmallIcon", ZOOM_IN_ICON);
            this.updateAction();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean followsWidth = ProfilerXYChart.this.currentlyFollowingDataWidth();
            ProfilerXYChart.this.zoom(ProfilerXYChart.this.getWidth() / 2, ProfilerXYChart.this.getHeight() / 2, 2.0);
            if (followsWidth) {
                ProfilerXYChart.this.setOffset(ProfilerXYChart.this.getMaxOffsetX(), ProfilerXYChart.this.getOffsetY());
            }
            ProfilerXYChart.this.repaintDirty();
        }

        private void updateAction() {
            Timeline timeline = ((SynchronousXYItemsModel)ProfilerXYChart.this.getItemsModel()).getTimeline();
            this.setEnabled(timeline.getTimestampsCount() > 1 && !ProfilerXYChart.this.fitsWidth());
        }
    }
}

