/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import org.netbeans.lib.profiler.ui.UIUtils;

public class ProfilerPopupMenu
extends JPopupMenu {
    private boolean forceBackground;

    public ProfilerPopupMenu() {
    }

    public ProfilerPopupMenu(String label) {
        super(label);
    }

    @Override
    public JMenuItem add(JMenuItem menuItem) {
        if (this.forceBackground && !UIUtils.isOracleLookAndFeel()) {
            menuItem.setOpaque(false);
        }
        return super.add(menuItem);
    }

    @Override
    public void add(Component comp, Object constraints) {
        if (this.forceBackground && !UIUtils.isOracleLookAndFeel() && comp instanceof JComponent) {
            ((JComponent)comp).setOpaque(false);
        }
        comp.setMinimumSize(comp.getPreferredSize());
        super.add(comp, constraints);
    }

    public void setForceBackground(boolean force) {
        if (!UIUtils.isNimbus() || !Boolean.TRUE.equals(UIManager.getBoolean("nb.dark.theme"))) {
            this.forceBackground = force;
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.forceBackground) {
            g.setColor(this.getBackground());
            g.fillRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
        }
    }
}

