/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.cpu;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.tree.TreeNode;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.results.cpu.CPUResultsDiff;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.FlatProfileContainer;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.JExtendedSplitPane;
import org.netbeans.lib.profiler.ui.cpu.CPUTableView;
import org.netbeans.lib.profiler.ui.cpu.CPUTreeTableView;
import org.netbeans.lib.profiler.ui.cpu.CPUView;
import org.netbeans.lib.profiler.ui.cpu.ThreadsSelector;
import org.netbeans.lib.profiler.ui.results.DataView;
import org.netbeans.lib.profiler.ui.swing.FilterUtils;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTreeTable;
import org.netbeans.lib.profiler.ui.swing.SearchUtils;

public abstract class LiveCPUView
extends JPanel {
    private CPUResultsSnapshot snapshot;
    private CPUResultsSnapshot refSnapshot;
    private boolean sampled;
    private boolean mergedThreads;
    private Collection<Integer> selectedThreads;
    private DataView lastFocused;
    private CPUTableView hotSpotsView;
    private CPUTreeTableView forwardCallsView;
    private CPUTreeTableView reverseCallsView;
    private ThreadsSelector threadsSelector;
    private long lastupdate;
    private volatile boolean refreshIsRunning;
    private ExecutorService executor;

    public LiveCPUView(Set<ClientUtils.SourceCodeSelection> selection) {
        this.initUI(selection);
        this.registerActions();
    }

    public void setView(boolean forwardCalls, boolean hotSpots, boolean reverseCalls) {
        this.forwardCallsView.setVisible(forwardCalls);
        this.hotSpotsView.setVisible(hotSpots);
        this.reverseCallsView.setVisible(reverseCalls);
    }

    public ThreadsSelector createThreadSelector() {
        this.threadsSelector = new ThreadsSelector(){

            @Override
            protected CPUResultsSnapshot getSnapshot() {
                return LiveCPUView.this.snapshot;
            }

            @Override
            protected void selectionChanged(Collection<Integer> selected, boolean mergeThreads) {
                LiveCPUView.this.mergedThreads = mergeThreads;
                LiveCPUView.this.selectedThreads = selected;
                LiveCPUView.this.setData();
            }

            @Override
            void reset() {
                super.reset();
                LiveCPUView.this.mergedThreads = false;
                LiveCPUView.this.selectedThreads = null;
            }
        };
        return this.threadsSelector;
    }

    public boolean isRefreshRunning() {
        return this.refreshIsRunning;
    }

    public long getLastUpdate() {
        return this.lastupdate;
    }

    public void setData(final CPUResultsSnapshot snapshotData, final boolean sampledData) {
        if (this.refreshIsRunning) {
            return;
        }
        this.refreshIsRunning = true;
        UIUtils.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                LiveCPUView.this.snapshot = snapshotData;
                LiveCPUView.this.sampled = sampledData;
                LiveCPUView.this.setData();
            }
        });
    }

    private void setData() {
        if (this.snapshot == null) {
            this.resetData();
            this.refreshIsRunning = false;
        } else {
            this.getExecutor().submit(new Runnable(){

                @Override
                public void run() {
                    final CPUResultsSnapshot _snapshot = LiveCPUView.this.refSnapshot == null ? LiveCPUView.this.snapshot : LiveCPUView.this.refSnapshot.createDiff(LiveCPUView.this.snapshot);
                    final FlatProfileContainer flatData = _snapshot.getFlatProfile(LiveCPUView.this.selectedThreads, 0);
                    final Map idMap = _snapshot.getMethodIDMap(0);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                boolean diff = _snapshot instanceof CPUResultsDiff;
                                LiveCPUView.this.forwardCallsView.setData(_snapshot, idMap, 0, LiveCPUView.this.selectedThreads, LiveCPUView.this.mergedThreads, LiveCPUView.this.sampled, diff);
                                LiveCPUView.this.hotSpotsView.setData(flatData, idMap, LiveCPUView.this.sampled, diff);
                                LiveCPUView.this.reverseCallsView.setData(_snapshot, idMap, 0, LiveCPUView.this.selectedThreads, LiveCPUView.this.mergedThreads, LiveCPUView.this.sampled, diff);
                            }
                            finally {
                                LiveCPUView.this.refreshIsRunning = false;
                                LiveCPUView.this.lastupdate = System.currentTimeMillis();
                            }
                        }
                    });
                }
            });
        }
    }

    public boolean setDiffView(final boolean diff) {
        if (this.snapshot == null) {
            return false;
        }
        UIUtils.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                LiveCPUView.this.refSnapshot = diff ? LiveCPUView.this.snapshot : null;
                LiveCPUView.this.setData();
            }
        });
        return true;
    }

    public void resetData() {
        UIUtils.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                LiveCPUView.this.forwardCallsView.resetData();
                LiveCPUView.this.hotSpotsView.resetData();
                LiveCPUView.this.reverseCallsView.resetData();
                LiveCPUView.this.snapshot = null;
                LiveCPUView.this.refSnapshot = null;
                LiveCPUView.this.sampled = true;
                if (LiveCPUView.this.threadsSelector != null) {
                    LiveCPUView.this.threadsSelector.reset();
                }
            }
        });
    }

    public void showSelectionColumn() {
        this.forwardCallsView.showSelectionColumn();
        this.hotSpotsView.showSelectionColumn();
        this.reverseCallsView.showSelectionColumn();
    }

    public void refreshSelection() {
        this.forwardCallsView.refreshSelection();
        this.hotSpotsView.refreshSelection();
        this.reverseCallsView.refreshSelection();
    }

    protected boolean profileMethodSupported() {
        return true;
    }

    protected boolean profileClassSupported() {
        return true;
    }

    protected abstract boolean showSourceSupported();

    protected abstract void showSource(ClientUtils.SourceCodeSelection var1);

    protected abstract void selectForProfiling(ClientUtils.SourceCodeSelection var1);

    protected void popupShowing() {
    }

    protected void popupHidden() {
    }

    protected void foundInForwardCalls() {
    }

    protected void foundInHotSpots() {
    }

    protected void foundInReverseCalls() {
    }

    private void profileMethod(ClientUtils.SourceCodeSelection value) {
        this.selectForProfiling(value);
    }

    private void profileClass(ClientUtils.SourceCodeSelection value) {
        this.selectForProfiling(new ClientUtils.SourceCodeSelection(value.getClassName(), "*", null));
    }

    private void initUI(Set<ClientUtils.SourceCodeSelection> selection) {
        this.setLayout(new BorderLayout(0, 0));
        this.forwardCallsView = new CPUTreeTableView(selection, false){

            @Override
            protected void performDefaultAction(ClientUtils.SourceCodeSelection userValue) {
                if (LiveCPUView.this.showSourceSupported()) {
                    LiveCPUView.this.showSource(userValue);
                }
            }

            @Override
            protected void populatePopup(JPopupMenu popup, Object value, ClientUtils.SourceCodeSelection userValue) {
                LiveCPUView.this.populatePopup(LiveCPUView.this.forwardCallsView, popup, value, userValue);
            }

            @Override
            protected void popupShowing() {
                LiveCPUView.this.popupShowing();
            }

            @Override
            protected void popupHidden() {
                LiveCPUView.this.popupHidden();
            }

            @Override
            protected boolean hasBottomFilterFindMargin() {
                return true;
            }
        };
        this.forwardCallsView.notifyOnFocus(new Runnable(){

            @Override
            public void run() {
                LiveCPUView.this.lastFocused = LiveCPUView.this.forwardCallsView;
            }
        });
        this.hotSpotsView = new CPUTableView(selection){

            @Override
            protected void performDefaultAction(ClientUtils.SourceCodeSelection userValue) {
                if (LiveCPUView.this.showSourceSupported()) {
                    LiveCPUView.this.showSource(userValue);
                }
            }

            @Override
            protected void populatePopup(JPopupMenu popup, Object value, ClientUtils.SourceCodeSelection userValue) {
                LiveCPUView.this.populatePopup(LiveCPUView.this.hotSpotsView, popup, value, userValue);
            }

            @Override
            protected void popupShowing() {
                LiveCPUView.this.popupShowing();
            }

            @Override
            protected void popupHidden() {
                LiveCPUView.this.popupHidden();
            }

            @Override
            protected boolean hasBottomFilterFindMargin() {
                return true;
            }
        };
        this.hotSpotsView.notifyOnFocus(new Runnable(){

            @Override
            public void run() {
                LiveCPUView.this.lastFocused = LiveCPUView.this.hotSpotsView;
            }
        });
        this.reverseCallsView = new CPUTreeTableView(selection, true){

            @Override
            protected void performDefaultAction(ClientUtils.SourceCodeSelection userValue) {
                if (LiveCPUView.this.showSourceSupported()) {
                    LiveCPUView.this.showSource(userValue);
                }
            }

            @Override
            protected void populatePopup(JPopupMenu popup, Object value, ClientUtils.SourceCodeSelection userValue) {
                LiveCPUView.this.populatePopup(LiveCPUView.this.reverseCallsView, popup, value, userValue);
            }

            @Override
            protected void popupShowing() {
                LiveCPUView.this.popupShowing();
            }

            @Override
            protected void popupHidden() {
                LiveCPUView.this.popupHidden();
            }

            @Override
            protected boolean hasBottomFilterFindMargin() {
                return true;
            }
        };
        this.reverseCallsView.notifyOnFocus(new Runnable(){

            @Override
            public void run() {
                LiveCPUView.this.lastFocused = LiveCPUView.this.reverseCallsView;
            }
        });
        JExtendedSplitPane upperSplit = new JExtendedSplitPane(0){
            {
                BasicSplitPaneDivider divider;
                super(newOrientation);
                this.setBorder(null);
                this.setDividerSize(5);
                if (this.getUI() instanceof BasicSplitPaneUI && (divider = ((BasicSplitPaneUI)this.getUI()).getDivider()) != null) {
                    Color c = UIUtils.isNimbus() || UIUtils.isAquaLookAndFeel() ? UIUtils.getDisabledLineColor() : new JSeparator().getForeground();
                    divider.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, c));
                }
            }
        };
        upperSplit.setBorder(BorderFactory.createEmptyBorder());
        ((JSplitPane)upperSplit).setTopComponent(this.forwardCallsView);
        ((JSplitPane)upperSplit).setBottomComponent(this.hotSpotsView);
        upperSplit.setDividerLocation(0.5);
        upperSplit.setResizeWeight(0.5);
        JExtendedSplitPane lowerSplit = new JExtendedSplitPane(0){
            {
                BasicSplitPaneDivider divider;
                super(newOrientation);
                this.setBorder(null);
                this.setDividerSize(5);
                if (this.getUI() instanceof BasicSplitPaneUI && (divider = ((BasicSplitPaneUI)this.getUI()).getDivider()) != null) {
                    Color c = UIUtils.isNimbus() || UIUtils.isAquaLookAndFeel() ? UIUtils.getDisabledLineColor() : new JSeparator().getForeground();
                    divider.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, c));
                }
            }
        };
        lowerSplit.setBorder(BorderFactory.createEmptyBorder());
        ((JSplitPane)lowerSplit).setTopComponent(upperSplit);
        ((JSplitPane)lowerSplit).setBottomComponent(this.reverseCallsView);
        lowerSplit.setDividerLocation(0.66);
        lowerSplit.setResizeWeight(0.66);
        this.add((Component)lowerSplit, "Center");
    }

    private void registerActions() {
        ActionMap map = this.getActionMap();
        map.put("filter-action-key", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataView active = LiveCPUView.this.getLastFocused();
                if (active != null) {
                    active.activateFilter();
                }
            }
        });
        map.put("find-action-key", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataView active = LiveCPUView.this.getLastFocused();
                if (active != null) {
                    active.activateSearch();
                }
            }
        });
    }

    private DataView getLastFocused() {
        if (this.lastFocused != null && !this.lastFocused.isShowing()) {
            this.lastFocused = null;
        }
        if (this.lastFocused == null) {
            if (this.forwardCallsView.isShowing()) {
                this.lastFocused = this.forwardCallsView;
            } else if (this.hotSpotsView.isShowing()) {
                this.lastFocused = this.hotSpotsView;
            } else if (this.reverseCallsView.isShowing()) {
                this.lastFocused = this.reverseCallsView;
            }
        }
        return this.lastFocused;
    }

    private void populatePopup(final DataView invoker, JPopupMenu popup, final Object value, final ClientUtils.SourceCodeSelection userValue) {
        JMenu threads;
        int column;
        ProfilerTreeTable ttable;
        JMenuItem[] customItems;
        if (this.showSourceSupported()) {
            popup.add(new JMenuItem(CPUView.ACTION_GOTOSOURCE){
                {
                    super(x0);
                    this.setEnabled(userValue != null);
                    this.setFont(this.getFont().deriveFont(1));
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    LiveCPUView.this.showSource(userValue);
                }
            });
            popup.addSeparator();
        }
        if (this.profileMethodSupported()) {
            popup.add(new JMenuItem(CPUView.ACTION_PROFILE_METHOD){
                {
                    super(x0);
                    this.setEnabled(userValue != null && CPUTableView.isSelectable(userValue));
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    LiveCPUView.this.profileMethod(userValue);
                }
            });
        }
        if (this.profileClassSupported()) {
            popup.add(new JMenuItem(CPUView.ACTION_PROFILE_CLASS){
                {
                    super(x0);
                    this.setEnabled(userValue != null);
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    LiveCPUView.this.profileClass(userValue);
                }
            });
        }
        if (this.profileMethodSupported() || this.profileClassSupported()) {
            popup.addSeparator();
        }
        if ((customItems = invoker.createCustomMenuItems(this, value, userValue)) != null) {
            for (JMenuItem customItem : customItems) {
                popup.add(customItem);
            }
            popup.addSeparator();
        }
        this.customizeNodePopup(invoker, popup, value, userValue);
        if (invoker == this.forwardCallsView) {
            ttable = (ProfilerTreeTable)this.forwardCallsView.getResultsComponent();
            column = ttable.convertColumnIndexToView(ttable.getMainColumn());
            final String searchString = ttable.getStringValue((TreeNode)value, column);
            popup.add(new JMenuItem(CPUView.FIND_IN_HOTSPOTS){
                {
                    super(x0);
                    this.setEnabled(userValue != null);
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    ProfilerTable table = LiveCPUView.this.hotSpotsView.getResultsComponent();
                    if (SearchUtils.findString(table, searchString)) {
                        LiveCPUView.this.hotSpotsView.setVisible(true);
                        LiveCPUView.this.foundInHotSpots();
                        table.requestFocusInWindow();
                    }
                }
            });
            popup.add(new JMenuItem(CPUView.FIND_IN_REVERSECALLS){
                {
                    super(x0);
                    this.setEnabled(userValue != null);
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    ProfilerTreeTable table = (ProfilerTreeTable)LiveCPUView.this.reverseCallsView.getResultsComponent();
                    if (SearchUtils.findString(table, searchString, true, true, LiveCPUView.createSearchHelper())) {
                        LiveCPUView.this.reverseCallsView.setVisible(true);
                        LiveCPUView.this.foundInReverseCalls();
                        table.requestFocusInWindow();
                    }
                }
            });
            popup.addSeparator();
            threads = new JMenu(CPUView.SHOW_MENU);
            popup.add(threads);
            threads.add(new JMenuItem(CPUView.SHOW_THREAD_ITEM){
                {
                    super(x0);
                    this.setEnabled(!LiveCPUView.this.mergedThreads && LiveCPUView.this.threadsSelector != null && value instanceof PrestimeCPUCCTNode && LiveCPUView.this.snapshot.getNThreads() > 1 && (LiveCPUView.this.selectedThreads == null || LiveCPUView.this.selectedThreads.size() > 1));
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    PrestimeCPUCCTNode thread = (PrestimeCPUCCTNode)value;
                    LiveCPUView.this.threadsSelector.addThread(thread.getThreadId(), true);
                }
            });
            threads.add(new JMenuItem(CPUView.HIDE_THREAD_ITEM){
                {
                    super(x0);
                    this.setEnabled(!LiveCPUView.this.mergedThreads && LiveCPUView.this.threadsSelector != null && value instanceof PrestimeCPUCCTNode && LiveCPUView.this.snapshot.getNThreads() > 1 && (LiveCPUView.this.selectedThreads == null || LiveCPUView.this.selectedThreads.size() > 1));
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    PrestimeCPUCCTNode thread = (PrestimeCPUCCTNode)value;
                    LiveCPUView.this.threadsSelector.removeThread(thread.getThreadId());
                }
            });
            JMenu expand = new JMenu(CPUView.EXPAND_MENU);
            popup.add(expand);
            expand.add(new JMenuItem(CPUView.EXPAND_PLAIN_ITEM){

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    ttable.expandPlainPath(ttable.getSelectedRow(), 2);
                }
            });
            expand.add(new JMenuItem(CPUView.EXPAND_TOPMOST_ITEM){

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    ttable.expandFirstPath(ttable.getSelectedRow());
                }
            });
            expand.addSeparator();
            expand.add(new JMenuItem(CPUView.COLLAPSE_CHILDREN_ITEM){

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    ttable.collapseChildren(ttable.getSelectedRow());
                }
            });
            expand.add(new JMenuItem(CPUView.COLLAPSE_ALL_ITEM){

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    ttable.collapseAll();
                }
            });
        } else if (invoker == this.hotSpotsView) {
            final String searchString = value.toString().replace("(", " (");
            popup.add(new JMenuItem(CPUView.FIND_IN_FORWARDCALLS){
                {
                    super(x0);
                    this.setEnabled(userValue != null);
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    ProfilerTable table = LiveCPUView.this.forwardCallsView.getResultsComponent();
                    if (SearchUtils.findString(table, searchString)) {
                        LiveCPUView.this.forwardCallsView.setVisible(true);
                        LiveCPUView.this.foundInForwardCalls();
                        table.requestFocusInWindow();
                    }
                }
            });
            popup.add(new JMenuItem(CPUView.FIND_IN_REVERSECALLS){
                {
                    super(x0);
                    this.setEnabled(userValue != null);
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    ProfilerTreeTable table = (ProfilerTreeTable)LiveCPUView.this.reverseCallsView.getResultsComponent();
                    if (SearchUtils.findString(table, searchString, true, true, LiveCPUView.createSearchHelper())) {
                        LiveCPUView.this.reverseCallsView.setVisible(true);
                        LiveCPUView.this.foundInReverseCalls();
                        table.requestFocusInWindow();
                    }
                }
            });
        } else if (invoker == this.reverseCallsView) {
            ttable = (ProfilerTreeTable)this.reverseCallsView.getResultsComponent();
            column = ttable.convertColumnIndexToView(ttable.getMainColumn());
            final String searchString = ttable.getStringValue((TreeNode)value, column);
            popup.add(new JMenuItem(CPUView.FIND_IN_FORWARDCALLS){
                {
                    super(x0);
                    this.setEnabled(userValue != null);
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    ProfilerTable table = LiveCPUView.this.forwardCallsView.getResultsComponent();
                    if (SearchUtils.findString(table, searchString)) {
                        LiveCPUView.this.forwardCallsView.setVisible(true);
                        LiveCPUView.this.foundInForwardCalls();
                        table.requestFocusInWindow();
                    }
                }
            });
            popup.add(new JMenuItem(CPUView.FIND_IN_HOTSPOTS){
                {
                    super(x0);
                    this.setEnabled(userValue != null);
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    ProfilerTable table = LiveCPUView.this.hotSpotsView.getResultsComponent();
                    if (SearchUtils.findString(table, searchString)) {
                        LiveCPUView.this.hotSpotsView.setVisible(true);
                        LiveCPUView.this.foundInHotSpots();
                        table.requestFocusInWindow();
                    }
                }
            });
            popup.addSeparator();
            threads = new JMenu(CPUView.SHOW_MENU);
            popup.add(threads);
            threads.add(new JMenuItem(CPUView.SHOW_THREAD_ITEM){
                {
                    super(x0);
                    this.setEnabled(!LiveCPUView.this.mergedThreads && LiveCPUView.this.threadsSelector != null && value instanceof PrestimeCPUCCTNode && LiveCPUView.this.snapshot.getNThreads() > 1 && (LiveCPUView.this.selectedThreads == null || LiveCPUView.this.selectedThreads.size() > 1));
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    PrestimeCPUCCTNode thread = (PrestimeCPUCCTNode)value;
                    LiveCPUView.this.threadsSelector.addThread(thread.getThreadId(), true);
                }
            });
            threads.add(new JMenuItem(CPUView.HIDE_THREAD_ITEM){
                {
                    super(x0);
                    this.setEnabled(!LiveCPUView.this.mergedThreads && LiveCPUView.this.threadsSelector != null && value instanceof PrestimeCPUCCTNode && LiveCPUView.this.snapshot.getNThreads() > 1 && (LiveCPUView.this.selectedThreads == null || LiveCPUView.this.selectedThreads.size() > 1));
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    PrestimeCPUCCTNode thread = (PrestimeCPUCCTNode)value;
                    LiveCPUView.this.threadsSelector.removeThread(thread.getThreadId());
                }
            });
            JMenu expand = new JMenu(CPUView.EXPAND_MENU);
            popup.add(expand);
            expand.add(new JMenuItem(CPUView.EXPAND_PLAIN_ITEM){

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    ttable.expandPlainPath(ttable.getSelectedRow(), 1);
                }
            });
            expand.add(new JMenuItem(CPUView.EXPAND_TOPMOST_ITEM){

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    ttable.expandFirstPath(ttable.getSelectedRow());
                }
            });
            expand.addSeparator();
            expand.add(new JMenuItem(CPUView.COLLAPSE_CHILDREN_ITEM){

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    ttable.collapseChildren(ttable.getSelectedRow());
                }
            });
            expand.add(new JMenuItem(CPUView.COLLAPSE_ALL_ITEM){

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    ttable.collapseAll();
                }
            });
        }
        popup.addSeparator();
        popup.add(invoker.createCopyMenuItem());
        popup.addSeparator();
        popup.add(new JMenuItem(FilterUtils.ACTION_FILTER){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                invoker.activateFilter();
            }
        });
        popup.add(new JMenuItem(SearchUtils.ACTION_FIND){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                invoker.activateSearch();
            }
        });
    }

    private static SearchUtils.TreeHelper createSearchHelper() {
        return new SearchUtils.TreeHelper(){

            @Override
            public int getNodeType(TreeNode tnode) {
                PrestimeCPUCCTNode node = (PrestimeCPUCCTNode)tnode;
                CCTNode parent = node.getParent();
                if (parent == null) {
                    return 100;
                }
                if (node.isThreadNode()) {
                    return 100;
                }
                if (node.isSelfTimeNode()) {
                    return 101;
                }
                if (((PrestimeCPUCCTNode)parent).isThreadNode() || parent.getParent() == null) {
                    return 11;
                }
                return 101;
            }
        };
    }

    protected void customizeNodePopup(DataView invoker, JPopupMenu popup, Object value, ClientUtils.SourceCodeSelection userValue) {
    }

    private synchronized ExecutorService getExecutor() {
        if (this.executor == null) {
            this.executor = Executors.newSingleThreadExecutor();
        }
        return this.executor;
    }
}

