/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.cpu;

import org.netbeans.lib.profiler.results.cpu.DiffFlatProfileContainer;
import org.netbeans.lib.profiler.ui.components.table.DiffBarCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.LabelTableCellRenderer;
import org.netbeans.lib.profiler.ui.cpu.CPUResUserActionsHandler;
import org.netbeans.lib.profiler.ui.cpu.SnapshotFlatProfilePanel;
import org.netbeans.lib.profiler.utils.StringUtils;

public class DiffFlatProfilePanel
extends SnapshotFlatProfilePanel {
    public DiffFlatProfilePanel(CPUResUserActionsHandler actionsHandler, Boolean sampling) {
        super(actionsHandler, sampling);
    }

    @Override
    protected boolean supportsReverseCallGraph() {
        return false;
    }

    @Override
    protected boolean supportsSubtreeCallGraph() {
        return false;
    }

    @Override
    protected Object computeValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return this.flatProfileContainer.getMethodNameAtRow(row);
            }
            case 1: {
                return new Float(this.flatProfileContainer.getTimeInMcs0AtRow(row));
            }
            case 2: {
                long value = this.flatProfileContainer.getTimeInMcs0AtRow(row);
                return (value > 0L ? "+" : "") + StringUtils.mcsTimeToString((long)value) + " ms";
            }
            case 3: {
                if (this.collectingTwoTimeStamps) {
                    long value = this.flatProfileContainer.getTimeInMcs1AtRow(row);
                    return (value > 0L ? "+" : "") + StringUtils.mcsTimeToString((long)value) + " ms";
                }
                long value = this.flatProfileContainer.getTotalTimeInMcs0AtRow(row);
                return (value > 0L ? "+" : "") + StringUtils.mcsTimeToString((long)value) + " ms";
            }
            case 4: {
                if (this.collectingTwoTimeStamps) {
                    long value = this.flatProfileContainer.getTotalTimeInMcs0AtRow(row);
                    return (value > 0L ? "+" : "") + StringUtils.mcsTimeToString((long)value) + " ms";
                }
                long value = this.flatProfileContainer.getNInvocationsAtRow(row);
                return (value > 0L ? "+" : "") + this.intFormat.format(value);
            }
            case 5: {
                long value = this.flatProfileContainer.getTotalTimeInMcs1AtRow(row);
                return (value > 0L ? "+" : "") + StringUtils.mcsTimeToString((long)value) + " ms";
            }
            case 6: {
                long value = this.flatProfileContainer.getNInvocationsAtRow(row);
                return (value > 0L ? "+" : "") + this.intFormat.format(value);
            }
        }
        return null;
    }

    @Override
    protected void initColumnsData() {
        super.initColumnsData();
        this.columnRenderers[1] = new DiffBarCellRenderer(0L, 0L);
        this.columnRenderers[2] = new LabelTableCellRenderer(11);
    }

    @Override
    protected void obtainResults() {
        super.obtainResults();
        DiffFlatProfileContainer container = (DiffFlatProfileContainer)this.flatProfileContainer;
        DiffBarCellRenderer renderer = (DiffBarCellRenderer)this.columnRenderers[1];
        renderer.setMinimum(container.getMinTime());
        renderer.setMaximum(container.getMaxTime());
    }
}

