/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.insane.live;

import java.lang.reflect.Field;
import org.netbeans.insane.impl.Root;
import org.netbeans.insane.impl.Utils;

public final class Path {
    private Object item;
    private Path nextElement;

    private Path(Object item, Path next) {
        this.item = item;
        this.nextElement = next;
    }

    public Object getObject() {
        return this.item;
    }

    public Path nextNode() {
        return this.nextElement;
    }

    public String describeReference() {
        return this.getField();
    }

    public static String describeObject(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof Class) {
            return obj.toString() + "@" + Integer.toHexString(System.identityHashCode(obj));
        }
        return obj.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(obj));
    }

    public String toString() {
        if (this.nextElement == null) {
            return Path.describeObject(this.item);
        }
        if (this.item instanceof Root) {
            return ((Root)this.item).describe() + "->\n" + this.nextElement.toString();
        }
        return Path.describeObject(this.item) + "-" + this.getField() + "->\n" + this.nextElement.toString();
    }

    private String getField() {
        Object target = this.nextElement.item;
        Class<?> cls = this.item.getClass();
        if (cls.isArray()) {
            assert (!cls.getComponentType().isPrimitive());
            Object[] arr = (Object[])this.item;
            for (int i = 0; i < arr.length; ++i) {
                if (arr[i] != target) continue;
                return "[" + i + "]";
            }
            return "<changed>";
        }
        while (cls != null) {
            Field[] flds = cls.getDeclaredFields();
            for (int i = 0; i < flds.length; ++i) {
                try {
                    Field act = flds[i];
                    if (act.getType().isPrimitive() || (act.getModifiers() & 8) != 0) continue;
                    act.setAccessible(true);
                    if (target != act.get(this.item)) continue;
                    return act.getName();
                }
                catch (Exception e) {
                    return "<error>";
                }
            }
            cls = cls.getSuperclass();
        }
        return "<changed>";
    }

    public int hashCode() {
        return System.identityHashCode(this.item);
    }

    public boolean equals(Object o) {
        return o instanceof Path && ((Path)o).item == this.item;
    }

    static {
        Utils.PATH_FACTORY = new Utils.PathFactory(){

            @Override
            public Path createPath(Object item, Path next) {
                return new Path(item, next);
            }
        };
    }
}

