/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.insane.scanner;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import org.netbeans.insane.scanner.ObjectMap;
import org.netbeans.insane.scanner.ScannerUtils;
import org.netbeans.insane.scanner.Visitor;

public final class SimpleXmlVisitor
implements Visitor {
    private static char[] pom = new char[0];
    private static Class CHAR_ARRAY = pom.getClass();
    private Writer writer;
    private IOException storedException;

    public SimpleXmlVisitor(File to) throws IOException {
        this.writer = new OutputStreamWriter(new FileOutputStream(to));
        this.writer.write("<insane>\n");
    }

    public void close() throws IOException {
        this.writer.write("</insane>\n");
        this.writer.close();
        if (this.storedException != null) {
            throw this.storedException;
        }
    }

    public void visitClass(Class cls) {
    }

    public void visitObject(ObjectMap map, Object obj) {
        try {
            if (CHAR_ARRAY == obj.getClass()) {
                char[] copy = (char[])((char[])obj).clone();
                for (int i = 0; i < copy.length; ++i) {
                    if (copy[i] < ' ') {
                        copy[i] = 46;
                    }
                    if (copy[i] >= '\u0080') {
                        copy[i] = 46;
                    }
                    if (copy[i] == '\'') {
                        copy[i] = 34;
                    }
                    if (copy[i] == '<') {
                        copy[i] = 95;
                    }
                    if (copy[i] != '&') continue;
                    copy[i] = 95;
                }
                this.writer.write("<object id='" + map.getID(obj) + "' type='" + obj.getClass().getName() + "' size='" + ScannerUtils.sizeOf(obj) + "' value='" + new String(copy) + "'/>\n");
            } else {
                this.writer.write("<object id='" + map.getID(obj) + "' type='" + obj.getClass().getName() + "' size='" + ScannerUtils.sizeOf(obj) + "'/>\n");
            }
        }
        catch (IOException ioe) {
            this.storedException = ioe;
        }
    }

    public void visitObjectReference(ObjectMap map, Object from, Object to, Field ref) {
        try {
            this.writer.write("<ref from='" + map.getID(from) + "' name='" + SimpleXmlVisitor.getFldName(ref) + "' to='" + map.getID(to) + "'/>\n");
        }
        catch (IOException ioe) {
            this.storedException = ioe;
        }
    }

    public void visitStaticReference(ObjectMap map, Object to, Field ref) {
        try {
            this.writer.write("<ref name='" + SimpleXmlVisitor.getFldName(ref) + "' to='" + map.getID(to) + "'/>\n");
        }
        catch (IOException ioe) {
            this.storedException = ioe;
        }
    }

    public void visitArrayReference(ObjectMap map, Object from, Object to, int index) {
        try {
            this.writer.write("<ref from='" + map.getID(from) + "' name='" + index + "' to='" + map.getID(to) + "'/>\n");
        }
        catch (IOException ioe) {
            this.storedException = ioe;
        }
    }

    private static String getFldName(Field fld) {
        return fld.getDeclaringClass().getName() + "." + fld.getName();
    }
}

