/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.presenters.render;

import com.sun.jna.Callback;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import org.netbeans.html.boot.spi.Fn;
import org.netbeans.html.presenters.render.InvokeLater;
import org.netbeans.html.presenters.render.JSC;
import org.netbeans.html.presenters.render.Show;

final class GTK
extends Show
implements InvokeLater {
    private final Fn.Presenter presenter;
    private final Runnable onPageLoad;
    private final Runnable onContext;
    private final boolean headless;
    private OnDestroy onDestroy;
    private OnLoad onLoad;
    private Pending pending;
    private String page;
    private Pointer jsContext;
    private NewWebView newWebView;
    private static Libs INSTANCE;

    GTK() {
        this(null, null, null, false);
    }

    GTK(Fn.Presenter p, Runnable onPageLoad, Runnable onContext, boolean hl) {
        this.onPageLoad = onPageLoad;
        this.presenter = p;
        this.headless = hl;
        this.onContext = onContext;
    }

    @Override
    public JSC jsc() {
        return GTK.INSTANCE.jsc;
    }

    @Override
    public Pointer jsContext() {
        return this.jsContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Libs getInstance(boolean[] initialized) {
        Class<GTK> clazz = GTK.class;
        synchronized (GTK.class) {
            if (INSTANCE == null) {
                INSTANCE = new Libs();
                initialized[0] = true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return INSTANCE;
        }
    }

    @Override
    public void show(URI url) throws IOException {
        Gtk gtk;
        this.page = url.toASCIIString();
        boolean[] justInitialized = new boolean[]{false};
        try {
            gtk = this.getInstance((boolean[])justInitialized).gtk;
        }
        catch (LinkageError e) {
            throw new IOException(e);
        }
        if (justInitialized[0]) {
            gtk.gtk_init(0, null);
            this.run();
            gtk.gtk_main();
        } else {
            GTK.INSTANCE.glib.g_idle_add(this, null);
        }
    }

    @Override
    public void run() {
        Pointer ctx;
        Libs libs = this.getInstance(null);
        Gdk gdk = libs.gdk;
        Gtk gtk = libs.gtk;
        WebKit webKit = libs.webKit;
        G g = libs.g;
        Pointer screen = gdk.gdk_screen_get_default();
        int primaryMonitor = gdk.gdk_screen_get_primary_monitor(screen);
        GRectangle size = new GRectangle();
        gdk.gdk_screen_get_monitor_geometry(screen, primaryMonitor, size);
        int height = (int)((double)size.height * 0.9);
        int width = (int)((double)size.width * 0.9);
        int x = (int)((double)size.width * 0.05) + size.x;
        int y = (int)((double)size.height * 0.05) + size.y;
        Pointer window = gtk.gtk_window_new(0);
        gtk.gtk_window_set_default_size(window, width, height);
        gtk.gtk_window_set_gravity(window, 5);
        gtk.gtk_window_move(window, x, y);
        Pointer scroll = gtk.gtk_scrolled_window_new(null, null);
        gtk.gtk_container_add(window, scroll);
        Pointer webView = webKit.webkit_web_view_new();
        gtk.gtk_container_add(scroll, webView);
        Pointer frame = webKit.webkit_web_view_get_main_frame(webView);
        this.jsContext = ctx = webKit.webkit_web_frame_get_global_context(frame);
        if (this.onContext != null) {
            this.onContext.run();
        }
        this.onLoad = new OnLoad(webView, libs, window, this.onPageLoad);
        g.g_signal_connect_data(webView, "notify::load-status", this.onLoad, null, null, 0);
        this.newWebView = new NewWebView(libs, this.headless);
        g.g_signal_connect_data(webView, "create-web-view", this.newWebView, window, null, 0);
        webKit.webkit_web_view_load_uri(webView, this.page);
        gtk.gtk_widget_grab_focus(webView);
        this.onDestroy = new OnDestroy();
        g.g_signal_connect_data(window, "destroy", this.onDestroy, null, null, 0);
        this.pending = new Pending();
        if (!this.headless) {
            gtk.gtk_widget_show_all(window);
        }
    }

    @Override
    public void execute(Runnable command) {
        this.pending.queue.add(command);
        if (Fn.activePresenter() == this.presenter) {
            try {
                this.pending.process();
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Cannot process " + command, ex);
            }
        } else {
            GLib glib = this.getInstance(null).glib;
            glib.g_idle_add(this.pending, null);
        }
    }

    static final class Libs {
        final Gtk gtk;
        final JSC jsc;
        final G g;
        final GLib glib;
        final Gdk gdk;
        final WebKit webKit;

        Libs() {
            ArrayList<Throwable> errors = new ArrayList<Throwable>();
            this.webKit = Libs.loadLibrary(WebKit.class, false, errors);
            this.jsc = Libs.loadLibrary(JSC.class, true, errors);
            if (!errors.isEmpty()) {
                throw this.linkageError(errors);
            }
            this.gtk = Libs.loadLibrary(Gtk.class, false, null);
            this.g = Libs.loadLibrary(G.class, false, errors);
            this.glib = Libs.loadLibrary(GLib.class, false, errors);
            this.gdk = Libs.loadLibrary(Gdk.class, false, errors);
            if (!errors.isEmpty()) {
                throw this.linkageError(errors);
            }
        }

        static <T> T loadLibrary(Class<T> type, boolean allowObjects, Collection<Throwable> errors) {
            String libName = System.getProperty("com.dukescript.presenters.renderer." + type.getSimpleName());
            if (libName == null) {
                if (type == JSC.class) {
                    libName = "javascriptcoregtk-3.0";
                } else if (type == GLib.class) {
                    libName = "glib-2.0";
                } else if (type == G.class) {
                    libName = "gobject-2.0";
                } else if (type == Gdk.class) {
                    libName = "gtk-3";
                } else if (type == Gtk.class) {
                    libName = "gtk-3";
                } else if (type == WebKit.class) {
                    libName = "webkitgtk-3.0";
                }
            }
            try {
                Object lib = Native.loadLibrary((String)libName, type, Collections.singletonMap("allow-objects", allowObjects));
                return type.cast(lib);
            }
            catch (LinkageError err) {
                if (errors != null) {
                    errors.add(err);
                    return null;
                }
                throw err;
            }
        }

        private LinkageError linkageError(List<Throwable> errors) {
            StringWriter sw = new StringWriter();
            String libraryPath = System.getProperty("java.library.path");
            sw.append("Java Library Path:");
            if (libraryPath != null) {
                for (String pathElement : libraryPath.split(File.pathSeparator)) {
                    sw.append("\n  Path ").append(pathElement);
                    File pathFile = new File(pathElement);
                    String[] libraries = pathFile.list();
                    if (libraries == null) continue;
                    for (String lib : libraries) {
                        sw.append("\n    ").append(lib);
                    }
                }
                sw.append("\n");
            }
            PrintWriter pw = new PrintWriter(sw);
            for (Throwable t : errors) {
                t.printStackTrace(pw);
            }
            sw.append("\nStatus:");
            sw.append("\n  jsc: " + this.jsc);
            sw.append("\n  g: " + this.g);
            sw.append("\n  glib: " + this.glib);
            sw.append("\n  gdk: " + this.gdk);
            sw.append("\n  webKit: " + this.webKit);
            return new LinkageError(sw.toString());
        }
    }

    private class Pending
    implements Callback {
        final Queue<Runnable> queue = new ConcurrentLinkedQueue<Runnable>();

        private Pending() {
        }

        public void process() throws Exception {
            Closeable c = Fn.activate((Fn.Presenter)GTK.this.presenter);
            try {
                Runnable r;
                while ((r = this.queue.poll()) != null) {
                    r.run();
                }
            }
            finally {
                c.close();
            }
        }
    }

    private static class OnDestroy
    implements Callback {
        private OnDestroy() {
        }

        public void signal() {
            System.exit(0);
        }
    }

    private static class OnLoad
    implements Callback {
        private final Libs libs;
        private final Pointer webView;
        private final Pointer window;
        private final Runnable onPageLoad;
        private Title title;

        public OnLoad(Pointer webView, Libs libs, Pointer window, Runnable onPageLoad) {
            this.webView = webView;
            this.window = window;
            this.libs = libs;
            this.onPageLoad = onPageLoad;
        }

        public void loadStatus() {
            int status = this.libs.webKit.webkit_web_view_get_load_status(this.webView);
            if (status == 2) {
                Pointer frame = this.libs.webKit.webkit_web_view_get_main_frame(this.webView);
                if (this.title == null) {
                    this.title = new Title(frame);
                    this.title.updateTitle();
                    this.libs.g.g_signal_connect_data(frame, "notify::title", this.title, null, null, 0);
                }
                if (this.onPageLoad != null) {
                    this.onPageLoad.run();
                }
            }
        }

        private class Title
        implements Callback {
            private final Pointer frame;

            public Title(Pointer frame) {
                this.frame = frame;
            }

            public void updateTitle() {
                String title = ((OnLoad)OnLoad.this).libs.webKit.webkit_web_frame_get_title(this.frame);
                if (title == null) {
                    title = "DukeScript Application";
                }
                ((OnLoad)OnLoad.this).libs.gtk.gtk_window_set_title(OnLoad.this.window, title);
            }
        }
    }

    private static class NewWebView
    implements Callback {
        private final Libs libs;
        private final boolean headless;
        private final Collection<OnLoad> onLoads = new HashSet<OnLoad>();

        NewWebView(Libs libs, boolean headless) {
            this.libs = libs;
            this.headless = headless;
        }

        public Pointer createWebView(Pointer orig, Pointer frame, Pointer origWindow) {
            IntByReference x = new IntByReference(0);
            IntByReference y = new IntByReference(0);
            IntByReference width = new IntByReference(0);
            IntByReference height = new IntByReference(0);
            Gtk gtk = this.libs.gtk;
            gtk.gtk_window_get_position(origWindow, x, y);
            gtk.gtk_window_get_size(origWindow, width, height);
            int tenthWidth = width.getValue() / 10;
            int tenthHeight = height.getValue() / 10;
            Pointer window = gtk.gtk_window_new(0);
            gtk.gtk_window_set_default_size(window, width.getValue() - 2 * tenthWidth, height.getValue() - 2 * tenthHeight);
            gtk.gtk_window_set_gravity(window, 5);
            gtk.gtk_window_move(window, x.getValue() + tenthWidth, y.getValue() + tenthHeight);
            Pointer scroll = gtk.gtk_scrolled_window_new(null, null);
            gtk.gtk_container_add(window, scroll);
            Pointer webView = this.libs.webKit.webkit_web_view_new();
            gtk.gtk_container_add(scroll, webView);
            gtk.gtk_widget_grab_focus(webView);
            OnLoad onLoad = new OnLoad(webView, this.libs, window, null);
            this.onLoads.add(onLoad);
            this.libs.g.g_signal_connect_data(webView, "notify::load-status", onLoad, null, null, 0);
            if (!this.headless) {
                gtk.gtk_widget_show_all(window);
                gtk.gtk_window_present(window);
            }
            return webView;
        }
    }

    public static interface WebKit
    extends Library {
        public Pointer webkit_web_view_new();

        public void webkit_web_view_load_uri(Pointer var1, String var2);

        public Pointer webkit_web_page_frame_get_javascript_context_for_script_world(Pointer var1, Pointer var2);

        public int webkit_web_view_get_load_status(Pointer var1);

        public Pointer webkit_web_view_get_main_frame(Pointer var1);

        public Pointer webkit_web_frame_get_global_context(Pointer var1);

        public String webkit_web_frame_get_title(Pointer var1);
    }

    public static class GRectangle
    extends Structure {
        public int x;
        public int y;
        public int width;
        public int height;

        protected List getFieldOrder() {
            return Arrays.asList("x", "y", "width", "height");
        }
    }

    public static interface Gdk
    extends Library {
        public int gdk_screen_get_primary_monitor(Pointer var1);

        public Pointer gdk_screen_get_default();

        public void gdk_screen_get_monitor_geometry(Pointer var1, int var2, GRectangle var3);
    }

    public static interface Gtk
    extends Library {
        public void gtk_init(int var1, String[] var2);

        public Pointer gtk_window_new(int var1);

        public Pointer gtk_scrolled_window_new(Pointer var1, Pointer var2);

        public void gtk_window_get_position(Pointer var1, IntByReference var2, IntByReference var3);

        public void gtk_window_get_size(Pointer var1, IntByReference var2, IntByReference var3);

        public void gtk_window_set_default_size(Pointer var1, int var2, int var3);

        public void gtk_window_set_title(Pointer var1, String var2);

        public void gtk_widget_show_all(Pointer var1);

        public void gtk_window_set_gravity(Pointer var1, int var2);

        public void gtk_window_move(Pointer var1, int var2, int var3);

        public void gtk_container_add(Pointer var1, Pointer var2);

        public void gtk_widget_grab_focus(Pointer var1);

        public void gtk_widget_destroy(Pointer var1);

        public void gtk_window_present(Pointer var1);

        public void gtk_main();

        public void gtk_main_quit();

        public void gtk_widget_set_size_request(Pointer var1, int var2, int var3);

        public void gtk_window_set_position(Pointer var1, int var2);

        public Pointer gtk_button_new_with_label(String var1);

        public void gtk_container_set_border_width(Pointer var1, int var2);
    }

    public static interface G
    extends Library {
        public void g_signal_connect_data(Pointer var1, String var2, Callback var3, Pointer var4, Void var5, int var6);
    }

    public static interface GLib
    extends Library {
        public void g_idle_add(Callback var1, Pointer var2);
    }
}

