/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.presenters.render;

import com.sun.jna.Pointer;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URI;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.html.boot.spi.Fn;
import org.netbeans.html.presenters.render.Cocoa;
import org.netbeans.html.presenters.render.GTK;
import org.netbeans.html.presenters.render.JSC;

public abstract class Show {
    static final Logger LOG = Logger.getLogger(Show.class.getName());

    Show() {
    }

    public static void show(String impl, URI page) throws IOException {
        if (impl == null || "default".equals(impl)) {
            Show.showOneByOne(page);
            return;
        }
        Show.showOne(impl, page);
    }

    private static void showOneByOne(URI page) throws IOException {
        try {
            String ui = System.getProperty("os.name").contains("Mac") ? "Cocoa" : "GTK";
            Show.show(ui, page);
            return;
        }
        catch (IOException ex) {
            IOException one = ex;
            try {
                Show.show("AWT", page);
                return;
            }
            catch (IOException ex2) {
                IOException two = ex2;
                try {
                    Show.show("xdg-open", page);
                }
                catch (IOException ex3) {
                    two.initCause(one);
                    ex3.initCause(two);
                    throw ex3;
                }
                return;
            }
        }
    }

    private static void showOne(String impl, URI page) throws IOException {
        impl.getClass();
        try {
            Class<?> c = Class.forName(Show.class.getPackage().getName() + '.' + impl);
            Show show = (Show)c.newInstance();
            show.show(page);
        }
        catch (ClassNotFoundException ex) {
            LOG.log(Level.INFO, "Trying command line execution of {0}", impl);
            Object[] cmdArr = new String[]{impl, page.toString()};
            LOG.log(Level.INFO, "Launching {0}", Arrays.toString(cmdArr));
            Process process = new ProcessBuilder(new String[0]).inheritIO().command((String[])cmdArr).start();
            try {
                process.waitFor();
            }
            catch (InterruptedException ex1) {
                throw (InterruptedIOException)new InterruptedIOException().initCause(ex1);
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception | LinkageError ex) {
            throw new IOException(ex);
        }
    }

    public static Show open(Fn.Presenter presenter, Runnable onPageLoad, Runnable onContext, boolean headless) {
        boolean isMac = System.getProperty("os.name").contains("Mac");
        return isMac ? new Cocoa(presenter, onPageLoad, onContext, headless) : new GTK(presenter, onPageLoad, onContext, headless);
    }

    public abstract void show(URI var1) throws IOException;

    public abstract JSC jsc();

    public abstract Pointer jsContext();

    public abstract void execute(Runnable var1);
}

