/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.json.impl;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.java.html.BrwsrCtx;
import org.netbeans.html.context.spi.Contexts;
import org.netbeans.html.json.impl.Bindings;
import org.netbeans.html.json.impl.JSONList;
import org.netbeans.html.json.impl.PropertyBindingAccessor;
import org.netbeans.html.json.impl.RcvrJSON;
import org.netbeans.html.json.spi.FunctionBinding;
import org.netbeans.html.json.spi.JSONCall;
import org.netbeans.html.json.spi.PropertyBinding;
import org.netbeans.html.json.spi.Proto;
import org.netbeans.html.json.spi.Technology;
import org.netbeans.html.json.spi.Transfer;
import org.netbeans.html.json.spi.WSTransfer;

public final class JSON {
    private static final Map<Class, Proto.Type<?>> modelTypes = new HashMap();

    private JSON() {
    }

    static Technology<?> findTechnology(BrwsrCtx c) {
        Technology t = (Technology)Contexts.find((BrwsrCtx)c, Technology.class);
        return t == null ? EmptyTech.EMPTY : t;
    }

    public static Transfer findTransfer(BrwsrCtx c) {
        Transfer t = (Transfer)Contexts.find((BrwsrCtx)c, Transfer.class);
        return t == null ? EmptyTech.EMPTY : t;
    }

    public static WSTransfer<?> findWSTransfer(BrwsrCtx c) {
        WSTransfer t = (WSTransfer)Contexts.find((BrwsrCtx)c, WSTransfer.class);
        return t == null ? EmptyTech.EMPTY : t;
    }

    public static void extract(BrwsrCtx c, Object value, String[] props, Object[] values) {
        Transfer t = JSON.findTransfer(c);
        t.extract(value, props, values);
    }

    private static Object getProperty(BrwsrCtx c, Object obj, String prop) {
        if (prop == null) {
            return obj;
        }
        String[] arr = new String[]{prop};
        Object[] val = new Object[]{null};
        JSON.extract(c, obj, arr, val);
        return val[0];
    }

    public static String toJSON(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof Enum) {
            value = value.toString();
        }
        if (value instanceof Character) {
            value = Character.toString(((Character)value).charValue());
        }
        if (value instanceof String) {
            String s = (String)value;
            int len = s.length();
            StringBuilder sb = new StringBuilder(len + 10);
            sb.append('\"');
            block7: for (int i = 0; i < len; ++i) {
                char ch = s.charAt(i);
                switch (ch) {
                    case '\"': {
                        sb.append("\\\"");
                        continue block7;
                    }
                    case '\n': {
                        sb.append("\\n");
                        continue block7;
                    }
                    case '\r': {
                        sb.append("\\r");
                        continue block7;
                    }
                    case '\t': {
                        sb.append("\\t");
                        continue block7;
                    }
                    case '\\': {
                        sb.append("\\\\");
                        continue block7;
                    }
                    default: {
                        sb.append(ch);
                    }
                }
            }
            sb.append('\"');
            return sb.toString();
        }
        return value.toString();
    }

    public static String toString(BrwsrCtx c, Object obj, String prop) {
        return (obj = JSON.getProperty(c, obj, prop)) == null ? null : obj.toString();
    }

    public static Number toNumber(BrwsrCtx c, Object obj, String prop) {
        if ((obj = JSON.getProperty(c, obj, prop)) instanceof Character) {
            obj = (int)((Character)obj).charValue();
        }
        if (!(obj instanceof Number)) {
            obj = Double.NaN;
        }
        return (Number)obj;
    }

    public static <M> M toModel(BrwsrCtx c, Class<M> aClass, Object data, Object object) {
        Technology<?> t = JSON.findTechnology(c);
        M o = t.toModel(aClass, data);
        return aClass.cast(o);
    }

    public static boolean isSame(int a, int b) {
        return a == b;
    }

    public static boolean isSame(double a, double b) {
        return a == b;
    }

    public static boolean isSame(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public static int hashPlus(Object o, int h) {
        return o == null ? h : h ^ o.hashCode();
    }

    public static <T> T extractValue(Class<T> type, Object val) {
        if (Number.class.isAssignableFrom(type)) {
            val = JSON.numberValue(val);
        }
        if (Boolean.class == type) {
            val = JSON.boolValue(val);
        }
        if (String.class == type) {
            val = JSON.stringValue(val);
        }
        if (Character.class == type) {
            val = JSON.charValue(val);
        }
        if (Integer.class == type) {
            val = val instanceof Number ? ((Number)val).intValue() : 0;
        }
        if (Long.class == type) {
            val = val instanceof Number ? ((Number)val).longValue() : 0L;
        }
        if (Short.class == type) {
            val = val instanceof Number ? ((Number)val).shortValue() : (short)0;
        }
        if (Byte.class == type) {
            val = val instanceof Number ? ((Number)val).byteValue() : (byte)0;
        }
        if (Double.class == type) {
            val = val instanceof Number ? ((Number)val).doubleValue() : Double.NaN;
        }
        if (Float.class == type) {
            val = Float.valueOf(val instanceof Number ? ((Number)val).floatValue() : Float.NaN);
        }
        return type.cast(val);
    }

    static boolean isNumeric(Object val) {
        return val instanceof Integer || val instanceof Long || val instanceof Short || val instanceof Byte;
    }

    public static String stringValue(Object val) {
        if (val instanceof Boolean) {
            return (Boolean)val != false ? "true" : "false";
        }
        if (JSON.isNumeric(val)) {
            return Long.toString(((Number)val).longValue());
        }
        if (val instanceof Float) {
            return Float.toString(((Float)val).floatValue());
        }
        if (val instanceof Double) {
            return Double.toString((Double)val);
        }
        return (String)val;
    }

    public static Number numberValue(Object val) {
        if (val instanceof String) {
            try {
                return Double.valueOf((String)val);
            }
            catch (NumberFormatException ex) {
                return Double.NaN;
            }
        }
        if (val instanceof Boolean) {
            return (Boolean)val != false ? 1 : 0;
        }
        return (Number)val;
    }

    public static Character charValue(Object val) {
        if (val instanceof Number) {
            return Character.valueOf(Character.toChars(JSON.numberValue(val).intValue())[0]);
        }
        if (val instanceof Boolean) {
            return Character.valueOf((Boolean)val != false ? (char)'\u0001' : '\u0000');
        }
        if (val instanceof String) {
            String s = (String)val;
            return Character.valueOf(s.isEmpty() ? (char)'\u0000' : s.charAt(0));
        }
        return (Character)val;
    }

    public static Boolean boolValue(Object val) {
        if (val instanceof String) {
            return Boolean.parseBoolean((String)val);
        }
        if (val instanceof Number) {
            return JSON.numberValue(val).doubleValue() != 0.0;
        }
        return Boolean.TRUE.equals(val);
    }

    public static Object find(Object object, Bindings model) {
        if (object == null) {
            return null;
        }
        if (object instanceof JSONList) {
            return ((JSONList)object).koData();
        }
        if (object instanceof Collection) {
            return JSONList.koData((Collection)object, model);
        }
        if (object instanceof String || object instanceof Boolean || object instanceof Number || object instanceof Character || object instanceof Enum) {
            return object;
        }
        Proto proto = JSON.findProto(object);
        if (proto == null) {
            return null;
        }
        Bindings b = PropertyBindingAccessor.getBindings(proto, true);
        return b == null ? null : b.koData();
    }

    private static Proto findProto(Object object) {
        Proto.Type<?> type = JSON.findType(object.getClass());
        if (type == null) {
            return null;
        }
        Proto proto = PropertyBindingAccessor.protoFor(type, object);
        return proto;
    }

    public static Object find(Object object) {
        return JSON.find(object, null);
    }

    public static void applyBindings(Object object, String id) {
        Proto proto = JSON.findProto(object);
        if (proto == null) {
            throw new IllegalArgumentException("Not a model: " + object.getClass());
        }
        proto.applyBindings(id);
    }

    public static void register(Class c, Proto.Type<?> type) {
        modelTypes.put(c, type);
    }

    public static boolean isModel(Class<?> clazz) {
        return JSON.findType(clazz) != null;
    }

    static Proto.Type<?> findType(Class<?> clazz) {
        for (int i = 0; i < 2; ++i) {
            Proto.Type<?> from = modelTypes.get(clazz);
            if (from != null) {
                return from;
            }
            JSON.initClass(clazz);
        }
        return null;
    }

    public static <Model> Model bindTo(Model model, BrwsrCtx c) {
        Proto.Type<?> from = JSON.findType(model.getClass());
        if (from == null) {
            throw new IllegalArgumentException();
        }
        return (Model)PropertyBindingAccessor.clone(from, model, c);
    }

    public static <T> T readStream(BrwsrCtx c, Class<T> modelClazz, InputStream data, Collection<? super T> collectTo) throws IOException {
        Transfer tr = JSON.findTransfer(c);
        Object rawJSON = tr.toJSON(data);
        if (rawJSON instanceof Object[]) {
            Object[] arr = (Object[])rawJSON;
            if (collectTo != null) {
                for (int i = 0; i < arr.length; ++i) {
                    collectTo.add(JSON.read(c, modelClazz, arr[i]));
                }
                return null;
            }
            if (arr.length == 0) {
                throw new EOFException("Recieved an empty array");
            }
            rawJSON = arr[0];
        }
        T res = JSON.read(c, modelClazz, rawJSON);
        if (collectTo != null) {
            collectTo.add(res);
        }
        return res;
    }

    public static <T> T read(BrwsrCtx c, Class<T> modelClazz, Object data) {
        if (data == null) {
            return null;
        }
        if (modelClazz == String.class) {
            return modelClazz.cast(data.toString());
        }
        for (int i = 0; i < 2; ++i) {
            Proto.Type<?> from = modelTypes.get(modelClazz);
            if (from != null) {
                return modelClazz.cast(PropertyBindingAccessor.readFrom(from, c, data));
            }
            JSON.initClass(modelClazz);
        }
        throw new NullPointerException();
    }

    static void initClass(Class<?> modelClazz) {
        try {
            ClassLoader l;
            try {
                l = modelClazz.getClassLoader();
            }
            catch (SecurityException ex) {
                l = null;
            }
            if (l != null) {
                Class.forName(modelClazz.getName(), true, l);
            }
            modelClazz.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static final class EmptyTech
    implements Technology<Object>,
    Transfer,
    WSTransfer<Void> {
        private static final EmptyTech EMPTY = new EmptyTech();

        private EmptyTech() {
        }

        @Override
        public Object wrapModel(Object model) {
            return model;
        }

        @Override
        public void valueHasMutated(Object data, String propertyName) {
        }

        @Override
        public void bind(PropertyBinding b, Object model, Object data) {
        }

        @Override
        public void expose(FunctionBinding fb, Object model, Object d) {
        }

        @Override
        public void applyBindings(Object data) {
        }

        @Override
        public Object wrapArray(Object[] arr) {
            return arr;
        }

        @Override
        public void extract(Object obj, String[] props, Object[] values) {
            for (int i = 0; i < values.length; ++i) {
                values[i] = null;
            }
        }

        @Override
        public void loadJSON(JSONCall call) {
            call.notifyError(new UnsupportedOperationException());
        }

        @Override
        public <M> M toModel(Class<M> modelClass, Object data) {
            return modelClass.cast(data);
        }

        @Override
        public Object toJSON(InputStream is) throws IOException {
            throw new IOException("Not supported");
        }

        @Override
        public void runSafe(Runnable r) {
            r.run();
        }

        @Override
        public Void open(String url, JSONCall onReply) {
            onReply.notifyError(new UnsupportedOperationException("WebSockets not supported!"));
            return null;
        }

        @Override
        public void send(Void socket, JSONCall data) {
        }

        @Override
        public void close(Void socket) {
        }
    }

    private static final class WSImpl<Socket>
    extends WS {
        private final WSTransfer<Socket> trans;
        private final RcvrJSON rcvr;
        private Socket socket;
        private String prevURL;

        private WSImpl(WSTransfer<Socket> trans, RcvrJSON rcvr) {
            this.trans = trans;
            this.rcvr = rcvr;
        }

        @Override
        public void send(BrwsrCtx ctx, String headers, String url, Object data) {
            Socket s = this.socket;
            if (s == null) {
                if (data != null) {
                    throw new IllegalStateException("WebSocket is not opened yet. Call with null data, was: " + data);
                }
                JSONCall call = PropertyBindingAccessor.createCall(ctx, this.rcvr, headers, url, null, "WebSocket", null);
                this.socket = this.trans.open(url, call);
                this.prevURL = url;
                return;
            }
            if (data == null) {
                this.trans.close(s);
                this.socket = null;
                return;
            }
            if (!this.prevURL.equals(url)) {
                throw new IllegalStateException("Can't call to different URL " + url + " was: " + this.prevURL + "!" + " Close the socket by calling it will null data first!");
            }
            JSONCall call = PropertyBindingAccessor.createCall(ctx, this.rcvr, headers, this.prevURL, null, "WebSocket", data);
            this.trans.send(s, call);
        }
    }

    public static abstract class WS {
        private WS() {
        }

        public abstract void send(BrwsrCtx var1, String var2, String var3, Object var4);

        public static <Socket> WS create(WSTransfer<Socket> t, RcvrJSON r) {
            return new WSImpl(t, r);
        }
    }
}

