/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.html.json.spi;

import java.io.IOException;
import java.io.OutputStream;
import net.java.html.BrwsrCtx;
import org.netbeans.html.json.impl.RcvrJSON;

public final class JSONCall {
    private final RcvrJSON whenDone;
    private final String urlBefore;
    private final String urlAfter;
    private final String method;
    private final Object data;
    private final BrwsrCtx ctx;

    JSONCall(BrwsrCtx ctx, RcvrJSON whenDone, String urlBefore, String urlAfter, String method, Object data) {
        this.ctx = ctx;
        this.whenDone = whenDone;
        this.urlBefore = urlBefore;
        this.urlAfter = urlAfter;
        this.method = method;
        this.data = data;
    }

    public boolean isDoOutput() {
        return this.data != null;
    }

    public void writeData(OutputStream os) throws IOException {
        if (this.data == null) {
            throw new IOException("No data!");
        }
        os.write(this.data.toString().getBytes("UTF-8"));
        os.flush();
    }

    public String getMethod() {
        return this.method;
    }

    public boolean isJSONP() {
        return this.urlAfter != null;
    }

    public String composeURL(String jsonpCallback) {
        if (this.urlAfter == null != (jsonpCallback == null)) {
            throw new IllegalStateException();
        }
        if (this.urlAfter != null) {
            return this.urlBefore + jsonpCallback + this.urlAfter;
        }
        return this.urlBefore;
    }

    public void notifySuccess(Object result) {
        if (result == null) {
            this.dispatch(RcvrJSON.MsgEvnt.createOpen());
        } else {
            this.dispatch(RcvrJSON.MsgEvnt.createMessage(result));
        }
    }

    public void notifyError(Throwable error) {
        if (error == null) {
            this.dispatch(RcvrJSON.MsgEvnt.createClose());
        } else {
            this.dispatch(RcvrJSON.MsgEvnt.createError(error));
        }
    }

    private void dispatch(final RcvrJSON.MsgEvnt ev) {
        this.ctx.execute(new Runnable(){

            @Override
            public void run() {
                ev.dispatch(JSONCall.this.whenDone);
            }
        });
    }

    public String getMessage() {
        return this.data.toString();
    }
}

