/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.html.json.spi;

import java.util.Collection;
import java.util.List;
import net.java.html.BrwsrCtx;
import org.apidesign.html.json.spi.FunctionBinding;
import org.apidesign.html.json.spi.PropertyBinding;
import org.netbeans.html.json.impl.Bindings;
import org.netbeans.html.json.impl.JSON;
import org.netbeans.html.json.impl.JSONList;
import org.netbeans.html.json.impl.RcvrJSON;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Proto {
    private final Object obj;
    private final Type type;
    private final BrwsrCtx context;
    private boolean locked;
    private Bindings ko;

    Proto(Object obj, Type type, BrwsrCtx context) {
        this.obj = obj;
        this.type = type;
        this.context = context;
    }

    public BrwsrCtx getContext() {
        return this.context;
    }

    public void acquireLock() throws IllegalStateException {
        if (this.locked) {
            throw new IllegalStateException();
        }
        this.locked = true;
    }

    public void verifyUnlocked() throws IllegalStateException {
        if (this.locked) {
            throw new IllegalStateException();
        }
    }

    public void releaseLock() {
        this.locked = false;
    }

    public void valueHasMutated(String propName) {
        if (this.ko != null) {
            this.ko.valueHasMutated(propName);
        }
    }

    public void applyBindings() {
        this.initBindings().applyBindings();
    }

    public void runInBrowser(Runnable run) {
        JSON.runInBrowser(this.context, run);
    }

    public void initTo(Collection<?> to, Object array) {
        if (this.ko != null) {
            throw new IllegalStateException();
        }
        if (to instanceof JSONList) {
            ((JSONList)to).init(array);
        } else {
            JSONList.init(to, array);
        }
    }

    public void extract(Object json, String[] props, Object[] values) {
        JSON.extract(this.context, json, props, values);
    }

    public <T> T read(Class<T> modelClass, Object data) {
        return JSON.read(this.context, modelClass, data);
    }

    public void loadJSON(final int index, String urlBefore, String urlAfter, String method, Object data) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Rcvr
        extends RcvrJSON {
            Rcvr() {
            }

            @Override
            protected void onMessage(RcvrJSON.MsgEvnt msg) {
                Proto.this.type.onMessage(Proto.this.obj, index, 1, msg.getValues());
            }

            @Override
            protected void onError(RcvrJSON.MsgEvnt msg) {
                Proto.this.type.onMessage(Proto.this.obj, index, 2, msg.getException());
            }
        }
        JSON.loadJSON(this.context, new Rcvr(), urlBefore, urlAfter, method, data);
    }

    public Object wsOpen(final int index, String url, Object data) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class WSrcvr
        extends RcvrJSON {
            WSrcvr() {
            }

            @Override
            protected void onError(RcvrJSON.MsgEvnt msg) {
                Proto.this.type.onMessage(Proto.this.obj, index, 2, msg.getException());
            }

            @Override
            protected void onMessage(RcvrJSON.MsgEvnt msg) {
                Proto.this.type.onMessage(Proto.this.obj, index, 1, msg.getValues());
            }

            @Override
            protected void onClose(RcvrJSON.MsgEvnt msg) {
                Proto.this.type.onMessage(Proto.this.obj, index, 3, null);
            }

            @Override
            protected void onOpen(RcvrJSON.MsgEvnt msg) {
                Proto.this.type.onMessage(Proto.this.obj, index, 0, null);
            }
        }
        return JSON.openWS(this.context, new WSrcvr(), url, data);
    }

    public void wsSend(Object webSocket, String url, Object data) {
        ((JSON.WS)webSocket).send(this.context, url, data);
    }

    public String toString(Object data, String propName) {
        return JSON.toString(this.context, data, propName);
    }

    public Number toNumber(Object data, String propName) {
        return JSON.toNumber(this.context, data, propName);
    }

    public <T> T toModel(Class<T> type, Object data) {
        return JSON.toModel(this.context, type, data, null);
    }

    public <T> List<T> createList(String propName, int onChange, String ... dependingProps) {
        return new JSONList(this, propName, onChange, dependingProps);
    }

    public <T> void cloneList(Collection<T> to, BrwsrCtx ctx, Collection<T> from) {
        Boolean isModel = null;
        for (T t : from) {
            if (isModel == null) {
                isModel = JSON.isModel(t.getClass());
            }
            if (isModel.booleanValue()) {
                to.add(JSON.bindTo(t, ctx));
                continue;
            }
            to.add(t);
        }
    }

    final Bindings initBindings() {
        if (this.ko == null) {
            Bindings<?> b = Bindings.apply(this.context, this.obj);
            PropertyBinding[] pb = new PropertyBinding[this.type.propertyNames.length];
            for (int i = 0; i < pb.length; ++i) {
                pb[i] = b.registerProperty(this.type.propertyNames[i], i, this.obj, this.type, this.type.propertyReadOnly[i]);
            }
            FunctionBinding[] fb = new FunctionBinding[this.type.functions.length];
            for (int i = 0; i < fb.length; ++i) {
                fb[i] = FunctionBinding.registerFunction(this.type.functions[i], i, this.obj, this.type);
            }
            this.ko = b;
            b.finish(this.obj, pb, fb);
        }
        return this.ko;
    }

    final Bindings getBindings() {
        return this.ko;
    }

    final void onChange(int index) {
        this.type.onChange(this.obj, index);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Type<Model> {
        private final Class<Model> clazz;
        private final String[] propertyNames;
        private final boolean[] propertyReadOnly;
        private final String[] functions;

        protected Type(Class<Model> clazz, Class<?> modelFor, int properties, int functions) {
            assert (this.getClass().getName().endsWith("$Html4JavaType"));
            try {
                assert (this.getClass().getDeclaringClass() == clazz);
            }
            catch (SecurityException ex) {
                // empty catch block
            }
            this.clazz = clazz;
            this.propertyNames = new String[properties];
            this.propertyReadOnly = new boolean[properties];
            this.functions = new String[functions];
            JSON.register(clazz, this);
        }

        protected final void registerProperty(String name, int index, boolean readOnly) {
            assert (this.propertyNames[index] == null);
            this.propertyNames[index] = name;
            this.propertyReadOnly[index] = readOnly;
        }

        protected final void registerFunction(String name, int index) {
            assert (this.functions[index] == null);
            this.functions[index] = name;
        }

        public Proto createProto(Object obj, BrwsrCtx context) {
            return new Proto(obj, this, context);
        }

        protected abstract void setValue(Model var1, int var2, Object var3);

        protected abstract Object getValue(Model var1, int var2);

        protected abstract void call(Model var1, int var2, Object var3, Object var4);

        protected abstract Model cloneTo(Model var1, BrwsrCtx var2);

        protected abstract Model read(BrwsrCtx var1, Object var2);

        protected abstract void onChange(Model var1, int var2);

        protected abstract Proto protoFor(Object var1);

        protected abstract void onMessage(Model var1, int var2, int var3, Object var4);

        public <T> void copyJSON(BrwsrCtx context, Object[] src, Class<T> destType, T[] dest) {
            for (int i = 0; i < src.length && i < dest.length; ++i) {
                dest[i] = JSON.read(context, destType, src[i]);
            }
        }

        public final boolean isSame(int a, int b) {
            return a == b;
        }

        public final boolean isSame(double a, double b) {
            return a == b;
        }

        public final boolean isSame(Object a, Object b) {
            if (a == b) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            return a.equals(b);
        }

        public final int hashPlus(Object o, int h) {
            return o == null ? h : h ^ o.hashCode();
        }

        public final String toJSON(Object obj) {
            return JSON.toJSON(obj);
        }

        public final String stringValue(Object val) {
            return JSON.stringValue(val);
        }

        public final Number numberValue(Object val) {
            return JSON.numberValue(val);
        }

        public final Character charValue(Object val) {
            return JSON.charValue(val);
        }

        public final Boolean boolValue(Object val) {
            return JSON.boolValue(val);
        }

        public final <T> T extractValue(Class<T> type, Object val) {
            if (Number.class.isAssignableFrom(type)) {
                val = this.numberValue(val);
            }
            if (Boolean.class == type) {
                val = this.boolValue(val);
            }
            if (String.class == type) {
                val = this.stringValue(val);
            }
            if (Character.class == type) {
                val = this.charValue(val);
            }
            if (Integer.class == type) {
                val = val instanceof Number ? ((Number)val).intValue() : 0;
            }
            if (Long.class == type) {
                val = val instanceof Number ? ((Number)val).longValue() : 0L;
            }
            if (Short.class == type) {
                val = val instanceof Number ? ((Number)val).shortValue() : (short)0;
            }
            if (Byte.class == type) {
                val = val instanceof Number ? ((Number)val).byteValue() : (byte)0;
            }
            if (Double.class == type) {
                val = val instanceof Number ? ((Number)val).doubleValue() : Double.NaN;
            }
            if (Float.class == type) {
                val = Float.valueOf(val instanceof Number ? ((Number)val).floatValue() : Float.NaN);
            }
            return type.cast(val);
        }
    }
}

