/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.html.json.spi;

import net.java.html.BrwsrCtx;
import org.apidesign.html.json.spi.JSONCall;
import org.apidesign.html.json.spi.Proto;
import org.netbeans.html.json.impl.Bindings;
import org.netbeans.html.json.impl.JSON;
import org.netbeans.html.json.impl.PropertyBindingAccessor;
import org.netbeans.html.json.impl.RcvrJSON;

public abstract class PropertyBinding {
    PropertyBinding() {
    }

    public abstract String getPropertyName();

    public abstract void setValue(Object var1);

    public abstract Object getValue();

    public abstract boolean isReadOnly();

    static {
        new PropertyBindingAccessor(){

            @Override
            protected JSONCall newCall(BrwsrCtx ctx, RcvrJSON callback, String urlBefore, String urlAfter, String method, Object data) {
                return new JSONCall(ctx, callback, urlBefore, urlAfter, method, data);
            }

            @Override
            protected Bindings bindings(Proto proto, boolean initialize) {
                return initialize ? proto.initBindings() : proto.getBindings();
            }

            @Override
            protected void notifyChange(Proto proto, int propIndex) {
                proto.onChange(propIndex);
            }

            @Override
            protected Proto findProto(Proto.Type<?> type, Object object) {
                return type.protoFor(object);
            }

            @Override
            protected <Model> Model cloneTo(Proto.Type<Model> type, Model model, BrwsrCtx c) {
                return type.cloneTo(model, c);
            }

            @Override
            protected Object read(Proto.Type<?> from, BrwsrCtx c, Object data) {
                return from.read(c, data);
            }

            @Override
            protected <M> PropertyBinding newBinding(Proto.Type<M> access, Bindings<?> bindings, String name, int index, M model, boolean readOnly) {
                return new Impl<M>(bindings, name, index, model, access, readOnly);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Impl<M>
    extends PropertyBinding {
        public final String name;
        public final boolean readOnly;
        private final M model;
        private final Proto.Type<M> access;
        private final Bindings<?> bindings;
        private final int index;

        public Impl(Bindings<?> bindings, String name, int index, M model, Proto.Type<M> access, boolean readOnly) {
            this.bindings = bindings;
            this.name = name;
            this.index = index;
            this.model = model;
            this.access = access;
            this.readOnly = readOnly;
        }

        @Override
        public void setValue(Object v) {
            this.access.setValue(this.model, this.index, v);
        }

        @Override
        public Object getValue() {
            Object v = this.access.getValue(this.model, this.index);
            Object r = JSON.find(v, this.bindings);
            return r == null ? v : r;
        }

        @Override
        public boolean isReadOnly() {
            return this.readOnly;
        }

        @Override
        public String getPropertyName() {
            return this.name;
        }
    }
}

