/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.wstyrus;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Logger;
import net.java.html.js.JavaScriptBody;
import org.apidesign.html.boot.spi.Fn;
import org.apidesign.html.json.spi.JSONCall;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

final class LoadJSON
implements Runnable {
    private static final Logger LOG = Logger.getLogger(LoadJSON.class.getName());
    private static final Executor REQ = Executors.newCachedThreadPool(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = Executors.defaultThreadFactory().newThread(runnable);
            thread.setDaemon(true);
            return thread;
        }
    });
    private final JSONCall call;
    private final URL base;
    private static Fn $$fn$$getProperty_1;

    private LoadJSON(JSONCall call) {
        this.call = call;
        this.base = null;
    }

    public static void loadJSON(JSONCall call) {
        assert (!"WebSocket".equals(call.getMethod()));
        REQ.execute(new LoadJSON(call));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block15: {
            Object json;
            block14: {
                IOException error = null;
                json = null;
                String url = this.call.isJSONP() ? this.call.composeURL("dummy") : this.call.composeURL(null);
                try {
                    URL u = new URL(this.base, url.replace(" ", "%20"));
                    URLConnection conn = u.openConnection();
                    if (this.call.isDoOutput()) {
                        conn.setDoOutput(true);
                    }
                    if (this.call.getMethod() != null && conn instanceof HttpURLConnection) {
                        ((HttpURLConnection)conn).setRequestMethod(this.call.getMethod());
                    }
                    if (this.call.isDoOutput()) {
                        OutputStream os = conn.getOutputStream();
                        this.call.writeData(os);
                        os.flush();
                    }
                    PushbackInputStream is = new PushbackInputStream(conn.getInputStream(), 1);
                    boolean[] arrayOrString = new boolean[]{false, false};
                    LoadJSON.detectJSONType(this.call.isJSONP(), is, arrayOrString);
                    try {
                        if (arrayOrString[1]) {
                            throw new JSONException("");
                        }
                        JSONTokener tok = LoadJSON.createTokener(is);
                        JSONArray obj = arrayOrString[0] ? new JSONArray(tok) : new JSONObject(tok);
                        json = LoadJSON.convertToArray(obj);
                    }
                    catch (JSONException ex) {
                        int ch;
                        InputStreamReader r = new InputStreamReader((InputStream)is, "UTF-8");
                        StringBuilder sb = new StringBuilder();
                        while ((ch = ((Reader)r).read()) != -1) {
                            sb.append((char)ch);
                        }
                        json = sb.toString();
                    }
                    if (error == null) break block14;
                }
                catch (IOException ex) {
                    error = ex;
                    break block15;
                }
                finally {
                    if (error != null) {
                        this.call.notifyError((Throwable)error);
                    } else {
                        this.call.notifySuccess(json);
                    }
                }
                this.call.notifyError((Throwable)error);
                break block15;
            }
            this.call.notifySuccess(json);
        }
    }

    private static void detectJSONType(boolean skipAnything, PushbackInputStream is, boolean[] arrayOrString) throws IOException {
        block4: {
            int ch;
            while (true) {
                if ((ch = is.read()) == -1) {
                    arrayOrString[1] = true;
                    break block4;
                }
                if (Character.isWhitespace(ch)) continue;
                if (ch == 91) {
                    is.unread(ch);
                    arrayOrString[0] = true;
                    break block4;
                }
                if (ch == 123) {
                    is.unread(ch);
                    break block4;
                }
                if (!skipAnything) break;
            }
            is.unread(ch);
            arrayOrString[1] = true;
        }
    }

    private static JSONTokener createTokener(InputStream is) throws IOException {
        InputStreamReader r = new InputStreamReader(is, "UTF-8");
        try {
            return new JSONTokener((Reader)r);
        }
        catch (LinkageError ex) {
            int ch;
            StringBuilder sb = new StringBuilder();
            while ((ch = ((Reader)r).read()) != -1) {
                sb.append((char)ch);
            }
            return new JSONTokener(sb.toString());
        }
    }

    static Object convertToArray(Object o) throws JSONException {
        if (o instanceof JSONArray) {
            JSONArray ja = (JSONArray)o;
            Object[] arr = new Object[ja.length()];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = LoadJSON.convertToArray(ja.get(i));
            }
            return arr;
        }
        if (o instanceof JSONObject) {
            JSONObject obj = (JSONObject)o;
            Iterator it = obj.keys();
            ArrayList<Object> collect = new ArrayList<Object>();
            while (it.hasNext()) {
                Object newVal;
                String key = (String)it.next();
                Object val = obj.get(key);
                if (val == (newVal = LoadJSON.convertToArray(val))) continue;
                collect.add(key);
                collect.add(newVal);
            }
            int size = collect.size();
            for (int i = 0; i < size; i += 2) {
                obj.put((String)collect.get(i), collect.get(i + 1));
            }
            return obj;
        }
        if (o == JSONObject.NULL) {
            return null;
        }
        return o;
    }

    public static void extractJSON(Object jsonObject, String[] props, Object[] values) {
        if (jsonObject instanceof JSONObject) {
            JSONObject obj = (JSONObject)jsonObject;
            for (int i = 0; i < props.length; ++i) {
                Object val = obj.opt(props[i]);
                if (val == JSONObject.NULL) {
                    val = null;
                }
                values[i] = val;
            }
            return;
        }
        for (int i = 0; i < props.length; ++i) {
            values[i] = LoadJSON.getProperty(jsonObject, props[i]);
        }
    }

    @JavaScriptBody(args={"object", "property"}, javacall=false, body="if (property === null) return object;\nif (object === null) return null;\nvar p = object[property]; return p ? p : null;")
    private static Object getProperty(Object object, String string) {
        block3: {
            Fn fn;
            block2: {
                fn = $$fn$$getProperty_1;
                if (Fn.isValid((Fn)fn)) break block2;
                Fn fn2 = Fn.define(LoadJSON.class, (String)"if (property === null) return object;\nif (object === null) return null;\nvar p = object[property]; return p ? p : null;", (String[])new String[]{"object", "property"});
                if (fn2 == null) break block3;
                fn = $$fn$$getProperty_1 = fn2;
            }
            return fn.invoke(null, new Object[]{object, string});
        }
        return null;
    }

    public static Object parse(InputStream is) throws IOException {
        try {
            PushbackInputStream push = new PushbackInputStream(is, 1);
            boolean[] arrayOrString = new boolean[]{false, false};
            LoadJSON.detectJSONType(false, push, arrayOrString);
            JSONTokener t = LoadJSON.createTokener(push);
            JSONArray obj = arrayOrString[0] ? new JSONArray(t) : new JSONObject(t);
            return LoadJSON.convertToArray(obj);
        }
        catch (JSONException ex) {
            throw new IOException(ex);
        }
    }
}

