/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.wstyrus;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import javax.websocket.ClientEndpoint;
import javax.websocket.ContainerProvider;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.apidesign.html.context.spi.Contexts;
import org.apidesign.html.json.spi.JSONCall;
import org.apidesign.html.json.spi.Transfer;
import org.apidesign.html.json.spi.WSTransfer;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.netbeans.html.wstyrus.LoadJSON;

public final class TyrusContext
implements Contexts.Provider,
WSTransfer<Comm>,
Transfer {
    public void fillContext(Contexts.Builder context, Class<?> requestor) {
        context.register(WSTransfer.class, (Object)this, 1000);
        context.register(Transfer.class, (Object)this, 1000);
    }

    public Comm open(String url, JSONCall callback) {
        try {
            return new Comm(new URI(url), callback);
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void send(Comm socket, JSONCall data) {
        socket.session.getAsyncRemote().sendText(data.getMessage());
    }

    public void close(Comm socket) {
        try {
            Session s = socket.session;
            if (s != null) {
                s.close();
            }
        }
        catch (IOException ex) {
            socket.callback.notifyError((Throwable)ex);
        }
    }

    public void extract(Object obj, String[] props, Object[] values) {
        LoadJSON.extractJSON(obj, props, values);
    }

    public Object toJSON(InputStream is) throws IOException {
        return LoadJSON.parse(is);
    }

    public void loadJSON(JSONCall call) {
        LoadJSON.loadJSON(call);
    }

    @ClientEndpoint
    public static final class Comm {
        private final JSONCall callback;
        private Session session;

        Comm(URI url, JSONCall callback) {
            this.callback = callback;
            try {
                WebSocketContainer c = ContainerProvider.getWebSocketContainer();
                c.connectToServer((Object)this, url);
            }
            catch (Exception ex) {
                this.wasAnError(ex);
            }
        }

        @OnOpen
        public synchronized void open(Session s) {
            this.session = s;
            this.callback.notifySuccess(null);
        }

        @OnClose
        public void close() {
            this.session = null;
            this.callback.notifyError(null);
        }

        @OnMessage
        public void message(String orig, Session s) {
            Object json;
            String data = orig.trim();
            try {
                JSONTokener tok = new JSONTokener(data);
                JSONArray obj = data.startsWith("[") ? new JSONArray(tok) : new JSONObject(tok);
                json = Comm.convertToArray(obj);
            }
            catch (JSONException ex) {
                json = data;
            }
            this.callback.notifySuccess(json);
        }

        @OnError
        public void wasAnError(Throwable t) {
            this.callback.notifyError(t);
        }

        static Object convertToArray(Object o) throws JSONException {
            if (o instanceof JSONArray) {
                JSONArray ja = (JSONArray)o;
                Object[] arr = new Object[ja.length()];
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = Comm.convertToArray(ja.get(i));
                }
                return arr;
            }
            if (o instanceof JSONObject) {
                JSONObject obj = (JSONObject)o;
                Iterator it = obj.keys();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    obj.put(key, Comm.convertToArray(obj.get(key)));
                }
                return obj;
            }
            return o;
        }
    }
}

