/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.servlet;

import io.mola.galimatias.GalimatiasParseException;
import io.mola.galimatias.URL;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nu.validator.gnu.xml.aelfred2.SAXDriver;
import nu.validator.htmlparser.common.Heuristics;
import nu.validator.htmlparser.common.XmlViolationPolicy;
import nu.validator.htmlparser.sax.HtmlParser;
import nu.validator.io.BoundedInputStream;
import nu.validator.io.StreamBoundException;
import nu.validator.servlet.ListErrorHandler;
import nu.validator.servlet.TreeDumpContentHandler;
import nu.validator.xml.ContentTypeParser;
import nu.validator.xml.NullEntityResolver;
import nu.validator.xml.PrudentHttpEntityResolver;
import nu.validator.xml.TypedInputSource;
import org.xml.sax.SAXException;

public class ParseTreePrinter {
    private static final String FORM_HTML = "<!DOCTYPE html><title>Parse Tree Dump</title><form><p><input type='url' name='doc' id='doc' pattern='(?:https?://.+)?'> <input name='submit' value='Print Tree' type='submit' id='submit'></form><hr><form><p><select id=parser name=parser><option value=xml>XML; don\u2019t load external entities</option><option value=html5 selected>HTML5</option></select><p><textarea name=content rows=20 cols=72></textarea> <input name='submit' value='Print Tree' type='submit' id='submit'></form>";
    private static final long SIZE_LIMIT = Integer.parseInt(System.getProperty("nu.validator.servlet.max-file-size", "2097152"));
    private final HttpServletRequest request;
    private final HttpServletResponse response;

    public ParseTreePrinter(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    private String scrubUrl(String urlStr) {
        if (urlStr == null) {
            return null;
        }
        try {
            return URL.parse((String)urlStr).toString();
        }
        catch (GalimatiasParseException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void service() throws IOException {
        this.request.setCharacterEncoding("utf-8");
        String content = null;
        String document = this.scrubUrl(this.request.getParameter("doc"));
        document = "".equals(document) ? null : document;
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)this.response.getOutputStream(), "UTF-8");){
            if (document == null && this.methodIsGet() && (content = this.request.getParameter("content")) == null) {
                this.response.setContentType("text/html; charset=utf-8");
                writer.write(FORM_HTML);
                ((Writer)writer).flush();
                return;
            }
            this.response.setContentType("text/plain; charset=utf-8");
            try {
                Object parser;
                TypedInputSource documentInput;
                block46: {
                    block47: {
                        PrudentHttpEntityResolver entityResolver = new PrudentHttpEntityResolver(0x200000L, false, null);
                        entityResolver.setAllowGenericXml(false);
                        entityResolver.setAcceptAllKnownXmlTypes(false);
                        entityResolver.setAllowHtml(true);
                        entityResolver.setAllowXhtml(true);
                        if (!this.methodIsGet()) break block47;
                        if (content == null) {
                            documentInput = (TypedInputSource)entityResolver.resolveEntity(null, document);
                            break block46;
                        } else {
                            documentInput = new TypedInputSource(new StringReader(content));
                            if ("xml".equals(this.request.getParameter("parser"))) {
                                documentInput.setType("application/xhtml+xml");
                                break block46;
                            } else {
                                documentInput.setType("text/html");
                            }
                        }
                        break block46;
                    }
                    String postContentType = this.request.getContentType();
                    if (postContentType == null) {
                        this.response.sendError(400, "Content-Type missing");
                        return;
                    }
                    if (postContentType.trim().toLowerCase().startsWith("application/x-www-form-urlencoded")) {
                        this.response.sendError(415, "application/x-www-form-urlencoded not supported. Please use multipart/form-data.");
                        return;
                    }
                    long len = this.request.getContentLength();
                    if (len > SIZE_LIMIT) {
                        throw new StreamBoundException("Resource size exceeds limit.");
                    }
                    ContentTypeParser contentTypeParser = new ContentTypeParser(null, false);
                    contentTypeParser.setAllowGenericXml(false);
                    contentTypeParser.setAcceptAllKnownXmlTypes(false);
                    contentTypeParser.setAllowHtml(true);
                    contentTypeParser.setAllowXhtml(true);
                    documentInput = contentTypeParser.buildTypedInputSource(document, null, postContentType);
                    documentInput.setByteStream(len < 0L ? new BoundedInputStream((InputStream)this.request.getInputStream(), SIZE_LIMIT, document) : this.request.getInputStream());
                    documentInput.setSystemId(this.request.getHeader("Content-Location"));
                }
                String type = documentInput.getType();
                if ("text/html".equals(type) || "text/html-sandboxed".equals(type)) {
                    writer.write("HTML parser\n\n#document\n");
                    parser = new HtmlParser();
                    parser.setProperty("http://validator.nu/properties/heuristics", Heuristics.ALL);
                    parser.setProperty("http://validator.nu/properties/xml-policy", XmlViolationPolicy.ALLOW);
                } else {
                    if (!"application/xhtml+xml".equals(type)) {
                        writer.write("Unsupported content type.\n");
                        ((Writer)writer).flush();
                        return;
                    }
                    writer.write("XML parser\n\n#document\n");
                    parser = new SAXDriver();
                    parser.setFeature("http://xml.org/sax/features/external-general-entities", false);
                    parser.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                    parser.setEntityResolver(new NullEntityResolver());
                }
                TreeDumpContentHandler treeDumpContentHandler = new TreeDumpContentHandler(writer, false);
                ListErrorHandler listErrorHandler = new ListErrorHandler();
                parser.setContentHandler(treeDumpContentHandler);
                parser.setProperty("http://xml.org/sax/properties/lexical-handler", treeDumpContentHandler);
                parser.setErrorHandler(listErrorHandler);
                parser.parse(documentInput);
                writer.write("#errors\n");
                Iterator iterator = listErrorHandler.getErrors().iterator();
                while (iterator.hasNext()) {
                    String err = (String)iterator.next();
                    writer.write(err);
                    ((Writer)writer).write(10);
                }
                return;
            }
            catch (SAXException e) {
                writer.write("SAXException:\n");
                writer.write(e.getMessage());
                writer.write("\n");
                return;
            }
            catch (IOException e) {
                writer.write("IOException:\n");
                writer.write(e.getMessage());
                writer.write("\n");
                return;
            }
            finally {
                ((Writer)writer).flush();
            }
        }
    }

    private boolean methodIsGet() {
        return "GET".equals(this.request.getMethod()) || "HEAD".equals(this.request.getMethod());
    }
}

