/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.messages;

import nu.validator.messages.MessageEmitter;
import nu.validator.messages.MessageTextHandler;
import nu.validator.messages.XhtmlMessageTextHandler;
import nu.validator.messages.XmlExtractHandler;
import nu.validator.messages.XmlSaxEmitter;
import nu.validator.messages.XmlSourceHandler;
import nu.validator.messages.types.MessageType;
import nu.validator.source.SourceHandler;
import nu.validator.xml.AttributesImpl;
import nu.validator.xml.CharacterUtil;
import nu.validator.xml.XhtmlSaxEmitter;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class XmlMessageEmitter
extends MessageEmitter {
    private final AttributesImpl attrs = new AttributesImpl();
    private final ContentHandler contentHandler;
    private final XmlSaxEmitter emitter;
    private final XhtmlMessageTextHandler messageTextHandler;
    private final XmlExtractHandler extractHandler;
    private String openMessage;
    private static final String SERVICE_ORIGIN = System.getProperty("nu.validator.servlet.origin", "https://validator.nu/");
    private static final char[] DEPRECATED_INTERFACE = "This interface to HTML5 document checking is deprecated.".toCharArray();
    private static final char[] USE_THE_NU_CHECKER = "Use the Nu Html Checker at ".toCharArray();
    private static final char[] DIRECTLY_INSTEAD = " directly instead.".toCharArray();

    public XmlMessageEmitter(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
        this.emitter = new XmlSaxEmitter(contentHandler);
        this.messageTextHandler = new XhtmlMessageTextHandler(new XhtmlSaxEmitter(contentHandler));
        this.extractHandler = new XmlExtractHandler(this.emitter);
    }

    @Override
    public void endMessage() throws SAXException {
        assert (this.openMessage != null);
        this.emitter.endElement(this.openMessage);
        this.openMessage = null;
    }

    @Override
    public void startMessage(MessageType type, String systemId, int oneBasedFirstLine, int oneBasedFirstColumn, int oneBasedLastLine, int oneBasedLastColumn, boolean exact) throws SAXException {
        String subType;
        assert (this.openMessage == null);
        this.openMessage = type.getSuperType();
        this.attrs.clear();
        if (systemId != null) {
            this.attrs.addAttribute("url", CharacterUtil.prudentlyScrubCharacterData(systemId));
        }
        if (oneBasedLastLine != -1) {
            this.attrs.addAttribute("last-line", Integer.toString(oneBasedLastLine));
            if (oneBasedFirstLine != oneBasedLastLine) {
                this.attrs.addAttribute("first-line", Integer.toString(oneBasedFirstLine));
            }
            if (oneBasedLastColumn != -1) {
                this.attrs.addAttribute("last-column", Integer.toString(oneBasedLastColumn));
                if (oneBasedFirstColumn != oneBasedLastColumn) {
                    this.attrs.addAttribute("first-column", Integer.toString(oneBasedFirstColumn));
                }
            }
        }
        if ((subType = type.getSubType()) != null) {
            this.attrs.addAttribute("type", subType);
        }
        this.emitter.startElement(this.openMessage, this.attrs);
    }

    @Override
    public void endFullSource() throws SAXException {
    }

    @Override
    public void endMessages() throws SAXException {
        this.emitter.endElement("messages");
        this.emitter.characters("\n");
        this.contentHandler.endPrefixMapping("");
        this.contentHandler.endPrefixMapping("h");
        this.contentHandler.endDocument();
    }

    @Override
    public void endSource() throws SAXException {
        this.emitter.endElement("extract");
    }

    @Override
    public void endText() throws SAXException {
        this.emitter.endElement("message");
    }

    @Override
    public SourceHandler startFullSource(int lineOffset) throws SAXException {
        return new XmlSourceHandler(this.emitter);
    }

    @Override
    public void startMessages(String documentUri, boolean willShowSource) throws SAXException {
        this.contentHandler.startDocument();
        this.attrs.clear();
        if (documentUri != null) {
            this.attrs.addAttribute("url", CharacterUtil.prudentlyScrubCharacterData(documentUri));
        }
        this.emitter.startElement("messages", this.attrs);
        this.maybeEmitDeprecationWarning();
        this.openMessage = null;
    }

    private void maybeEmitDeprecationWarning() throws SAXException {
        if (!"true".equals(System.getProperty("nu.validator.servlet.request.legacy"))) {
            return;
        }
        this.startMessage(MessageType.WARNING, null, -1, -1, -1, -1, false);
        this.startText();
        this.emitter.characters(DEPRECATED_INTERFACE);
        this.endText();
        this.startElaboration();
        this.attrs.clear();
        this.attrs.addAttribute("style", "padding-top: 1em");
        this.emitter.startElement("http://www.w3.org/1999/xhtml", "h2", this.attrs);
        this.emitter.characters(USE_THE_NU_CHECKER);
        this.messageTextHandler.startLink(SERVICE_ORIGIN, "");
        this.emitter.characters(SERVICE_ORIGIN.toCharArray());
        this.messageTextHandler.endLink();
        this.emitter.characters(DIRECTLY_INSTEAD);
        this.emitter.endElement("http://www.w3.org/1999/xhtml", "h2");
        this.endElaboration();
        this.endMessage();
    }

    @Override
    public SourceHandler startSource() throws SAXException {
        this.emitter.startElement("extract");
        return this.extractHandler;
    }

    @Override
    public MessageTextHandler startText() throws SAXException {
        this.emitter.startElement("message");
        return this.messageTextHandler;
    }

    @Override
    public void endElaboration() throws SAXException {
        this.emitter.endElement("elaboration");
    }

    @Override
    public ContentHandler startElaboration() throws SAXException {
        this.emitter.startElement("elaboration");
        return this.contentHandler;
    }
}

