/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.javahl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.subversion.javahl.ClientException;
import org.apache.subversion.javahl.SVNClient;
import org.apache.subversion.javahl.SVNRepos;
import org.apache.subversion.javahl.callback.ClientNotifyCallback;
import org.apache.subversion.javahl.callback.ProgressCallback;
import org.apache.subversion.javahl.callback.UserPasswordCallback;
import org.apache.subversion.javahl.types.CopySource;
import org.apache.subversion.javahl.types.Revision;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.SVNBaseDir;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.javahl.AbstractJhlClientAdapter;
import org.tigris.subversion.svnclientadapter.javahl.JhlClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.javahl.JhlNotificationHandler;
import org.tigris.subversion.svnclientadapter.javahl.JhlProgressListener;

public class JhlClientAdapter
extends AbstractJhlClientAdapter {
    private SVNRepos svnAdmin;

    public JhlClientAdapter() {
        this.svnClient = new SVNClient();
        this.svnAdmin = new SVNRepos();
        this.notificationHandler = new JhlNotificationHandler();
        this.progressListener = new JhlProgressListener();
        this.svnClient.notification2((ClientNotifyCallback)this.notificationHandler);
        this.svnClient.setPrompt((UserPasswordCallback)new AbstractJhlClientAdapter.DefaultPromptUserPassword());
        this.svnClient.setProgressCallback((ProgressCallback)this.progressListener);
    }

    public boolean isThreadsafe() {
        return false;
    }

    public static boolean isAvailable() {
        return JhlClientAdapterFactory.isAvailable();
    }

    public static String getLibraryLoadErrors() {
        return JhlClientAdapterFactory.getLibraryLoadErrors();
    }

    public void createRepository(File path, String repositoryType) throws SVNClientException {
        try {
            String fsType = repositoryType == null ? "fsfs" : repositoryType;
            this.notificationHandler.setCommand(23);
            this.notificationHandler.logCommandLine(MessageFormat.format("create --fstype {0} {1}", fsType, JhlClientAdapter.fileToSVNPath(path, false)));
            this.svnAdmin.create(path, false, false, null, fsType);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException((Throwable)e);
        }
    }

    public boolean statusReturnsRemoteInfo() {
        return true;
    }

    public void move(File srcPath, File destPath, boolean force) throws SVNClientException {
        ISVNProperty prop;
        if (srcPath.isFile() && (prop = this.propertyGet(srcPath, "svn:keywords")) != null) {
            try {
                this.notificationHandler.setCommand(5);
                String src = JhlClientAdapter.fileToSVNPath(srcPath, false);
                String dest = JhlClientAdapter.fileToSVNPath(destPath, false);
                this.notificationHandler.logCommandLine("move " + src + ' ' + dest);
                this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir((File[])new File[]{srcPath, destPath}));
                ArrayList<CopySource> copySources = new ArrayList<CopySource>();
                copySources.add(new CopySource(src, Revision.WORKING, Revision.WORKING));
                this.svnClient.copy(copySources, dest, true, true, true, null, null, null);
                try {
                    this.overwriteFile(srcPath, destPath);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                HashSet<String> paths = new HashSet<String>();
                paths.add(src);
                this.svnClient.remove(paths, true, false, null, null, null);
            }
            catch (ClientException e) {
                this.notificationHandler.logException((Exception)((Object)e));
                throw new SVNClientException((Throwable)e);
            }
            return;
        }
        super.move(srcPath, destPath, force);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void overwriteFile(File srcFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(srcFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    public String getNativeLibraryVersionString() {
        return this.svnClient.getVersion().toString();
    }
}

