/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.tooling;

import java.util.Arrays;
import java.util.Set;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.JavaExec;
import org.gradle.process.CommandLineArgumentProvider;
import org.gradle.tooling.BuildException;
import org.gradle.util.GradleVersion;

class NetBeansRunSinglePlugin
implements Plugin<Project> {
    private static final GradleVersion GRADLE_VERSION = GradleVersion.current().getBaseVersion();
    private static final Logger LOG = Logging.getLogger(NetBeansRunSinglePlugin.class);
    private static final String RUN_SINGLE_TASK = "runSingle";
    private static final String RUN_SINGLE_MAIN = "runClassName";
    private static final String RUN_SINGLE_ARGS = "runArgs";
    private static final String RUN_SINGLE_JVM_ARGS = "runJvmArgs";
    private static final String RUN_SINGLE_CWD = "runWorkingDir";

    NetBeansRunSinglePlugin() {
    }

    public void apply(Project project) {
        project.afterEvaluate(p -> {
            if (project.getPlugins().hasPlugin("java") && project.getTasks().findByPath(RUN_SINGLE_TASK) == null && project.hasProperty(RUN_SINGLE_MAIN)) {
                Set runTasks = p.getTasksByName("run", false);
                Task r = runTasks.isEmpty() ? null : (Task)runTasks.iterator().next();
                String mainClass = project.property(RUN_SINGLE_MAIN).toString();
                p.getTasks().withType(JavaExec.class).configureEach(je -> {
                    if (GRADLE_VERSION.compareTo(GradleVersion.version((String)"6.4")) < 0) {
                        je.setMain(mainClass);
                    } else {
                        je.getMainClass().set((Object)mainClass);
                    }
                    if (project.hasProperty(RUN_SINGLE_ARGS)) {
                        je.setArgs(Arrays.asList(project.property(RUN_SINGLE_ARGS).toString().split(" ")));
                    }
                    if (p.hasProperty(RUN_SINGLE_JVM_ARGS)) {
                        je.getJvmArgumentProviders().add(new CommandLineArgumentProvider((Project)p){
                            final /* synthetic */ Project val$p;
                            {
                                this.val$p = project;
                            }

                            public Iterable<String> asArguments() {
                                return Arrays.asList(this.val$p.property(NetBeansRunSinglePlugin.RUN_SINGLE_JVM_ARGS).toString().split(" "));
                            }
                        });
                    }
                    try {
                        je.setStandardInput(System.in);
                    }
                    catch (RuntimeException ex) {
                        if (LOG.isEnabled(LogLevel.DEBUG)) {
                            LOG.debug("Failed to set STDIN for Plugin: " + je.toString(), (Throwable)ex);
                        }
                        LOG.info("Failed to set STDIN for Plugin: " + je.toString());
                    }
                    if (project.hasProperty(RUN_SINGLE_CWD)) {
                        je.setWorkingDir((Object)project.property(RUN_SINGLE_CWD).toString());
                    }
                });
                this.addTask(project, r);
            }
        });
    }

    private void addTask(Project project, Task runTask) {
        project.getTasks().register(RUN_SINGLE_TASK, JE.class, je -> {
            if (runTask == null) {
                throw new BuildException("Could not find \"run\" task to execute. Please upgrade your configuration to use standard run-style tasks instead of deprecated runSingle", null);
            }
            LOG.warn("runSingle task is deprecated. Inspect your configuration and use just 'run' task instead of 'runSingle'");
            je.finalizedBy(new Object[]{runTask});
        });
    }

    public static class JE
    extends JavaExec {
        public void exec() {
        }
    }
}

