/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

public final class Symbol
implements Comparable<Symbol> {
    public static final int IS_GLOBAL = 1;
    public static final int IS_VAR = 2;
    public static final int IS_PARAM = 3;
    public static final int KINDMASK = 3;
    public static final int IS_SCOPE = 4;
    public static final int IS_THIS = 8;
    public static final int IS_LET = 16;
    public static final int IS_CONST = 32;
    public static final int IS_INTERNAL = 64;
    public static final int IS_FUNCTION_SELF = 128;
    public static final int IS_FUNCTION_DECLARATION = 256;
    public static final int IS_PROGRAM_LEVEL = 512;
    public static final int HAS_BEEN_DECLARED = 1024;
    public static final int IS_VAR_DECLARED_HERE = 2048;
    public static final int IS_VAR_REDECLARED_HERE = 4096;
    public static final int IS_DECLARED_IN_SWITCH_BLOCK = 8192;
    private final String name;
    private int flags;
    private int useCount;

    public Symbol(String string, int n) {
        this.name = string;
        this.flags = n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.name);
        if (this.isScope()) {
            if (this.isGlobal()) {
                stringBuilder.append(" G");
            } else {
                stringBuilder.append(" S");
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public int compareTo(Symbol symbol) {
        return this.name.compareTo(symbol.name);
    }

    public boolean isScope() {
        assert ((this.flags & 3) != 1 || (this.flags & 4) == 4) : "global without scope flag";
        return (this.flags & 4) != 0;
    }

    public boolean isFunctionDeclaration() {
        return (this.flags & 0x100) != 0;
    }

    public boolean isVar() {
        return (this.flags & 3) == 2;
    }

    public boolean isGlobal() {
        return (this.flags & 3) == 1;
    }

    public boolean isParam() {
        return (this.flags & 3) == 3;
    }

    public boolean isProgramLevel() {
        return (this.flags & 0x200) != 0;
    }

    public boolean isConst() {
        return (this.flags & 0x20) != 0;
    }

    public boolean isInternal() {
        return (this.flags & 0x40) != 0;
    }

    public boolean isThis() {
        return (this.flags & 8) != 0;
    }

    public boolean isLet() {
        return (this.flags & 0x10) != 0;
    }

    public boolean isFunctionSelf() {
        return (this.flags & 0x80) != 0;
    }

    public boolean isBlockScoped() {
        return this.isLet() || this.isConst();
    }

    public boolean hasBeenDeclared() {
        return (this.flags & 0x400) != 0;
    }

    public void setHasBeenDeclared() {
        if (!this.hasBeenDeclared()) {
            this.flags |= 0x400;
        }
    }

    public boolean isVarDeclaredHere() {
        return (this.flags & 0x800) != 0;
    }

    public boolean isVarRedeclaredHere() {
        return (this.flags & 0x1000) != 0;
    }

    public int getFlags() {
        return this.flags;
    }

    public String getName() {
        return this.name;
    }

    public void increaseUseCount() {
        if (this.isScope()) {
            ++this.useCount;
        }
    }

    public int getUseCount() {
        return this.useCount;
    }

    public Symbol setIsScope() {
        if (!this.isScope()) {
            this.flags |= 4;
        }
        return this;
    }

    public void setIsFunctionDeclaration() {
        if (!this.isFunctionDeclaration()) {
            this.flags |= 0x100;
        }
    }

    public Symbol setFlags(int n) {
        if (this.flags != n) {
            this.flags = n;
        }
        return this;
    }

    public Symbol setFlag(int n) {
        if ((this.flags & n) == 0) {
            this.flags |= n;
        }
        return this;
    }

    public Symbol clearFlag(int n) {
        if ((this.flags & n) != 0) {
            this.flags &= ~n;
        }
        return this;
    }

    public boolean isDeclaredInSwitchBlock() {
        return (this.flags & 0x2000) != 0;
    }

    public void setDeclaredInSwitchBlock() {
        if (!this.isDeclaredInSwitchBlock()) {
            this.flags |= 0x2000;
        }
    }
}

