/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

import com.oracle.js.parser.TokenType;
import com.oracle.js.parser.ir.Expression;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import com.oracle.js.parser.ir.visitor.TranslatorNodeVisitor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class RuntimeNode
extends Expression {
    private final Request request;
    private final List<Expression> args;

    public RuntimeNode(long l, int n, Request request, List<Expression> list) {
        super(l, n);
        this.request = request;
        this.args = list;
    }

    private RuntimeNode(RuntimeNode runtimeNode, Request request, List<Expression> list) {
        super(runtimeNode);
        this.request = request;
        this.args = list;
    }

    public RuntimeNode(long l, int n, Request request, Expression ... expressionArray) {
        this(l, n, request, Arrays.asList(expressionArray));
    }

    public RuntimeNode(Expression expression, Request request, List<Expression> list) {
        super(expression);
        this.request = request;
        this.args = list;
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> nodeVisitor) {
        if (nodeVisitor.enterRuntimeNode(this)) {
            return nodeVisitor.leaveRuntimeNode(this.setArgs(Node.accept(nodeVisitor, this.args)));
        }
        return this;
    }

    @Override
    public <R> R accept(TranslatorNodeVisitor<? extends LexicalContext, R> translatorNodeVisitor) {
        return translatorNodeVisitor.enterRuntimeNode(this);
    }

    @Override
    public void toString(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("Runtime.");
        stringBuilder.append((Object)this.request);
        stringBuilder.append('(');
        boolean bl2 = true;
        for (Node node : this.args) {
            if (!bl2) {
                stringBuilder.append(", ");
            } else {
                bl2 = false;
            }
            node.toString(stringBuilder, bl);
        }
        stringBuilder.append(')');
    }

    public List<Expression> getArgs() {
        return Collections.unmodifiableList(this.args);
    }

    public RuntimeNode setArgs(List<Expression> list) {
        if (this.args == list) {
            return this;
        }
        return new RuntimeNode(this, this.request, list);
    }

    public Request getRequest() {
        return this.request;
    }

    public static enum Request {
        REFERENCE_ERROR,
        TO_STRING(TokenType.VOID, Object.class, 1),
        GET_TEMPLATE_OBJECT(TokenType.TEMPLATE, Object.class, 2);

        private final TokenType tokenType;
        private final Class<?> returnType;
        private final int arity;

        private Request() {
            this(TokenType.VOID, Object.class, 0);
        }

        private Request(TokenType tokenType, Class<?> clazz, int n2) {
            this.tokenType = tokenType;
            this.returnType = clazz;
            this.arity = n2;
        }

        public int getArity() {
            return this.arity;
        }

        public Class<?> getReturnType() {
            return this.returnType;
        }

        public TokenType getTokenType() {
            return this.tokenType;
        }
    }
}

