/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

import com.oracle.js.parser.ir.ExportNode;
import com.oracle.js.parser.ir.ImportNode;
import java.util.List;

public final class Module {
    public static final String DEFAULT_EXPORT_BINDING_NAME = "*default*";
    public static final String DEFAULT_NAME = "default";
    public static final String STAR_NAME = "*";
    private final List<String> requestedModules;
    private final List<ImportEntry> importEntries;
    private final List<ExportEntry> localExportEntries;
    private final List<ExportEntry> indirectExportEntries;
    private final List<ExportEntry> starExportEntries;
    private final List<ImportNode> imports;
    private final List<ExportNode> exports;

    public Module(List<String> list, List<ImportEntry> list2, List<ExportEntry> list3, List<ExportEntry> list4, List<ExportEntry> list5, List<ImportNode> list6, List<ExportNode> list7) {
        this.requestedModules = list;
        this.importEntries = list2;
        this.localExportEntries = list3;
        this.indirectExportEntries = list4;
        this.starExportEntries = list5;
        this.imports = list6;
        this.exports = list7;
    }

    public List<String> getRequestedModules() {
        return this.requestedModules;
    }

    public List<ImportEntry> getImportEntries() {
        return this.importEntries;
    }

    public List<ExportEntry> getLocalExportEntries() {
        return this.localExportEntries;
    }

    public List<ExportEntry> getIndirectExportEntries() {
        return this.indirectExportEntries;
    }

    public List<ExportEntry> getStarExportEntries() {
        return this.starExportEntries;
    }

    public List<ImportNode> getImports() {
        return this.imports;
    }

    public List<ExportNode> getExports() {
        return this.exports;
    }

    public String toString() {
        return "Module [requestedModules=" + this.requestedModules + ", importEntries=" + this.importEntries + ", localExportEntries=" + this.localExportEntries + ", indirectExportEntries=" + this.indirectExportEntries + ", starExportEntries=" + this.starExportEntries + ", imports=" + this.imports + ", exports=" + this.exports + "]";
    }

    public static final class ImportEntry {
        private final String moduleRequest;
        private final String importName;
        private final String localName;

        private ImportEntry(String string, String string2, String string3) {
            this.moduleRequest = string;
            this.importName = string2;
            this.localName = string3;
        }

        public static ImportEntry importDefault(String string) {
            return new ImportEntry(null, Module.DEFAULT_NAME, string);
        }

        public static ImportEntry importStarAsNameSpaceFrom(String string) {
            return new ImportEntry(null, Module.STAR_NAME, string);
        }

        public static ImportEntry importSpecifier(String string, String string2) {
            return new ImportEntry(null, string, string2);
        }

        public static ImportEntry importSpecifier(String string) {
            return ImportEntry.importSpecifier(string, string);
        }

        public ImportEntry withFrom(String string) {
            return new ImportEntry(string, this.importName, this.localName);
        }

        public String getModuleRequest() {
            return this.moduleRequest;
        }

        public String getImportName() {
            return this.importName;
        }

        public String getLocalName() {
            return this.localName;
        }

        public String toString() {
            return "ImportEntry [moduleRequest=" + this.moduleRequest + ", importName=" + this.importName + ", localName=" + this.localName + "]";
        }
    }

    public static final class ExportEntry {
        private final String exportName;
        private final String moduleRequest;
        private final String importName;
        private final String localName;

        private ExportEntry(String string, String string2, String string3, String string4) {
            this.exportName = string;
            this.moduleRequest = string2;
            this.importName = string3;
            this.localName = string4;
        }

        public static ExportEntry exportStarFrom(String string) {
            return new ExportEntry(null, string, Module.STAR_NAME, null);
        }

        public static ExportEntry exportDefault() {
            return ExportEntry.exportDefault(Module.DEFAULT_EXPORT_BINDING_NAME);
        }

        public static ExportEntry exportDefault(String string) {
            return new ExportEntry(Module.DEFAULT_NAME, null, null, string);
        }

        public static ExportEntry exportSpecifier(String string, String string2) {
            return new ExportEntry(string, null, null, string2);
        }

        public static ExportEntry exportSpecifier(String string) {
            return ExportEntry.exportSpecifier(string, string);
        }

        public ExportEntry withFrom(String string) {
            return new ExportEntry(this.exportName, string, this.localName, null);
        }

        public String getExportName() {
            return this.exportName;
        }

        public String getModuleRequest() {
            return this.moduleRequest;
        }

        public String getImportName() {
            return this.importName;
        }

        public String getLocalName() {
            return this.localName;
        }

        public String toString() {
            return "ExportEntry [exportName=" + this.exportName + ", moduleRequest=" + this.moduleRequest + ", importName=" + this.importName + ", localName=" + this.localName + "]";
        }
    }
}

