/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

import com.oracle.js.parser.ir.Expression;
import com.oracle.js.parser.ir.Label;
import com.oracle.js.parser.ir.Labels;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.Statement;
import com.oracle.js.parser.ir.Terminal;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import com.oracle.js.parser.ir.visitor.TranslatorNodeVisitor;
import java.util.Collections;
import java.util.List;

public final class CaseNode
extends Node
implements Labels,
Terminal {
    private final Expression test;
    protected final List<Statement> statements;
    private final Label entry;
    private final boolean terminal;

    public CaseNode(long l, int n, Expression expression, List<Statement> list) {
        super(l, n);
        this.test = expression;
        this.statements = list;
        this.entry = new Label("entry");
        this.terminal = CaseNode.isTerminal(list);
    }

    CaseNode(CaseNode caseNode, int n, Expression expression, List<Statement> list) {
        super(caseNode, n);
        this.test = expression;
        this.statements = list;
        this.entry = new Label(caseNode.entry);
        this.terminal = CaseNode.isTerminal(list);
    }

    private static boolean isTerminal(List<Statement> list) {
        return list.isEmpty() ? false : list.get(list.size() - 1).hasTerminalFlags();
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> nodeVisitor) {
        if (nodeVisitor.enterCaseNode(this)) {
            Expression expression = this.test == null ? null : (Expression)this.test.accept(nodeVisitor);
            List<Statement> list = Node.accept(nodeVisitor, this.statements);
            return nodeVisitor.leaveCaseNode(this.setTest(expression).setStatements(list));
        }
        return this;
    }

    @Override
    public <R> R accept(TranslatorNodeVisitor<? extends LexicalContext, R> translatorNodeVisitor) {
        return translatorNodeVisitor.enterCaseNode(this);
    }

    @Override
    public void toString(StringBuilder stringBuilder, boolean bl) {
        if (this.test != null) {
            stringBuilder.append("case ");
            this.test.toString(stringBuilder, bl);
            stringBuilder.append(':');
        } else {
            stringBuilder.append("default:");
        }
    }

    @Override
    public boolean isTerminal() {
        return this.terminal;
    }

    public List<Statement> getStatements() {
        return this.statements;
    }

    public Label getEntry() {
        return this.entry;
    }

    public Expression getTest() {
        return this.test;
    }

    public CaseNode setTest(Expression expression) {
        if (this.test == expression) {
            return this;
        }
        return new CaseNode(this, this.finish, expression, this.statements);
    }

    public CaseNode setStatements(List<Statement> list) {
        if (this.statements == list) {
            return this;
        }
        int n = 0;
        if (!list.isEmpty()) {
            n = list.get(list.size() - 1).getFinish();
        }
        return new CaseNode(this, n, this.test, list);
    }

    @Override
    public List<Label> getLabels() {
        return Collections.unmodifiableList(Collections.singletonList(this.entry));
    }
}

