/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

import com.oracle.js.parser.ir.Expression;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.LexicalContextExpression;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import com.oracle.js.parser.ir.visitor.TranslatorNodeVisitor;
import java.util.Collections;
import java.util.List;

public final class CallNode
extends LexicalContextExpression {
    private final Expression function;
    private final List<Expression> args;
    private static final int IS_NEW = 1;
    private static final int IS_EVAL = 2;
    private final int flags;
    private final int lineNumber;

    public CallNode(int n, long l, int n2, Expression expression, List<Expression> list, boolean bl) {
        super(l, n2);
        this.function = expression;
        this.args = list;
        this.flags = bl ? 1 : 0;
        this.lineNumber = n;
    }

    private CallNode(CallNode callNode, Expression expression, List<Expression> list, int n) {
        super(callNode);
        this.lineNumber = callNode.lineNumber;
        this.function = expression;
        this.args = list;
        this.flags = n;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public Node accept(LexicalContext lexicalContext, NodeVisitor<? extends LexicalContext> nodeVisitor) {
        CallNode callNode;
        if (nodeVisitor.enterCallNode(this) && this != (callNode = (CallNode)nodeVisitor.leaveCallNode(this.setFunction((Expression)this.function.accept(nodeVisitor)).setArgs(Node.accept(nodeVisitor, this.args))))) {
            return Node.replaceInLexicalContext(lexicalContext, this, callNode);
        }
        return this;
    }

    @Override
    public <R> R accept(LexicalContext lexicalContext, TranslatorNodeVisitor<? extends LexicalContext, R> translatorNodeVisitor) {
        return translatorNodeVisitor.enterCallNode(this);
    }

    @Override
    public void toString(StringBuilder stringBuilder, boolean bl) {
        StringBuilder stringBuilder2 = new StringBuilder();
        this.function.toString(stringBuilder2, bl);
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append('(');
        boolean bl2 = true;
        for (Node node : this.args) {
            if (!bl2) {
                stringBuilder.append(", ");
            } else {
                bl2 = false;
            }
            node.toString(stringBuilder, bl);
        }
        stringBuilder.append(')');
    }

    public List<Expression> getArgs() {
        return Collections.unmodifiableList(this.args);
    }

    public CallNode setArgs(List<Expression> list) {
        if (this.args == list) {
            return this;
        }
        return new CallNode(this, this.function, list, this.flags);
    }

    public boolean isEval() {
        return (this.flags & 2) != 0;
    }

    public CallNode setIsEval() {
        return this.setFlags(this.flags | 2);
    }

    public Expression getFunction() {
        return this.function;
    }

    public CallNode setFunction(Expression expression) {
        if (this.function == expression) {
            return this;
        }
        return new CallNode(this, expression, this.args, this.flags);
    }

    public boolean isNew() {
        return (this.flags & 1) != 0;
    }

    private CallNode setFlags(int n) {
        if (this.flags == n) {
            return this;
        }
        return new CallNode(this, this.function, this.args, n);
    }
}

