/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

import com.oracle.js.parser.ir.BaseNode;
import com.oracle.js.parser.ir.Expression;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import com.oracle.js.parser.ir.visitor.TranslatorNodeVisitor;

public final class AccessNode
extends BaseNode {
    private final String property;

    public AccessNode(long l, int n, Expression expression, String string) {
        super(l, n, expression, false, false);
        this.property = string;
    }

    private AccessNode(AccessNode accessNode, Expression expression, String string, boolean bl, boolean bl2) {
        super(accessNode, expression, bl, bl2);
        this.property = string;
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> nodeVisitor) {
        if (nodeVisitor.enterAccessNode(this)) {
            return nodeVisitor.leaveAccessNode(this.setBase((Expression)this.base.accept(nodeVisitor)));
        }
        return this;
    }

    @Override
    public <R> R accept(TranslatorNodeVisitor<? extends LexicalContext, R> translatorNodeVisitor) {
        return translatorNodeVisitor.enterAccessNode(this);
    }

    @Override
    public void toString(StringBuilder stringBuilder, boolean bl) {
        boolean bl2 = this.tokenType().needsParens(this.getBase().tokenType(), true);
        if (bl2) {
            stringBuilder.append('(');
        }
        this.base.toString(stringBuilder, bl);
        if (bl2) {
            stringBuilder.append(')');
        }
        stringBuilder.append('.');
        stringBuilder.append(this.property);
    }

    public String getProperty() {
        return this.property;
    }

    private AccessNode setBase(Expression expression) {
        if (this.base == expression) {
            return this;
        }
        return new AccessNode(this, expression, this.property, this.isFunction(), this.isSuper());
    }

    @Override
    public AccessNode setIsFunction() {
        if (this.isFunction()) {
            return this;
        }
        return new AccessNode(this, this.base, this.property, true, this.isSuper());
    }

    @Override
    public AccessNode setIsSuper() {
        if (this.isSuper()) {
            return this;
        }
        return new AccessNode(this, this.base, this.property, this.isFunction(), true);
    }
}

