/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser;

import com.oracle.js.parser.ParserException;
import com.oracle.js.parser.Source;
import com.oracle.js.parser.Token;
import java.io.PrintWriter;

public abstract class ErrorManager {
    private int errors;
    private int warnings;
    private int limit = 100;
    private boolean warningsAsErrors = false;
    private ParserException parserException;

    protected ErrorManager() {
    }

    private void checkLimit() {
        int n = this.errors;
        if (this.warningsAsErrors) {
            n += this.warnings;
        }
        if (this.limit != 0 && n > this.limit) {
            throw new RuntimeException("too many errors");
        }
    }

    public static String format(String string, Source source, int n, int n2, long l) {
        String string2 = System.lineSeparator();
        int n3 = Token.descPosition(l);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(source.getName()).append(':').append(n).append(':').append(n2).append(' ').append(string).append(string2);
        String string3 = source.getSourceLine(n3);
        stringBuilder.append(string3).append(string2);
        for (int i = 0; i < n2; ++i) {
            if (string3.charAt(i) == '\t') {
                stringBuilder.append('\t');
                continue;
            }
            stringBuilder.append(' ');
        }
        stringBuilder.append('^');
        return stringBuilder.toString();
    }

    protected void message(String string) {
    }

    public void error(ParserException parserException) {
        if (this.parserException == null) {
            this.parserException = parserException;
        }
        this.error(parserException.getMessage());
    }

    public void error(String string) {
        this.message(string);
        ++this.errors;
        this.checkLimit();
    }

    public void warning(ParserException parserException) {
        this.warning(parserException.getMessage());
    }

    public void warning(String string) {
        this.message(string);
        ++this.warnings;
        this.checkLimit();
    }

    public boolean hasErrors() {
        return this.errors != 0;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int n) {
        this.limit = n;
    }

    public boolean isWarningsAsErrors() {
        return this.warningsAsErrors;
    }

    public void setWarningsAsErrors(boolean bl) {
        this.warningsAsErrors = bl;
    }

    public int getNumberOfErrors() {
        return this.errors;
    }

    public int getNumberOfWarnings() {
        return this.warnings;
    }

    public ParserException getParserException() {
        return this.parserException;
    }

    public static class ThrowErrorManager
    extends ErrorManager {
        @Override
        public void error(String string) {
            throw new ParserException(string);
        }

        @Override
        public void error(ParserException parserException) {
            throw parserException;
        }

        @Override
        protected void message(String string) {
            System.err.println(string);
        }
    }

    public static class StringBuilderErrorManager
    extends ErrorManager {
        private final StringBuilder buffer = new StringBuilder(0);

        @Override
        protected void message(String string) {
            this.buffer.append(string).append('\n');
        }

        public String getOutput() {
            return this.buffer.toString();
        }
    }

    public static class PrintWriterErrorManager
    extends ErrorManager {
        private final PrintWriter writer;

        public PrintWriterErrorManager() {
            this(new PrintWriter(System.err, true));
        }

        public PrintWriterErrorManager(PrintWriter printWriter) {
            this.writer = printWriter;
        }

        @Override
        protected void message(String string) {
            this.writer.println(string);
        }
    }
}

