/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

import com.oracle.js.parser.ir.Block;
import com.oracle.js.parser.ir.CatchNode;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.Statement;
import com.oracle.js.parser.ir.Symbol;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import com.oracle.js.parser.ir.visitor.TranslatorNodeVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class TryNode
extends Statement {
    private final Block body;
    private final List<Block> catchBlocks;
    private final Block finallyBody;
    private Symbol exception;

    public TryNode(int n, long l, int n2, Block block, List<Block> list, Block block2) {
        super(n, l, n2);
        this.body = block;
        this.catchBlocks = list;
        this.finallyBody = block2;
    }

    private TryNode(TryNode tryNode, Block block, List<Block> list, Block block2) {
        super(tryNode);
        this.body = block;
        this.catchBlocks = list;
        this.finallyBody = block2;
        this.exception = tryNode.exception;
    }

    @Override
    public boolean isTerminal() {
        if (this.body.isTerminal()) {
            for (Block block : this.getCatchBlocks()) {
                if (block.isTerminal()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> nodeVisitor) {
        if (nodeVisitor.enterTryNode(this)) {
            Block block = this.finallyBody == null ? null : (Block)this.finallyBody.accept(nodeVisitor);
            Block block2 = (Block)this.body.accept(nodeVisitor);
            return nodeVisitor.leaveTryNode(this.setBody(block2).setFinallyBody(block).setCatchBlocks(Node.accept(nodeVisitor, this.catchBlocks)));
        }
        return this;
    }

    @Override
    public <R> R accept(TranslatorNodeVisitor<? extends LexicalContext, R> translatorNodeVisitor) {
        return translatorNodeVisitor.enterTryNode(this);
    }

    @Override
    public void toString(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("try ");
    }

    public Block getBody() {
        return this.body;
    }

    public TryNode setBody(Block block) {
        if (this.body == block) {
            return this;
        }
        return new TryNode(this, block, this.catchBlocks, this.finallyBody);
    }

    public List<CatchNode> getCatches() {
        ArrayList<CatchNode> arrayList = new ArrayList<CatchNode>(this.catchBlocks.size());
        for (Block block : this.catchBlocks) {
            arrayList.add(TryNode.getCatchNodeFromBlock(block));
        }
        return Collections.unmodifiableList(arrayList);
    }

    private static CatchNode getCatchNodeFromBlock(Block block) {
        return (CatchNode)block.getStatements().get(0);
    }

    public List<Block> getCatchBlocks() {
        return Collections.unmodifiableList(this.catchBlocks);
    }

    public TryNode setCatchBlocks(List<Block> list) {
        if (this.catchBlocks == list) {
            return this;
        }
        return new TryNode(this, this.body, list, this.finallyBody);
    }

    public Symbol getException() {
        return this.exception;
    }

    public Block getFinallyBody() {
        return this.finallyBody;
    }

    public TryNode setFinallyBody(Block block) {
        if (this.finallyBody == block) {
            return this;
        }
        return new TryNode(this, this.body, this.catchBlocks, block);
    }
}

