/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser;

import com.oracle.js.parser.Token;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Objects;

public final class Source {
    private static final int BUF_SIZE = 8192;
    private final String name;
    private final String base;
    private final Data data;
    private int hash;
    private volatile byte[] digest;
    private String explicitURL;

    private Source(String string, String string2, Data data) {
        this.name = string;
        this.base = string2;
        this.data = data;
    }

    private static Source sourceFor(String string, String string2, URLData uRLData) throws IOException {
        try {
            Source source = new Source(string, string2, uRLData);
            uRLData.load();
            return source;
        }
        catch (RuntimeException runtimeException) {
            Throwable throwable = runtimeException.getCause();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw runtimeException;
        }
    }

    private String data() {
        return this.data.data();
    }

    public static Source sourceFor(String string, String string2, boolean bl) {
        return new Source(string, Source.baseName(string), new RawData(string2, bl));
    }

    public static Source sourceFor(String string, String string2) {
        return Source.sourceFor(string, string2, false);
    }

    public static Source sourceFor(String string, URL uRL) throws IOException {
        return Source.sourceFor(string, uRL, null);
    }

    public static Source sourceFor(String string, URL uRL, Charset charset) throws IOException {
        return Source.sourceFor(string, Source.baseURL(uRL), new URLData(uRL, charset));
    }

    public static Source sourceFor(String string, File file) throws IOException {
        return Source.sourceFor(string, file, null);
    }

    public static Source sourceFor(String string, Path path) throws IOException {
        File file = null;
        try {
            file = path.toFile();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        if (file != null) {
            return Source.sourceFor(string, file);
        }
        return Source.sourceFor(string, Files.newBufferedReader(path));
    }

    public static Source sourceFor(String string, File file, Charset charset) throws IOException {
        File file2 = file.getAbsoluteFile();
        return Source.sourceFor(string, Source.dirName(file2, null), new FileData(file, charset));
    }

    public static Source sourceFor(String string, Reader reader) throws IOException {
        return new Source(string, Source.baseName(string), new RawData(reader));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Source)) {
            return false;
        }
        Source source = (Source)object;
        return Objects.equals(this.name, source.name) && this.data.equals(source.data);
    }

    public int hashCode() {
        int n = this.hash;
        if (n == 0) {
            n = this.hash = this.data.hashCode() ^ Objects.hashCode(this.name);
        }
        return n;
    }

    public String getString() {
        return this.data.toString();
    }

    public String getName() {
        return this.name;
    }

    public long getLastModified() {
        return this.data.lastModified();
    }

    public String getBase() {
        return this.base;
    }

    public String getString(int n, int n2) {
        return this.data().substring(n, n + n2);
    }

    public String getString(long l) {
        int n = Token.descPosition(l);
        int n2 = Token.descLength(l);
        return this.getString(n, n2);
    }

    public URL getURL() {
        return this.data.url();
    }

    public String getExplicitURL() {
        return this.explicitURL;
    }

    public void setExplicitURL(String string) {
        this.explicitURL = string;
    }

    public boolean isEvalCode() {
        return this.data.isEvalCode();
    }

    private int findBOLN(int n) {
        String string = this.data();
        for (int i = n - 1; i > 0; --i) {
            char c = string.charAt(i);
            if (c != '\n' && c != '\r') continue;
            return i + 1;
        }
        return 0;
    }

    private int findEOLN(int n) {
        String string = this.data();
        int n2 = string.length();
        for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            if (c != '\n' && c != '\r') continue;
            return i - 1;
        }
        return n2 - 1;
    }

    public int getLine(int n) {
        String string = this.data();
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c != '\n') continue;
            ++n2;
        }
        return n2;
    }

    public int getColumn(int n) {
        return n - this.findBOLN(n);
    }

    public String getSourceLine(int n) {
        int n2 = this.findBOLN(n);
        int n3 = this.findEOLN(n);
        return this.data().substring(n2, n3 + 1);
    }

    public String getContent() {
        return this.data();
    }

    public int getLength() {
        return this.data.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFully(Reader reader) throws IOException {
        char[] cArray = new char[8192];
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            while ((n = reader.read(cArray, 0, cArray.length)) > 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        finally {
            reader.close();
        }
        return stringBuilder.toString();
    }

    public static String readFully(File file) throws IOException {
        if (!file.isFile()) {
            throw new IOException(file + " is not a file");
        }
        return Source.byteArrayToString(Files.readAllBytes(file.toPath()));
    }

    public static String readFully(File file, Charset charset) throws IOException {
        if (!file.isFile()) {
            throw new IOException(file + " is not a file");
        }
        byte[] byArray = Files.readAllBytes(file.toPath());
        return charset != null ? new String(byArray, charset) : Source.byteArrayToString(byArray);
    }

    public static String readFully(URL uRL) throws IOException {
        return Source.readFully(uRL.openStream());
    }

    public static String readFully(URL uRL, Charset charset) throws IOException {
        return Source.readFully(uRL.openStream(), charset);
    }

    public String getDigest() {
        return new String(this.getDigestBytes(), StandardCharsets.US_ASCII);
    }

    private byte[] getDigestBytes() {
        byte[] byArray = this.digest;
        if (byArray == null) {
            String string = this.data();
            byte[] byArray2 = new byte[string.length() * 2];
            for (int i = 0; i < string.length(); ++i) {
                byArray2[i * 2] = (byte)(string.charAt(i) & 0xFF);
                byArray2[i * 2 + 1] = (byte)((string.charAt(i) & 0xFF00) >> 8);
            }
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
                if (this.name != null) {
                    messageDigest.update(this.name.getBytes(StandardCharsets.UTF_8));
                }
                if (this.base != null) {
                    messageDigest.update(this.base.getBytes(StandardCharsets.UTF_8));
                }
                if (this.getURL() != null) {
                    messageDigest.update(this.getURL().toString().getBytes(StandardCharsets.UTF_8));
                }
                Base64.Encoder encoder = Base64.getUrlEncoder().withoutPadding();
                this.digest = byArray = encoder.encode(messageDigest.digest(byArray2));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new RuntimeException(noSuchAlgorithmException);
            }
        }
        return byArray;
    }

    public static String baseURL(URL uRL) {
        if (uRL.getProtocol().equals("file")) {
            try {
                Path path = Paths.get(uRL.toURI());
                Path path2 = path.getParent();
                return path2 != null ? path2 + File.separator : null;
            }
            catch (IOError | SecurityException | URISyntaxException throwable) {
                return null;
            }
        }
        String string = uRL.getPath();
        if (string.isEmpty()) {
            return null;
        }
        string = string.substring(0, string.lastIndexOf(47) + 1);
        int n = uRL.getPort();
        try {
            return new URL(uRL.getProtocol(), uRL.getHost(), n, string).toString();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private static String dirName(File file, String string) {
        String string2 = file.getParent();
        return string2 != null ? string2 + File.separator : string;
    }

    private static String baseName(String string) {
        int n = string.lastIndexOf(47);
        if (n == -1) {
            n = string.lastIndexOf(92);
        }
        return n != -1 ? string.substring(0, n + 1) : null;
    }

    public static String readFully(InputStream inputStream, Charset charset) throws IOException {
        return charset != null ? new String(Source.readBytes(inputStream), charset) : Source.readFully(inputStream);
    }

    public static String readFully(InputStream inputStream) throws IOException {
        return Source.byteArrayToString(Source.readBytes(inputStream));
    }

    private static String byteArrayToString(byte[] byArray) {
        Charset charset = StandardCharsets.UTF_8;
        int n = 0;
        if (byArray.length > 1 && byArray[0] == -2 && byArray[1] == -1) {
            n = 2;
            charset = StandardCharsets.UTF_16BE;
        } else if (byArray.length > 1 && byArray[0] == -1 && byArray[1] == -2) {
            if (byArray.length > 3 && byArray[2] == 0 && byArray[3] == 0) {
                n = 4;
                charset = Charset.forName("UTF-32LE");
            } else {
                n = 2;
                charset = StandardCharsets.UTF_16LE;
            }
        } else if (byArray.length > 2 && byArray[0] == -17 && byArray[1] == -69 && byArray[2] == -65) {
            n = 3;
            charset = StandardCharsets.UTF_8;
        } else if (byArray.length > 3 && byArray[0] == 0 && byArray[1] == 0 && byArray[2] == -2 && byArray[3] == -1) {
            n = 4;
            charset = Charset.forName("UTF-32BE");
        }
        return new String(byArray, n, byArray.length - n, charset);
    }

    /*
     * Loose catch block
     */
    static byte[] readBytes(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[8192];
        try {
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                int n;
                while ((n = inputStream.read(byArray, 0, byArray.length)) > 0) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                byte[] byArray2 = byteArrayOutputStream.toByteArray();
                return byArray2;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            inputStream.close();
        }
    }

    public String toString() {
        return this.getName();
    }

    private static URL getURLFromFile(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (SecurityException | MalformedURLException exception) {
            return null;
        }
    }

    private static class FileData
    extends URLData {
        private final File file;

        private FileData(File file, Charset charset) {
            super(Source.getURLFromFile(file), charset);
            this.file = file;
        }

        @Override
        protected void loadMeta() {
            if (this.length == 0 && this.lastModified == 0L) {
                this.length = (int)this.file.length();
                this.lastModified = this.file.lastModified();
            }
        }

        @Override
        protected void load() throws IOException {
            if (this.source == null) {
                this.source = this.cs == null ? Source.readFully(this.file) : Source.readFully(this.file, this.cs);
                this.length = this.source.length();
                this.lastModified = this.file.lastModified();
            }
        }
    }

    private static class URLData
    implements Data {
        private final URL url;
        protected final Charset cs;
        private int hash;
        protected String source;
        protected int length;
        protected long lastModified;

        private URLData(URL uRL, Charset charset) {
            this.url = Objects.requireNonNull(uRL);
            this.cs = charset;
        }

        public int hashCode() {
            int n = this.hash;
            if (n == 0) {
                n = this.hash = this.url.hashCode();
            }
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof URLData)) {
                return false;
            }
            URLData uRLData = (URLData)object;
            if (this.url.equals(uRLData.url)) {
                try {
                    if (this.isDeferred()) {
                        assert (!uRLData.isDeferred());
                        this.loadMeta();
                    } else if (uRLData.isDeferred()) {
                        uRLData.loadMeta();
                    }
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                return this.length == uRLData.length && this.lastModified == uRLData.lastModified;
            }
            return false;
        }

        public String toString() {
            return this.data();
        }

        @Override
        public URL url() {
            return this.url;
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public long lastModified() {
            return this.lastModified;
        }

        @Override
        public String data() {
            assert (!this.isDeferred());
            return this.source;
        }

        @Override
        public boolean isEvalCode() {
            return false;
        }

        boolean isDeferred() {
            return this.source == null;
        }

        protected void load() throws IOException {
            if (this.source == null) {
                URLConnection uRLConnection = this.url.openConnection();
                try (InputStream inputStream = uRLConnection.getInputStream();){
                    this.source = this.cs == null ? Source.readFully(inputStream) : Source.readFully(inputStream, this.cs);
                    this.length = this.source.length();
                    this.lastModified = uRLConnection.getLastModified();
                }
            }
        }

        protected void loadMeta() throws IOException {
            if (this.length == 0 && this.lastModified == 0L) {
                URLConnection uRLConnection = this.url.openConnection();
                this.length = uRLConnection.getContentLength();
                this.lastModified = uRLConnection.getLastModified();
            }
        }
    }

    private static final class RawData
    implements Data {
        private final String source;
        private final boolean evalCode;
        private int hash;

        private RawData(String string, boolean bl) {
            this.source = Objects.requireNonNull(string);
            this.evalCode = bl;
        }

        private RawData(Reader reader) throws IOException {
            this(Source.readFully(reader), false);
        }

        public int hashCode() {
            int n = this.hash;
            if (n == 0) {
                n = this.hash = this.source.hashCode() ^ (this.evalCode ? 1 : 0);
            }
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof RawData) {
                RawData rawData = (RawData)object;
                return this.source.equals(rawData.source) && this.evalCode == rawData.evalCode;
            }
            return false;
        }

        public String toString() {
            return this.data();
        }

        @Override
        public URL url() {
            return null;
        }

        @Override
        public int length() {
            return this.source.length();
        }

        @Override
        public long lastModified() {
            return 0L;
        }

        @Override
        public String data() {
            return this.source;
        }

        @Override
        public boolean isEvalCode() {
            return this.evalCode;
        }
    }

    private static interface Data {
        public URL url();

        public int length();

        public long lastModified();

        public String data();

        public boolean isEvalCode();
    }
}

