/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import org.openide.util.io.NbObjectInputStream;
import org.openide.util.io.NbObjectOutputStream;

public final class NbMarshalledObject
implements Serializable {
    private static final long serialVersionUID = 7842398740921434354L;
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private byte[] objBytes = null;
    private int hash;

    public NbMarshalledObject(Object obj) throws IOException {
        if (obj == null) {
            this.hash = 17;
            return;
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        NbObjectOutputStream out = new NbObjectOutputStream(bout);
        out.writeObject(obj);
        out.flush();
        this.objBytes = bout.toByteArray();
        int h = 0;
        for (int i = 0; i < this.objBytes.length; ++i) {
            h = 37 * h + this.objBytes[i];
        }
        this.hash = h;
    }

    public Object get() throws IOException, ClassNotFoundException {
        if (this.objBytes == null) {
            return null;
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(this.objBytes);
        try (NbObjectInputStream ois = new NbObjectInputStream(bin);){
            Object object = ois.readObject();
            return object;
        }
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof NbMarshalledObject) {
            NbMarshalledObject other = (NbMarshalledObject)obj;
            return Arrays.equals(this.objBytes, other.objBytes);
        }
        return false;
    }
}

