/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Enumerations;

public class NbCollections {
    private static final Logger LOG = Logger.getLogger(NbCollections.class.getName());

    private NbCollections() {
    }

    public static <E> Set<E> checkedSetByCopy(Set rawSet, Class<E> type, boolean strict) throws ClassCastException {
        HashSet<E> s = new HashSet<E>(rawSet.size() * 4 / 3 + 1);
        for (Object e : rawSet) {
            try {
                s.add(type.cast(e));
            }
            catch (ClassCastException x) {
                if (strict) {
                    throw x;
                }
                LOG.log(Level.WARNING, "Element {0} not assignable to {1}", new Object[]{e, type});
            }
        }
        return s;
    }

    public static <E> List<E> checkedListByCopy(List rawList, Class<E> type, boolean strict) throws ClassCastException {
        AbstractList l = rawList instanceof RandomAccess ? new ArrayList(rawList.size()) : new LinkedList();
        for (Object e : rawList) {
            try {
                l.add(type.cast(e));
            }
            catch (ClassCastException x) {
                if (strict) {
                    throw x;
                }
                LOG.log(Level.WARNING, "Element {0} not assignable to {1}", new Object[]{e, type});
            }
        }
        return l;
    }

    public static <K, V> Map<K, V> checkedMapByCopy(Map rawMap, Class<K> keyType, Class<V> valueType, boolean strict) throws ClassCastException {
        HashMap<K, V> m2 = new HashMap<K, V>(rawMap.size() * 4 / 3 + 1);
        for (Map.Entry e : rawMap.entrySet()) {
            try {
                m2.put(keyType.cast(e.getKey()), valueType.cast(e.getValue()));
            }
            catch (ClassCastException x) {
                if (strict) {
                    throw x;
                }
                LOG.log(Level.WARNING, "Entry {0} not assignable to <{1},{2}>", new Object[]{e, keyType, valueType});
            }
        }
        return m2;
    }

    public static <E> Iterator<E> checkedIteratorByFilter(Iterator rawIterator, final Class<E> type, final boolean strict) {
        return new CheckedIterator<E>(rawIterator){

            @Override
            protected boolean accept(Object o) {
                if (o == null) {
                    return true;
                }
                if (type.isInstance(o)) {
                    return true;
                }
                if (strict) {
                    throw new ClassCastException(o + " was not a " + type.getName());
                }
                return false;
            }
        };
    }

    public static <E> Set<E> checkedSetByFilter(Set rawSet, Class<E> type, boolean strict) {
        return new CheckedSet<E>(rawSet, type, strict);
    }

    public static <K, V> Map<K, V> checkedMapByFilter(Map rawMap, Class<K> keyType, Class<V> valueType, boolean strict) {
        return new CheckedMap<K, V>(rawMap, keyType, valueType, strict);
    }

    public static <E> Enumeration<E> checkedEnumerationByFilter(Enumeration<?> rawEnum, final Class<E> type, final boolean strict) {
        Enumeration<?> _rawEnum = rawEnum;
        return Enumerations.filter(_rawEnum, new Enumerations.Processor<Object, E>(){

            @Override
            public E process(Object o, Collection<Object> ignore) {
                if (o == null) {
                    return null;
                }
                try {
                    return type.cast(o);
                }
                catch (ClassCastException x) {
                    if (strict) {
                        throw x;
                    }
                    return null;
                }
            }
        });
    }

    public static <E> Iterable<E> iterable(final Iterator<E> iterator) {
        if (iterator == null) {
            throw new NullPointerException();
        }
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return iterator;
            }
        };
    }

    public static <E> Iterable<E> iterable(final Enumeration<E> enumeration) {
        if (enumeration == null) {
            throw new NullPointerException();
        }
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return new Iterator<E>(){

                    @Override
                    public boolean hasNext() {
                        return enumeration.hasMoreElements();
                    }

                    @Override
                    public E next() {
                        return enumeration.nextElement();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private static final class CheckedMap<K, V>
    extends AbstractMap<K, V>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Map rawMap;
        private final Class<K> keyType;
        private final Class<V> valueType;
        private final boolean strict;

        public CheckedMap(Map rawMap, Class<K> keyType, Class<V> valueType, boolean strict) {
            this.rawMap = rawMap;
            this.keyType = keyType;
            this.valueType = valueType;
            this.strict = strict;
        }

        private boolean acceptKey(Object o) {
            if (o == null) {
                return true;
            }
            if (this.keyType.isInstance(o)) {
                return true;
            }
            if (this.strict) {
                throw new ClassCastException(o + " was not a " + this.keyType.getName());
            }
            return false;
        }

        private boolean acceptValue(Object o) {
            if (o == null) {
                return true;
            }
            if (this.valueType.isInstance(o)) {
                return true;
            }
            if (this.strict) {
                throw new ClassCastException(o + " was not a " + this.valueType.getName());
            }
            return false;
        }

        private boolean acceptEntry(Map.Entry e) {
            return this.acceptKey(e.getKey()) && this.acceptValue(e.getValue());
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new EntrySet();
        }

        @Override
        public V get(Object key) {
            Object o = this.rawMap.get(this.keyType.cast(key));
            if (this.acceptValue(o)) {
                Object v = o;
                return v;
            }
            return null;
        }

        @Override
        public V put(K key, V value) {
            V old = this.rawMap.put(this.keyType.cast(key), this.valueType.cast(value));
            if (this.acceptValue(old)) {
                return old;
            }
            return null;
        }

        @Override
        public V remove(Object key) {
            Object old = this.rawMap.remove(this.keyType.cast(key));
            if (this.acceptValue(old)) {
                Object v = old;
                return v;
            }
            return null;
        }

        @Override
        public boolean containsKey(Object key) {
            return this.rawMap.containsKey(this.keyType.cast(key)) && this.acceptValue(this.rawMap.get(key));
        }

        @Override
        public boolean containsValue(Object value) {
            return super.containsValue(this.valueType.cast(value));
        }

        @Override
        public int size() {
            int c = 0;
            Iterator it = this.rawMap.entrySet().iterator();
            while (it.hasNext()) {
                if (!this.acceptEntry(it.next())) continue;
                ++c;
            }
            return c;
        }

        private final class EntrySet
        extends AbstractSet<Map.Entry<K, V>> {
            private EntrySet() {
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new CheckedIterator<Map.Entry<K, V>>(CheckedMap.this.rawMap.entrySet().iterator()){

                    @Override
                    protected boolean accept(Object o) {
                        return CheckedMap.this.acceptEntry((Map.Entry)o);
                    }
                };
            }

            @Override
            public int size() {
                int c = 0;
                Iterator it = CheckedMap.this.rawMap.entrySet().iterator();
                while (it.hasNext()) {
                    if (!CheckedMap.this.acceptEntry(it.next())) continue;
                    ++c;
                }
                return c;
            }
        }
    }

    private static final class CheckedSet<E>
    extends AbstractSet<E>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Set rawSet;
        private final Class<E> type;
        private final boolean strict;

        public CheckedSet(Set rawSet, Class<E> type, boolean strict) {
            this.rawSet = rawSet;
            this.type = type;
            this.strict = strict;
        }

        private boolean acceptEntry(Object o) {
            if (o == null) {
                return true;
            }
            if (this.type.isInstance(o)) {
                return true;
            }
            if (this.strict) {
                throw new ClassCastException(o + " was not a " + this.type.getName());
            }
            return false;
        }

        @Override
        public Iterator<E> iterator() {
            return new CheckedIterator<E>(this.rawSet.iterator()){

                @Override
                protected boolean accept(Object o) {
                    return this.acceptEntry(o);
                }
            };
        }

        @Override
        public int size() {
            int c = 0;
            Iterator it = this.rawSet.iterator();
            while (it.hasNext()) {
                if (!this.acceptEntry(it.next())) continue;
                ++c;
            }
            return c;
        }

        @Override
        public boolean add(E o) {
            return this.rawSet.add(this.type.cast(o));
        }

        @Override
        public boolean contains(Object o) {
            return this.rawSet.contains(this.type.cast(o));
        }
    }

    private static abstract class CheckedIterator<E>
    implements Iterator<E> {
        private static final Object WAITING = new Object();
        private final Iterator it;
        private Object next = WAITING;

        public CheckedIterator(Iterator it) {
            this.it = it;
        }

        protected abstract boolean accept(Object var1);

        @Override
        public boolean hasNext() {
            if (this.next != WAITING) {
                return true;
            }
            while (this.it.hasNext()) {
                this.next = this.it.next();
                if (!this.accept(this.next)) continue;
                return true;
            }
            this.next = WAITING;
            return false;
        }

        @Override
        public E next() {
            if (this.next == WAITING && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            assert (this.next != WAITING);
            Object x = this.next;
            this.next = WAITING;
            return (E)x;
        }

        @Override
        public void remove() {
            this.it.remove();
        }
    }
}

