/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.filesystems.declmime;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.openide.filesystems.declmime.MIMEResolverImpl;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MIMEResolver;
import org.openide.filesystems.annotations.LayerBuilder;
import org.openide.filesystems.annotations.LayerGeneratingProcessor;
import org.openide.filesystems.annotations.LayerGenerationException;

public class MIMEResolverProcessor
extends LayerGeneratingProcessor {
    private static final String SUFFIX = ".xml";

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> set = new HashSet<String>();
        set.add(MIMEResolver.Registration.class.getCanonicalName());
        set.add(MIMEResolver.ExtensionRegistration.class.getCanonicalName());
        set.add(MIMEResolver.NamespaceRegistration.class.getCanonicalName());
        return set;
    }

    @Override
    protected boolean handleProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) throws LayerGenerationException {
        Annotation r;
        for (Element element : roundEnv.getElementsAnnotatedWith(MIMEResolver.Registration.class)) {
            r = element.getAnnotation(MIMEResolver.Registration.class);
            this.registerDefinition(element, r.resource(), (MIMEResolver.Registration)r);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(MIMEResolver.ExtensionRegistration.class)) {
            r = element.getAnnotation(MIMEResolver.ExtensionRegistration.class);
            this.registerExt(element, (MIMEResolver.ExtensionRegistration)r);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(MIMEResolver.NamespaceRegistration.class)) {
            r = element.getAnnotation(MIMEResolver.NamespaceRegistration.class);
            this.registerNamespace(element, (MIMEResolver.NamespaceRegistration)r);
        }
        return true;
    }

    private void registerExt(Element e, MIMEResolver.ExtensionRegistration r) throws LayerGenerationException {
        LayerBuilder b = this.layer(e);
        LayerBuilder.File f = b.file("Services/MIMEResolver/" + this.getName(e).replace('.', '-') + "-Extension.xml");
        f.methodvalue("instanceCreate", MIMEResolver.class.getName(), "create");
        f.stringvalue("instanceClass", MIMEResolver.class.getName());
        f.stringvalue("mimeType", r.mimeType());
        int cnt = 0;
        for (String ext : r.extension()) {
            f.stringvalue("ext." + cnt++, ext);
        }
        f.position(r.position());
        int ccnt = 0;
        for (String chooser : r.showInFileChooser()) {
            f.bundlevalue("fileChooser." + ccnt++, chooser);
        }
        f.bundlevalue("displayName", r.displayName());
        f.write();
    }

    private void registerDefinition(Element e, String relRes, MIMEResolver.Registration r) throws LayerGenerationException {
        String absRes = LayerBuilder.absolutizeResource(e, relRes);
        LayerBuilder b = this.layer(e);
        javax.tools.FileObject fo = b.validateResource(absRes, e, r, null, false);
        LayerBuilder.File f = b.file("Services/MIMEResolver/" + this.getName(e).replace('.', '-') + "-Registration.xml");
        f.methodvalue("instanceCreate", MIMEResolver.class.getName(), "create");
        f.stringvalue("instanceClass", MIMEResolver.class.getName());
        f.serialvalue("bytes", this.generateInstanceResolver(fo, e, f, r));
        f.position(r.position());
        int ccnt = 0;
        for (String chooser : r.showInFileChooser()) {
            f.bundlevalue("fileChooser." + ccnt++, chooser);
        }
        f.bundlevalue("displayName", r.displayName());
        f.write();
    }

    private byte[] generateInstanceResolver(javax.tools.FileObject fo, Element e, LayerBuilder.File f, MIMEResolver.Registration r) throws LayerGenerationException {
        try {
            int ch;
            InputStream is = fo.openInputStream();
            FileObject tmp = FileUtil.createMemoryFileSystem().getRoot().createData("resolver.xml");
            OutputStream os = tmp.getOutputStream();
            while ((ch = is.read()) != -1) {
                os.write(ch);
            }
            os.close();
            is.close();
            MIMEResolver resolver = MIMEResolverImpl.forDescriptor(tmp, false);
            this.setFileChooserRelatedAttributes(r, resolver, f);
            byte[] almostResult = MIMEResolverImpl.toStream(resolver);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(out);
            oos.writeObject(almostResult);
            oos.close();
            return out.toByteArray();
        }
        catch (IOException ex) {
            LayerGenerationException le = new LayerGenerationException("Cannot process " + fo, e);
            le.initCause(ex);
            throw le;
        }
    }

    private void registerNamespace(Element e, MIMEResolver.NamespaceRegistration r) throws LayerGenerationException {
        LayerBuilder b = this.layer(e);
        LayerBuilder.File f = b.file("Services/MIMEResolver/" + this.getName(e).replace('.', '-') + "-Namespace.xml");
        f.methodvalue("instanceCreate", MIMEResolver.class.getName(), "create");
        f.stringvalue("instanceClass", MIMEResolver.class.getName());
        f.stringvalue("mimeType", r.mimeType());
        int cnt = 0;
        for (String ext : r.doctypePublicId()) {
            f.stringvalue("doctype." + cnt++, ext);
        }
        cnt = 0;
        for (String ext : r.checkedExtension()) {
            f.stringvalue("ext." + cnt++, ext);
        }
        cnt = 0;
        for (String ext : r.acceptedExtension()) {
            f.stringvalue("accept." + cnt++, ext);
        }
        cnt = 0;
        f.stringvalue("element", r.elementName());
        for (String ext : r.elementNS()) {
            f.stringvalue("ns." + cnt++, ext);
        }
        f.position(r.position());
        f.bundlevalue("displayName", r.displayName());
        f.write();
    }

    private String getName(Element e) {
        if (e.getKind().isClass() || e.getKind().isInterface()) {
            return this.processingEnv.getElementUtils().getBinaryName((TypeElement)e).toString();
        }
        if (e.getKind() == ElementKind.PACKAGE) {
            return e.getSimpleName().toString();
        }
        return this.getName(e.getEnclosingElement()) + "." + e.getSimpleName();
    }

    private Set<String> unq(String[] array) {
        return this.unq(Arrays.asList(array));
    }

    private Set<String> unq(Collection collection) {
        TreeSet<String> s = new TreeSet<String>();
        s.addAll(collection);
        return s;
    }

    /*
     * WARNING - void declaration
     */
    private void setFileChooserRelatedAttributes(MIMEResolver.Registration r, MIMEResolver resolver, LayerBuilder.File f) {
        if (r.showInFileChooser().length > 0) {
            String[] types = MIMEResolverImpl.getMIMETypes(resolver);
            List<String> exts = ((FilterInfo)((Object)resolver)).getExtensions();
            int cnt = 0;
            for (String string : this.unq(exts)) {
                f.stringvalue("ext." + cnt++, string);
            }
            int tcnt = 0;
            for (String type : this.unq(types)) {
                f.stringvalue("mimeType." + tcnt++, type);
            }
            boolean bl = false;
            for (String name : ((FilterInfo)((Object)resolver)).getFileNames()) {
                void var8_12;
                f.stringvalue("fileName." + (int)(++var8_12), name);
            }
        }
    }

    static interface FilterInfo {
        public List<String> getExtensions();

        public List<String> getFileNames();
    }
}

