/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xdm.nodes;

import java.util.List;
import org.netbeans.modules.xml.xdm.nodes.Node;
import org.netbeans.modules.xml.xdm.nodes.NodeImpl;
import org.netbeans.modules.xml.xdm.nodes.Token;
import org.netbeans.modules.xml.xdm.nodes.TokenType;
import org.netbeans.modules.xml.xdm.visitor.XMLNodeVisitor;

public class Text
extends NodeImpl
implements Node,
org.w3c.dom.Text {
    @Override
    public void accept(XMLNodeVisitor visitor) {
        visitor.visit(this);
    }

    Text() {
    }

    Text(String text) {
        this();
        this.setText(text);
    }

    @Override
    public String getNodeValue() {
        return this.getText();
    }

    @Override
    public short getNodeType() {
        return 3;
    }

    @Override
    public String getNodeName() {
        return "#text";
    }

    @Override
    public String getNamespaceURI() {
        return null;
    }

    public String getText() {
        StringBuilder txtBuf = new StringBuilder();
        for (Token token : this.getTokens()) {
            if (token.getType() != TokenType.TOKEN_CHARACTER_DATA) continue;
            txtBuf.append(token.getValue());
        }
        return this.removeEntityReference(txtBuf.toString());
    }

    public void setText(String text) {
        this.checkNotInTree();
        List<Token> tokens = this.getTokensForWrite();
        if (!tokens.isEmpty()) {
            tokens.clear();
        }
        if (text == null) {
            text = "";
        }
        text = this.insertEntityReference(text);
        tokens.add(Token.create(text, TokenType.TOKEN_CHARACTER_DATA));
    }

    @Override
    public boolean isElementContentWhitespace() {
        return false;
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public org.w3c.dom.Text replaceWholeText(String content) {
        return null;
    }

    @Override
    public org.w3c.dom.Text splitText(int offset) {
        return null;
    }

    @Override
    public String getWholeText() {
        return null;
    }

    @Override
    public void setData(String text) {
        this.checkNotInTree();
        List<Token> tokens = this.getTokensForWrite();
        if (!tokens.isEmpty()) {
            tokens.clear();
        }
        if (text == null) {
            text = "";
        }
        tokens.add(Token.create(text, TokenType.TOKEN_CHARACTER_DATA));
    }

    @Override
    public void appendData(String arg) {
    }

    @Override
    public void replaceData(int offset, int count, String arg) {
    }

    @Override
    public void insertData(int offset, String arg) {
    }

    @Override
    public String substringData(int offset, int count) {
        return null;
    }

    @Override
    public String getData() {
        StringBuilder txtBuf = new StringBuilder();
        for (Token token : this.getTokens()) {
            if (token.getType() != TokenType.TOKEN_CHARACTER_DATA) continue;
            txtBuf.append(token.getValue());
        }
        return txtBuf.toString();
    }

    @Override
    public void deleteData(int offset, int count) {
    }

    private String insertEntityReference(String text) {
        return this.removeEntityReference(text).replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    private String removeEntityReference(String text) {
        return text.replace("&amp;", "&").replace("&lt;", "<").replace("&gt;", ">");
    }
}

