/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xdm.nodes;

import java.util.List;
import org.netbeans.modules.xml.xdm.nodes.Text;
import org.netbeans.modules.xml.xdm.nodes.Token;
import org.netbeans.modules.xml.xdm.visitor.XMLNodeVisitor;
import org.w3c.dom.CDATASection;

public class CData
extends Text
implements CDATASection {
    @Override
    public void accept(XMLNodeVisitor visitor) {
        visitor.visit(this);
    }

    CData() {
    }

    CData(String text) {
        this();
        this.stripCDataMarkers(text);
    }

    private void stripCDataMarkers(String data) {
        String normalizedData;
        String string = normalizedData = data == null ? "" : data;
        if (data != null && data.startsWith(Token.CDATA_START.getValue()) && data.endsWith(Token.CDATA_END.getValue())) {
            assert (data.length() >= Token.CDATA_START.getValue().length() + Token.CDATA_END.getValue().length());
            normalizedData = data.substring(Token.CDATA_START.getValue().length(), data.length() - Token.CDATA_END.getValue().length());
        }
        this.setData(normalizedData);
    }

    private void addCDataTokens() {
        List<Token> tokens = this.getTokensForWrite();
        tokens.add(0, Token.CDATA_START);
        tokens.add(Token.CDATA_END);
        this.setTokens(tokens);
    }

    @Override
    public String getNodeValue() {
        return this.getData();
    }

    @Override
    public void setData(String data) {
        super.setData(data);
        this.addCDataTokens();
    }

    @Override
    public short getNodeType() {
        return 4;
    }

    @Override
    public String getNodeName() {
        return "#cdata-section";
    }
}

