/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.validator.visitor;

import java.util.Collection;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.validator.visitor.ValidateConfiguration;
import org.netbeans.modules.xml.wsdl.validator.visitor.ValidationUtils;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.openide.util.NbBundle;

public class ValidateSupport {
    private ValidateConfiguration mValConfig;
    public static final String VAL_MISSING_ATTRIB = "VAL_MISSING_ATTRIB";
    public static final String FIX_MISSING_ATTRIB = "FIX_MISSING_ATTRIB";
    public static final String VAL_NOT_NCNAME_ATTRIB = "VAL_NOT_NCNAME_ATTRIB";
    public static final String FIX_NOT_NCNAME_ATTRIB = "FIX_NOT_NCNAME_ATTRIB";
    public static final String VAL_NOT_QNAME_ATTRIB = "VAL_NOT_QNAME_ATTRIB";
    public static final String FIX_NOT_QNAME_ATTRIB = "FIX_NOT_QNAME_ATTRIB";
    public static final String VAL_PREFIX_NULL_QNAME_ATTRIB = "VAL_PREFIX_NULL_QNAME_ATTRIB";
    public static final String FIX_PREFIX_NULL_QNAME_ATTRIB = "FIX_PREFIX_NULL_QNAME_ATTRIB";
    public static final String VAL_PREFIX_NOT_DEFINED = "VAL_PREFIX_NOT_DEFINED";
    public static final String FIX_PREFIX_NOT_DEFINED = "FIX_PREFIX_NOT_DEFINED";
    public static final String VAL_NOT_BOOLEAN_ATTRIB = "VAL_NOT_BOOLEAN_ATTRIB";
    public static final String FIX_NOT_BOOLEAN_ATTRIB = "FIX_NOT_BOOLEAN_ATTRIB";
    public static final String VAL_NOT_ENUM_ATTRIB = "VAL_NOT_ENUM_ATTRIB";
    public static final String FIX_NOT_ENUM_ATTRIB = "FIX_NOT_ENUM_ATTRIB";
    public static final String VAL_MIN_ELEM_NOT_MET = "VAL_MIN_ELEM_NOT_MET";
    public static final String FIX_MIN_ELEM_NOT_MET = "FIX_MIN_ELEM_NOT_MET";
    public static final String VAL_MISSING_ELEM = "VAL_MISSING_ELEM";
    public static final String FIX_MISSING_ELEM = "FIX_MISSING_ELEM";
    public static final String VAL_MATCHING_WSDL_NOT_FOUND = "VAL_MATCHING_WSDL_NOT_FOUND";
    public static final String FIX_MATCHING_WSDL_NOT_FOUND = "FIX_MATCHING_WSDL_NOT_FOUND";
    public static final String VAL_COMPENSATE_WITH_AN_INVALID_SCOPE = "VAL_COMPENSATE_WITH_AN_INVALID_SCOPE";
    public static final String FIX_COMPENSATE_WITH_AN_INVALID_SCOPE = "FIX_COMPENSATE_WITH_AN_INVALID_SCOPE";
    public static final String VAL_MESSAGETYPE_IN_CONTAINER = "VAL_MESSAGETYPE_IN_CONTAINER";
    public static final String FIX_MESSAGETYPE_IN_CONTAINER = "FIX_MESSAGETYPE_IN_CONTAINER";
    public static final String VAL_UNKNOWN_CONTAINER_IN_CATCH = "VAL_UNKNOWN_CONTAINER_IN_CATCH";
    public static final String FIX_UNKNOWN_CONTAINER_IN_CATCH = "FIX_UNKNOWN_CONTAINER_IN_CATCH";
    public static final String VAL_EMPTY_CONTAINER_IN_CATCH = "VAL_EMPTY_CONTAINER_IN_CATCH";
    public static final String SEQUENCE_TITLE_NAME = "SEQUENCE_TITLE_NAME";
    public static final String VAL_MISSING_CONNECTIONS = "VAL_MISSING_CONNECTIONS";
    public static final String FIX_MISSING_CONNECTIONS = "FIX_MISSING_CONNECTIONS";
    public static final String VAL_SEMANTICALLY_CORRECT_CORRELATION_SET = "VAL_SEMANTICALLY_CORRECT_CORRELATION_SET";
    public static final String FIX_SEMANTICALLY_CORRECT_CORRELATION_SET = "FIX_SEMANTICALLY_CORRECT_CORRELATION_SET";
    public static final String VAL_FAULT_NAME_CANNOT_BE_EMPTY = "VAL_FAULT_NAME_CANNOT_BE_EMPTY";
    public static final String FIX_FAULT_NAME_CANNOT_BE_EMPTY = "FIX_FAULT_NAME_CANNOT_BE_EMPTY";
    public static final String VAL_UNKNOWN_OPERATION = "VAL_UNKNOWN_OPERATION";
    public static final String FIX_UNKNOWN_OPERATION = "FIX_UNKNOWN_OPERATION";
    public static final String VAL_UNKNOWN_PORT_TYPE = "VAL_UNKNOWN_PORT_TYPE";
    public static final String FIX_UNKNOWN_PORT_TYPE = "FIX_UNKNOWN_PORT_TYPE";
    public static final String VAL_ASSIGN_MUST_HAVE_MINIMUM = "VAL_ASSIGN_MUST_HAVE_MINIMUM";
    public static final String FIX_ASSIGN_MUST_HAVE_MINIMUM = "FIX_ASSIGN_MUST_HAVE_MINIMUM";
    public static final String VAL_FOR_EACH_MUST_HAVE_MIN_ONE_COPY = "VAL_FOR_EACH_MUST_HAVE_MIN_ONE_COPY";
    public static final String FIX_FOR_EACH_MUST_HAVE_MIN_ONE_COPY = "FIX_FOR_EACH_MUST_HAVE_MIN_ONE_COPY";
    public static final String VAL_EMPTY_SCOPE = "VAL_EMPTY_SCOPE";
    public static final String FIX_EMPTY_SCOPE = "FIX_EMPTY_SCOPE";
    public static final String VAL_EMPTY_WHILE = "VAL_EMPTY_WHILE";
    public static final String FIX_EMPTY_WHILE = "FIX_EMPTY_WHILE";
    public static final String VAL_EMPTY_COMPENSATION_HANDLER = "VAL_EMPTY_COMPENSATION_HANDLER";
    public static final String FIX_EMPTY_COMPENSATION_HANDLER = "FIX_EMPTY_COMPENSATION_HANDLER";
    public static final String VAL_EMPTY_CATCH = "VAL_EMPTY_CATCH";
    public static final String FIX_EMPTY_CATCH = "FIX_EMPTY_CATCH";
    public static final String VAL_EMPTY_CATCHALL = "VAL_EMPTY_CATCHALL";
    public static final String FIX_EMPTY_CATCHALL = "FIX_EMPTY_CATCHALL";
    public static final String VAL_NO_EINSIGHT_LICENSE_W_EVISION = "VAL_NO_EINSIGHT_LICENSE_W_EVISION";
    public static final String FIX_NO_EINSIGHT_LICENSE_W_EVISION = "FIX_NO_EINSIGHT_LICENSE_W_EVISION";
    private Collection<Validator.ResultItem> mResultItems;
    private Validator mValidator;

    public ValidateSupport(ValidateConfiguration valConfig) {
        this.mValConfig = valConfig;
    }

    public ValidateConfiguration getValidateConfiguration() {
        return this.mValConfig;
    }

    public void setValidateConfiguration(ValidateConfiguration valConfig) {
        this.mValConfig = valConfig;
    }

    public void setResultItems(Collection<Validator.ResultItem> resultItems) {
        this.mResultItems = resultItems;
    }

    public void setValidator(Validator validator) {
        this.mValidator = validator;
    }

    public static boolean isAttributeAbsent(String value) {
        return null == value || value.trim().length() == 0;
    }

    public boolean assertRequiredAttrib(String value, String name, Component source) {
        if (source instanceof WSDLComponent && !this.mValConfig.getBooleanProperty("wsdl.syntax.attrib.required")) {
            return true;
        }
        if (ValidateSupport.isAttributeAbsent(value)) {
            return this.fireToDo(Validator.ResultType.ERROR, source, NbBundle.getMessage(ValidateSupport.class, (String)VAL_MISSING_ATTRIB, (Object)name), NbBundle.getMessage(ValidateSupport.class, (String)FIX_MISSING_ATTRIB, (Object)name));
        }
        return true;
    }

    public boolean assertRequiredAttrib(QName value, String name, Component source, int category) {
        if (source instanceof WSDLComponent && !this.mValConfig.getBooleanProperty("wsdl.syntax.attrib.required")) {
            return true;
        }
        if (value == null || ValidateSupport.isAttributeAbsent(value.toString())) {
            return this.fireToDo(Validator.ResultType.ERROR, source, NbBundle.getMessage(ValidateSupport.class, (String)VAL_MISSING_ATTRIB, (Object)name), NbBundle.getMessage(ValidateSupport.class, (String)FIX_MISSING_ATTRIB, (Object)name));
        }
        return true;
    }

    public boolean assertNCNameAttrib(String value, String name, Component source) {
        if (source instanceof WSDLComponent && !this.mValConfig.getBooleanProperty("wsdl.syntax.attrib.ncname")) {
            return true;
        }
        if (!ValidateSupport.isAttributeAbsent(value) && !ValidationUtils.isNCName(value)) {
            return this.fireToDo(Validator.ResultType.ERROR, source, NbBundle.getMessage(ValidateSupport.class, (String)VAL_NOT_NCNAME_ATTRIB, (Object)name), NbBundle.getMessage(ValidateSupport.class, (String)FIX_NOT_NCNAME_ATTRIB, (Object)name));
        }
        return true;
    }

    public boolean assertQNameListAttrib(String value, String name, Component source, int category) {
        if (source instanceof WSDLComponent && !this.mValConfig.getBooleanProperty("wsdl.syntax.attrib.qname")) {
            return true;
        }
        if (!ValidateSupport.isAttributeAbsent(value)) {
            StringTokenizer parser = new StringTokenizer(value, " ");
            while (parser.hasMoreTokens()) {
                if (this.assertQNameAttrib(parser.nextToken(), name, source, category)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean assertQNameAttrib(QName value, String name, Component source, int category) {
        if (value != null) {
            return this.assertQNameAttrib(value.toString(), name, source, category);
        }
        return true;
    }

    public boolean assertQNameAttrib(String value, String name, Component source, int category) {
        if (source instanceof WSDLComponent && !this.mValConfig.getBooleanProperty("wsdl.syntax.attrib.qname")) {
            return true;
        }
        if (!ValidateSupport.isAttributeAbsent(value)) {
            String ns;
            String prefix;
            if (!ValidationUtils.isQName(value) && !this.fireToDo(Validator.ResultType.ERROR, source, NbBundle.getMessage(ValidateSupport.class, (String)VAL_NOT_QNAME_ATTRIB, (Object)name), NbBundle.getMessage(ValidateSupport.class, (String)FIX_NOT_QNAME_ATTRIB, (Object)name))) {
                return false;
            }
            String[] parts = value.split(":");
            if (parts != null && parts.length > 1 && (prefix = parts[0]) != null && null == (ns = ((AbstractDocumentComponent)source).lookupNamespaceURI(prefix)) && !this.fireToDo(Validator.ResultType.ERROR, source, NbBundle.getMessage(ValidateSupport.class, (String)VAL_PREFIX_NOT_DEFINED, (Object)prefix), NbBundle.getMessage(ValidateSupport.class, (String)FIX_PREFIX_NOT_DEFINED, (Object)prefix))) {
                return false;
            }
        }
        return true;
    }

    public boolean assertQNameAttrib(String value, String name, Component source, int category, boolean verifyNullPrefix) {
        String prefix;
        String[] parts;
        boolean valid = this.assertQNameAttrib(value, name, source, category);
        return !valid || !verifyNullPrefix || (parts = value.split(":")) == null || parts.length <= 1 || (prefix = parts[0]) != null && !"".equals(prefix.trim()) || this.fireToDo(Validator.ResultType.ERROR, source, NbBundle.getMessage(ValidateSupport.class, (String)VAL_PREFIX_NULL_QNAME_ATTRIB, (Object)name), NbBundle.getMessage(ValidateSupport.class, (String)FIX_PREFIX_NULL_QNAME_ATTRIB, (Object)name));
    }

    public boolean assertBooleanAttrib(String value, String name, Component source, int category) {
        if (source instanceof WSDLComponent && !this.mValConfig.getBooleanProperty("wsdl.syntax.attrib.boolean")) {
            return true;
        }
        if (!(ValidateSupport.isAttributeAbsent(value) || value.equals("yes") || value.equals("no"))) {
            return this.fireToDo(Validator.ResultType.ERROR, source, NbBundle.getMessage(ValidateSupport.class, (String)VAL_NOT_BOOLEAN_ATTRIB, (Object)name), NbBundle.getMessage(ValidateSupport.class, (String)FIX_NOT_BOOLEAN_ATTRIB, (Object)name));
        }
        return true;
    }

    public boolean assertMinimumElem(int num, int min, String name, Component source, int category) {
        if (source instanceof WSDLComponent && !this.mValConfig.getBooleanProperty("wsdl.syntax.elem.min")) {
            return true;
        }
        if (num < min) {
            return this.fireToDo(Validator.ResultType.ERROR, source, NbBundle.getMessage(ValidateSupport.class, (String)VAL_MIN_ELEM_NOT_MET, (Object)min, (Object)name, (Object)num), NbBundle.getMessage(ValidateSupport.class, (String)FIX_MIN_ELEM_NOT_MET, (Object)(min - num), (Object)name));
        }
        return true;
    }

    public boolean assertEnumeratedAttrib(String value, String[] enums, String name, Component source, int category) {
        if (source instanceof WSDLComponent && !this.mValConfig.getBooleanProperty("wsdl.syntax.attrib.enumerated")) {
            return true;
        }
        if (!ValidateSupport.isAttributeAbsent(value) && enums != null && enums.length > 0) {
            boolean found = false;
            for (int i = 0; i < enums.length; ++i) {
                if (!ValidationUtils.areEqualXMLValues(value, enums[i])) continue;
                found = true;
                break;
            }
            if (!found) {
                StringBuffer enumsb = new StringBuffer();
                for (int i = 0; i < enums.length; ++i) {
                    if (i > 0) {
                        enumsb.append(", ");
                    }
                    enumsb.append(enums[i]);
                }
                return this.fireToDo(Validator.ResultType.ERROR, source, NbBundle.getMessage(ValidateSupport.class, (String)VAL_NOT_ENUM_ATTRIB, (Object)name, (Object)enumsb.toString()), NbBundle.getMessage(ValidateSupport.class, (String)FIX_NOT_ENUM_ATTRIB, (Object)enumsb.toString(), (Object)name));
            }
        }
        return true;
    }

    public boolean assertRequiredElement(Component subElem, String name, Component source, int category) {
        if (source instanceof WSDLComponent && !this.mValConfig.getBooleanProperty("wsdl.syntax.elem.required")) {
            return true;
        }
        if (null == subElem) {
            return this.fireToDo(Validator.ResultType.ERROR, source, NbBundle.getMessage(ValidateSupport.class, (String)VAL_MISSING_ELEM, (Object)name), NbBundle.getMessage(ValidateSupport.class, (String)FIX_MISSING_ELEM, (Object)name));
        }
        return true;
    }

    public boolean fireToDo(Validator.ResultType type, Component component, String desc, String correction) {
        String message = desc;
        if (correction != null) {
            message = desc + " : " + correction;
        }
        Validator.ResultItem item = new Validator.ResultItem(this.mValidator, type, component, message);
        this.mResultItems.add(item);
        return true;
    }
}

