/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.validator.visitor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingFault;
import org.netbeans.modules.xml.wsdl.model.BindingInput;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.BindingOutput;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.Documentation;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.Fault;
import org.netbeans.modules.xml.wsdl.model.Import;
import org.netbeans.modules.xml.wsdl.model.Input;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.NotificationOperation;
import org.netbeans.modules.xml.wsdl.model.OneWayOperation;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.Output;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.wsdl.model.Port;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.RequestResponseOperation;
import org.netbeans.modules.xml.wsdl.model.Service;
import org.netbeans.modules.xml.wsdl.model.SolicitResponseOperation;
import org.netbeans.modules.xml.wsdl.model.Types;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.impl.WSDLAttribute;
import org.netbeans.modules.xml.wsdl.model.spi.GenericExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.visitor.WSDLVisitor;
import org.netbeans.modules.xml.wsdl.validator.visitor.ValidateConfiguration;
import org.netbeans.modules.xml.wsdl.validator.visitor.ValidateSupport;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.Reference;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.netbeans.modules.xml.xam.spi.Validation;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.openide.util.NbBundle;

public class WSDLSemanticsVisitor
implements WSDLVisitor {
    private ValidateSupport mValidateSupport = null;
    private static ValidateConfiguration mValConfig;
    public static final String VAL_FAULT_NOT_ALLOWED_IN_OPERATION = "VAL_FAULT_NOT_ALLOWED_IN_OPERATION";
    public static final String FIX_FAULT_NOT_ALLOWED_IN_OPERATION = "FIX_FAULT_NOT_ALLOWED_IN_OPERATION";
    public static final String VAL_MESSAGE_NOT_FOUND_IN_OPERATION_INPUT = "VAL_MESSAGE_NOT_FOUND_IN_OPERATION_INPUT";
    public static final String VAL_MESSAGE_NOT_FOUND_IN_OPERATION_OUTPUT = "VAL_MESSAGE_NOT_FOUND_IN_OPERATION_OUTPUT";
    public static final String VAL_MESSAGE_NOT_FOUND_IN_OPERATION_FAULT = "VAL_MESSAGE_NOT_FOUND_IN_OPERATION_FAULT";
    public static final String FIX_MESSAGE_NOT_FOUND_IN_OPERATION_INPUT = "FIX_MESSAGE_NOT_FOUND_IN_OPERATION_INPUT";
    public static final String FIX_MESSAGE_NOT_FOUND_IN_OPERATION_OUTPUT = "FIX_MESSAGE_NOT_FOUND_IN_OPERATION_OUTPUT";
    public static final String FIX_MESSAGE_NOT_FOUND_IN_OPERATION_FAULT = "FIX_MESSAGE_NOT_FOUND_IN_OPERATION_FAULT";
    public static final String VAL_SCHEMA_DEFINED_NOT_FOUND = "VAL_SCHEMA_DEFINED_NOT_FOUND";
    public static final String FIX_SCHEMA_DEFINED_NOT_FOUND = "FIX_SCHEMA_DEFINED_NOT_FOUND";
    public static final String VAL_NO_SCHEMA_DEFINED = "VAL_NO_SCHEMA_DEFINED";
    public static final String FIX_NO_SCHEMA_DEFINED = "FIX_NO_SCHEMA_DEFINED";
    public static final String VAL_NO_PARTNERLINKTYPE_PORTTYPE_DEFINED_IN_WSDL = "VAL_NO_PARTNERLINKTYPE_PORTTYPE_DEFINED_IN_WSDL";
    public static final String FIX_NO_PARTNERLINKTYPE_PORTTYPE_DEFINED_IN_WSDL = "FIX_NO_PARTNERLINKTYPE_PORTTYPE_DEFINED_IN_WSDL";
    public static final String VAL_WARNING_WSDL_MESSAGE_DOES_NOT_HAVE_ANY_PARTS_DEFINED = "VAL_WARNING_WSDL_MESSAGE_DOES_NOT_HAVE_ANY_PARTS_DEFINED";
    public static final String FIX_WARNING_WSDL_MESSAGE_DOES_NOT_HAVE_ANY_PARTS_DEFINED = "FIX_WARNING_WSDL_MESSAGE_DOES_NOT_HAVE_ANY_PARTS_DEFINED";
    public static final String VAL_NO_ELEMENT_OR_TYPE_ATTRIBUTE_DEFINED_IN_MESSAGE_PART = "VAL_NO_ELEMENT_OR_TYPE_ATTRIBUTE_DEFINED_IN_MESSAGE_PART";
    public static final String FIX_NO_ELEMENT_OR_TYPE_ATTRIBUTE_DEFINED_IN_MESSAGE_PART = "FIX_NO_ELEMENT_OR_TYPE_ATTRIBUTE_DEFINED_IN_MESSAGE_PART";
    public static final String VAL_BOTH_ELEMENT_OR_TYPE_ATTRIBUTE_DEFINED_IN_MESSAGE_PART = "VAL_BOTH_ELEMENT_OR_TYPE_ATTRIBUTE_DEFINED_IN_MESSAGE_PART";
    public static final String FIX_BOTH_ELEMENT_OR_TYPE_ATTRIBUTE_DEFINED_IN_MESSAGE_PART = "FIX_BOTH_ELEMENT_OR_TYPE_ATTRIBUTE_DEFINED_IN_MESSAGE_PART";
    public static final String VAL_ELEMENT_ATTRIBUTE_DEFINED_IN_MESSAGE_PART_IS_NOT_VALID = "VAL_ELEMENT_ATTRIBUTE_DEFINED_IN_MESSAGE_PART_IS_NOT_VALID";
    public static final String FIX_ELEMENT_ATTRIBUTE_DEFINED_IN_MESSAGE_PART_IS_NOT_VALID = "FIX_ELEMENT_ATTRIBUTE_DEFINED_IN_MESSAGE_PART_IS_NOT_VALID";
    public static final String VAL_TYPE_ATTRIBUTE_DEFINED_IN_MESSAGE_PART_IS_NOT_VALID = "VAL_TYPE_ATTRIBUTE_DEFINED_IN_MESSAGE_PART_IS_NOT_VALID";
    public static final String FIX_TYPE_ATTRIBUTE_DEFINED_IN_MESSAGE_PART_IS_NOT_VALID = "FIX_TYPE_ATTRIBUTE_DEFINED_IN_MESSAGE_PART_IS_NOT_VALID";
    public static final String VAL_MISSING_PORTTYPE_IN_BINDING = "VAL_MISSING_PORTTYPE_IN_BINDING";
    public static final String FIX_MISSING_PORTTYPE_IN_BINDING = "FIX_MISSING_PORTTYPE_IN_BINDING";
    public static final String VAL_MISSING_BINDING_IN_SERVICE_PORT = "VAL_MISSING_BINDING_IN_SERVICE_PORT";
    public static final String FIX_MISSING_BINDING_IN_SERVICE_PORT = "FIX_MISSING_BINDING_IN_SERVICE_PORT";
    public static final String VAL_MISSING_IMPORTED_DOCUMENT = "VAL_MISSING_IMPORTED_DOCUMENT";
    public static final String FIX_MISSING_IMPORTED_DOCUMENT = "FIX_MISSING_IMPORTED_DOCUMENT";
    public static final String VAL_DUPLICATE_OPRATION_INPUT_NAME_IN_PORTTYPE = "VAL_DUPLICATE_OPRATION_INPUT_NAME_IN_PORTTYPE";
    public static final String FIX_DUPLICATE_OPRATION_INPUT_NAME_IN_PORTTYPE = "FIX_DUPLICATE_OPRATION_INPUT_NAME_IN_PORTTYPE";
    public static final String VAL_DUPLICATE_OPRATION_OUTPUT_NAME_IN_PORTTYPE = "VAL_DUPLICATE_OPRATION_OUTPUT_NAME_IN_PORTTYPE";
    public static final String FIX_DUPLICATE_OPRATION_OUTPUT_NAME_IN_PORTTYPE = "FIX_DUPLICATE_OPRATION_OUTPUT_NAME_IN_PORTTYPE";
    public static final String VAL_DUPLICATE_OPRATION_FAULT_NAME = "VAL_DUPLICATE_OPRATION_FAULT_NAME";
    public static final String FIX_DUPLICATE_OPRATION_FAULT_NAME = "FIX_DUPLICATE_OPRATION_FAULT_NAME";
    public static final String VAL_OPERATION_DOES_NOT_EXIST_IN_PORT_TYPE = "VAL_OPERATION_DOES_NOT_EXIST_IN_PORT_TYPE";
    public static final String FIX_OPERATION_DOES_NOT_EXIST_IN_PORT_TYPE = "FIX_OPERATION_DOES_NOT_EXIST_IN_PORT_TYPE";
    private static final String VAL_ERROR_WSDL_DEFINITIONS_NO_TARGETNAMESPACE = "VAL_ERROR_WSDL_DEFINITIONS_NO_TARGETNAMESPACE";
    private static final String FIX_ERROR_WSDL_DEFINITIONS_NO_TARGETNAMESPACE = "FIX_ERROR_WSDL_DEFINITIONS_NO_TARGETNAMESPACE";
    private static final String VAL_SCHEMA_TARGETNAMESPACE_DOES_NOT_EXIST = "VAL_SCHEMA_TARGETNAMESPACE_DOES_NOT_EXIST";
    private static final String FIX_SCHEMA_TARGETNAMESPACE_DOES_NOT_EXIST = "FIX_SCHEMA_TARGETNAMESPACE_DOES_NOT_EXIST";
    private static final String VAL_IMPORT_SCHEMA_TARGETNAMESPACE_DOES_NOT_EXIST = "VAL_IMPORT_SCHEMA_TARGETNAMESPACE_DOES_NOT_EXIST";
    private static final String FIX_IMPORT_SCHEMA_TARGETNAMESPACE_DOES_NOT_EXIST = "FIX_IMPORT_SCHEMA_TARGETNAMESPACE_DOES_NOT_EXIST";
    public static final String VAL_OPERATION_DOES_NOT_MATCH_INPUT_IN_PORT_TYPE = "VAL_OPERATION_DOES_NOT_MATCH_INPUT_IN_PORT_TYPE";
    public static final String FIX_OPERATION_DOES_NOT_MATCH_INPUT_IN_PORT_TYPE = "FIX_OPERATION_DOES_NOT_MATCH_INPUT_IN_PORT_TYPE";
    public static final String VAL_OPERATION_DOES_NOT_MATCH_OUTPUT_IN_PORT_TYPE = "VAL_OPERATION_DOES_NOT_MATCH_OUTPUT_IN_PORT_TYPE";
    public static final String FIX_OPERATION_DOES_NOT_MATCH_OUTPUT_IN_PORT_TYPE = "FIX_OPERATION_DOES_NOT_MATCH_OUTPUT_IN_PORT_TYPE";
    public static final String VAL_OPERATION_DOES_NOT_MATCH_INPUT_NAME_IN_PORT_TYPE = "VAL_OPERATION_DOES_NOT_MATCH_INPUT_NAME_IN_PORT_TYPE";
    public static final String FIX_OPERATION_DOES_NOT_MATCH_INPUT_NAME_IN_PORT_TYPE = "FIX_OPERATION_DOES_NOT_MATCH_INPUT_NAME_IN_PORT_TYPE";
    public static final String VAL_OPERATION_DOES_NOT_MATCH_OUTPUT_NAME_IN_PORT_TYPE = "VAL_OPERATION_DOES_NOT_MATCH_OUTPUT_NAME_IN_PORT_TYPE";
    public static final String FIX_OPERATION_DOES_NOT_MATCH_OUTPUT_NAME_IN_PORT_TYPE = "FIX_OPERATION_DOES_NOT_MATCH_OUTPUT_NAME_IN_PORT_TYPE";
    public static final String VAL_OPERATION_DOES_NOT_MATCH_FAULTS_IN_PORT_TYPE = "VAL_OPERATION_DOES_NOT_MATCH_FAULTS_IN_PORT_TYPE";
    public static final String FIX_OPERATION_DOES_NOT_MATCH_FAULTS_IN_PORT_TYPE = "FIX_OPERATION_DOES_NOT_MATCH_FAULTS_IN_PORT_TYPE";
    public static final String VAL_MULTIPLE_TYPES_IN_DEFINITION = "VAL_MULTIPLE_TYPES_IN_DEFINITION";
    public static final String FIX_MULTIPLE_TYPES_IN_DEFINITION = "FIX_MULTIPLE_TYPES_IN_DEFINITION";
    public static final String VAL_PARMETER_ORDER_CHECK_PART_EXISTENCE = "VAL_PARMETER_ORDER_CHECK_PART_EXISTENCE";
    public static final String FIX_PARMETER_ORDER_CHECK_PART_EXISTENCE = "FIX_PARMETER_ORDER_CHECK_PART_EXISTENCE";
    public static final String VAL_PARMETER_ORDER_CHECK_AT_MOST_ONE_OUTPUT_MESSAGE_PART_MISSING = "VAL_PARMETER_ORDER_CHECK_AT_MOST_ONE_OUTPUT_MESSAGE_PART_MISSING";
    public static final String FIX_PARMETER_ORDER_CHECK_AT_MOST_ONE_OUTPUT_MESSAGE_PART_MISSING = "FIX_PARMETER_ORDER_CHECK_AT_MOST_ONE_OUTPUT_MESSAGE_PART_MISSING";
    public List<Validator.ResultItem> mResultItems;
    private Validation mValidation;
    private List<Model> mValidatedModels;
    private Validator mValidator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WSDLSemanticsVisitor(Validator validator, Validation validation, List<Model> validatedModels) {
        Properties defaults = new Properties();
        defaults.setProperty("wsdl.syntax.attrib.required", "true");
        defaults.setProperty("wsdl.syntax.attrib.qname", "true");
        defaults.setProperty("wsdl.syntax.attrib.ncname", "false");
        defaults.setProperty("wsdl.syntax.attrib.boolean", "true");
        defaults.setProperty("wsdl.syntax.elem.min", "true");
        defaults.setProperty("wsdl.syntax.elem.required", "true");
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            mValConfig = new ValidateConfiguration(defaults);
            this.mResultItems = new Vector<Validator.ResultItem>();
        }
        this.mValidator = validator;
        this.mValidation = validation;
        this.mValidatedModels = validatedModels;
        this.getValidateSupport().setValidator(this.mValidator);
        this.getValidateSupport().setResultItems(this.mResultItems);
    }

    public List<Validator.ResultItem> getResultItems() {
        return this.mResultItems;
    }

    public ValidateSupport getValidateSupport() {
        if (null == this.mValidateSupport) {
            this.mValidateSupport = new ValidateSupport(mValConfig);
        }
        return this.mValidateSupport;
    }

    public Validation getValidation() {
        return this.mValidation;
    }

    public void setValidation(Validation validation) {
        this.mValidation = validation;
    }

    @Override
    public void visit(Definitions w) {
        List result;
        if (w.getTargetNamespace() == null || w.getTargetNamespace().trim().length() == 0) {
            this.getValidateSupport().fireToDo(Validator.ResultType.WARNING, (Component)w, NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)VAL_ERROR_WSDL_DEFINITIONS_NO_TARGETNAMESPACE), NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)FIX_ERROR_WSDL_DEFINITIONS_NO_TARGETNAMESPACE));
        }
        if ((result = w.getChildren(Types.class)) != null && result.size() > 1) {
            this.getValidateSupport().fireToDo(Validator.ResultType.ERROR, (Component)w, NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)VAL_MULTIPLE_TYPES_IN_DEFINITION), NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)FIX_MULTIPLE_TYPES_IN_DEFINITION));
        }
        this.visitChildren(w);
    }

    @Override
    public void visit(Message w) {
        if (w.getParts().size() == 0) {
            this.getValidateSupport().fireToDo(Validator.ResultType.WARNING, (Component)w, NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)VAL_WARNING_WSDL_MESSAGE_DOES_NOT_HAVE_ANY_PARTS_DEFINED, (Object)w.getName()), NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)FIX_WARNING_WSDL_MESSAGE_DOES_NOT_HAVE_ANY_PARTS_DEFINED, (Object)w.getName()));
        }
        this.visitChildren(w);
    }

    @Override
    public void visit(Part p) {
        if (p.getElement() == null && p.getType() == null) {
            this.getValidateSupport().fireToDo(Validator.ResultType.ERROR, (Component)p, NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)VAL_NO_ELEMENT_OR_TYPE_ATTRIBUTE_DEFINED_IN_MESSAGE_PART, (Object)p.getName()), NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)FIX_NO_ELEMENT_OR_TYPE_ATTRIBUTE_DEFINED_IN_MESSAGE_PART));
        }
        if (p.getElement() != null && p.getType() != null) {
            this.getValidateSupport().fireToDo(Validator.ResultType.ERROR, (Component)p, NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)VAL_BOTH_ELEMENT_OR_TYPE_ATTRIBUTE_DEFINED_IN_MESSAGE_PART, (Object)p.getName()), NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)FIX_BOTH_ELEMENT_OR_TYPE_ATTRIBUTE_DEFINED_IN_MESSAGE_PART));
        }
        if (p.getElement() != null && p.getElement().get() == null) {
            this.getValidateSupport().fireToDo(Validator.ResultType.ERROR, (Component)p, NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)VAL_ELEMENT_ATTRIBUTE_DEFINED_IN_MESSAGE_PART_IS_NOT_VALID, (Object)p.getName(), (Object)p.getAttribute(new GenericExtensibilityElement.StringAttribute("element"))), NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)FIX_ELEMENT_ATTRIBUTE_DEFINED_IN_MESSAGE_PART_IS_NOT_VALID));
        }
        if (p.getType() != null && p.getType().get() == null) {
            this.getValidateSupport().fireToDo(Validator.ResultType.ERROR, (Component)p, NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)VAL_TYPE_ATTRIBUTE_DEFINED_IN_MESSAGE_PART_IS_NOT_VALID, (Object)p.getName(), (Object)p.getAttribute(new GenericExtensibilityElement.StringAttribute("type"))), NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)FIX_TYPE_ATTRIBUTE_DEFINED_IN_MESSAGE_PART_IS_NOT_VALID));
        }
        this.visitChildren(p);
    }

    @Override
    public void visit(PortType portType) {
        this.validateOverloadedOperations(portType);
        ArrayList<String> inputNames = new ArrayList<String>();
        ArrayList<String> outputNames = new ArrayList<String>();
        Collection<Operation> operations = portType.getOperations();
        for (Operation operation : operations) {
            String outputName;
            Output output;
            String inputName;
            Input input = operation.getInput();
            if (input != null && (inputName = input.getName()) != null) {
                if (!inputNames.contains(inputName)) {
                    inputNames.add(inputName);
                } else {
                    this.getValidateSupport().fireToDo(Validator.ResultType.ERROR, (Component)input, NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)VAL_DUPLICATE_OPRATION_INPUT_NAME_IN_PORTTYPE, (Object)inputName, (Object)portType.getName()), NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)FIX_DUPLICATE_OPRATION_INPUT_NAME_IN_PORTTYPE));
                }
            }
            if ((output = operation.getOutput()) == null || (outputName = output.getName()) == null) continue;
            if (!outputNames.contains(outputName)) {
                outputNames.add(outputName);
                continue;
            }
            this.getValidateSupport().fireToDo(Validator.ResultType.ERROR, (Component)output, NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)VAL_DUPLICATE_OPRATION_OUTPUT_NAME_IN_PORTTYPE, (Object)outputName, (Object)portType.getName()), NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)FIX_DUPLICATE_OPRATION_OUTPUT_NAME_IN_PORTTYPE));
        }
        this.visitChildren(portType);
    }

    private void validateOverloadedOperations(PortType portType) {
        HashSet<String> operationNames = new HashSet<String>();
        for (Operation operation : portType.getOperations()) {
            String opName = operation.getName();
            String inputName = "";
            try {
                inputName = operation.getInput().getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
            String outputName = "";
            try {
                outputName = operation.getOutput().getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
            String opUniqueName = opName + inputName + outputName;
            if (operationNames.contains(opUniqueName)) {
                this.getValidateSupport().fireToDo(Validator.ResultType.ERROR, (Component)operation, NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)"VAL_INVALID_OVERLOADED_OPERATION_IN_PORTTYPE", (Object)operation.getName()), NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)"FIX_INVALID_OVERLOADED_OPERATION_IN_PORTTYPE"));
                continue;
            }
            operationNames.add(opUniqueName);
        }
    }

    @Override
    public void visit(NotificationOperation operation) {
        if (operation.getFaults() != null && operation.getFaults().size() > 0) {
            this.getValidateSupport().fireToDo(Validator.ResultType.WARNING, (Component)operation, NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)VAL_FAULT_NOT_ALLOWED_IN_OPERATION, (Object)operation.getName()), NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)FIX_FAULT_NOT_ALLOWED_IN_OPERATION, (Object)operation.getName()));
        }
        this.visitChildren(operation);
    }

    @Override
    public void visit(RequestResponseOperation operation) {
        if ((operation.getInput() == null || operation.getOutput() == null) && operation.getFaults() != null && operation.getFaults().size() > 0) {
            this.getValidateSupport().fireToDo(Validator.ResultType.WARNING, (Component)operation, NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)VAL_FAULT_NOT_ALLOWED_IN_OPERATION, (Object)operation.getName()), NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)FIX_FAULT_NOT_ALLOWED_IN_OPERATION, (Object)operation.getName()));
        }
        this.validateFaultNames(operation);
        this.validateParameterOrder(operation);
        this.visitChildren(operation);
    }

    @Override
    public void visit(SolicitResponseOperation operation) {
        if ((operation.getInput() == null || operation.getOutput() == null) && operation.getFaults() != null && operation.getFaults().size() > 0) {
            this.getValidateSupport().fireToDo(Validator.ResultType.WARNING, (Component)operation, NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)VAL_FAULT_NOT_ALLOWED_IN_OPERATION, (Object)operation.getName()), NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)FIX_FAULT_NOT_ALLOWED_IN_OPERATION, (Object)operation.getName()));
        }
        this.validateFaultNames(operation);
        this.validateParameterOrder(operation);
        this.visitChildren(operation);
    }

    @Override
    public void visit(OneWayOperation operation) {
        if (operation.getFaults() != null && operation.getFaults().size() > 0) {
            this.getValidateSupport().fireToDo(Validator.ResultType.WARNING, (Component)operation, NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)VAL_FAULT_NOT_ALLOWED_IN_OPERATION, (Object)operation.getName()), NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)FIX_FAULT_NOT_ALLOWED_IN_OPERATION, (Object)operation.getName()));
        }
        this.visitChildren(operation);
    }

    @Override
    public void visit(Input input) {
        String messageName;
        NamedComponentReference<Message> msgRef = input.getMessage();
        Message message = null;
        if (msgRef != null) {
            message = (Message)msgRef.get();
        }
        if ((messageName = input.getAttribute(new GenericExtensibilityElement.StringAttribute("message"))) != null && message == null) {
            Operation operation = (Operation)input.getParent();
            this.getValidateSupport().fireToDo(Validator.ResultType.ERROR, (Component)input, NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)VAL_MESSAGE_NOT_FOUND_IN_OPERATION_INPUT, (Object)messageName, (Object)operation.getName()), NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)FIX_MESSAGE_NOT_FOUND_IN_OPERATION_INPUT, (Object)messageName, (Object)operation.getName()));
        }
        this.visitChildren(input);
    }

    @Override
    public void visit(Output output) {
        String messageName;
        NamedComponentReference<Message> msgRef = output.getMessage();
        Message message = null;
        if (msgRef != null) {
            message = (Message)msgRef.get();
        }
        if ((messageName = output.getAttribute(new GenericExtensibilityElement.StringAttribute("message"))) != null && message == null) {
            Operation operation = (Operation)output.getParent();
            this.getValidateSupport().fireToDo(Validator.ResultType.ERROR, (Component)output, NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)VAL_MESSAGE_NOT_FOUND_IN_OPERATION_OUTPUT, (Object)messageName, (Object)operation.getName()), NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)FIX_MESSAGE_NOT_FOUND_IN_OPERATION_OUTPUT, (Object)messageName, (Object)operation.getName()));
        }
        this.visitChildren(output);
    }

    @Override
    public void visit(Fault fault) {
        String messageName;
        NamedComponentReference<Message> msgRef = fault.getMessage();
        Message message = null;
        if (msgRef != null) {
            message = (Message)msgRef.get();
        }
        if ((messageName = fault.getAttribute(new GenericExtensibilityElement.StringAttribute("message"))) != null && message == null) {
            Operation operation = (Operation)fault.getParent();
            this.getValidateSupport().fireToDo(Validator.ResultType.ERROR, (Component)fault, NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)VAL_MESSAGE_NOT_FOUND_IN_OPERATION_FAULT, (Object)messageName, (Object)fault.getName(), (Object)operation.getName()), NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)FIX_MESSAGE_NOT_FOUND_IN_OPERATION_FAULT, (Object)fault.getName(), (Object)operation.getName()));
        }
        this.visitChildren(fault);
    }

    @Override
    public void visit(Service service) {
        this.visitChildren(service);
    }

    @Override
    public void visit(Port port) {
        NamedComponentReference<Binding> bindingRef = port.getBinding();
        Binding binding = null;
        if (bindingRef != null) {
            binding = (Binding)bindingRef.get();
        }
        if (binding == null) {
            this.getValidateSupport().fireToDo(Validator.ResultType.ERROR, (Component)port, NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)VAL_MISSING_BINDING_IN_SERVICE_PORT, (Object)port.getName(), (Object)port.getAttribute(new GenericExtensibilityElement.StringAttribute("binding"))), NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)FIX_MISSING_BINDING_IN_SERVICE_PORT));
        }
        this.visitChildren(port);
    }

    @Override
    public void visit(Import wsdlImport) {
        List<Schema> xsdImports;
        List<WSDLModel> importedDocuments = wsdlImport.getModel().findWSDLModel(wsdlImport.getNamespace());
        if (!(importedDocuments != null && !importedDocuments.isEmpty() || (xsdImports = wsdlImport.getModel().findSchemas(wsdlImport.getNamespace())) != null && xsdImports.size() != 0)) {
            this.getValidateSupport().fireToDo(Validator.ResultType.ERROR, (Component)wsdlImport, NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)VAL_MISSING_IMPORTED_DOCUMENT, (Object)wsdlImport.getNamespace(), (Object)wsdlImport.getLocation()), NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)FIX_MISSING_IMPORTED_DOCUMENT));
        }
        this.visitChildren(wsdlImport);
        for (WSDLModel imp : importedDocuments) {
            this.mValidation.validate((Model)imp, Validation.ValidationType.COMPLETE);
        }
    }

    @Override
    public void visit(Binding binding) {
        String type;
        NamedComponentReference<PortType> ptRef = binding.getType();
        PortType portType = null;
        if (ptRef != null) {
            portType = (PortType)ptRef.get();
        }
        if ((type = binding.getAttribute(new GenericExtensibilityElement.StringAttribute("type"))) != null && portType == null) {
            this.getValidateSupport().fireToDo(Validator.ResultType.ERROR, (Component)binding, NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)VAL_MISSING_PORTTYPE_IN_BINDING, (Object)binding.getName(), (Object)type), NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)FIX_MISSING_PORTTYPE_IN_BINDING));
        }
        this.visitChildren(binding);
    }

    @Override
    public void visit(BindingOperation bindingOp) {
        Binding binding = (Binding)bindingOp.getParent();
        NamedComponentReference<PortType> ptRef = binding.getType();
        PortType portType = null;
        if (ptRef != null) {
            portType = (PortType)ptRef.get();
        }
        String portTypeName = null;
        if (portType != null) {
            portTypeName = portType.getName();
        }
        String bindingName = binding.getName();
        String operationName = bindingOp.getName();
        HashSet usedOperations = new HashSet();
        if (portType != null && operationName != null) {
            Collection<Operation> operations = portType.getOperations();
            Reference<Operation> matchingOpRef = bindingOp.getOperation();
            Operation matchingOp = null;
            if (matchingOpRef != null) {
                matchingOp = (Operation)matchingOpRef.get();
            }
            if (matchingOp == null) {
                this.getValidateSupport().fireToDo(Validator.ResultType.ERROR, (Component)bindingOp, NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)VAL_OPERATION_DOES_NOT_EXIST_IN_PORT_TYPE, (Object)operationName, (Object)binding.getName(), (Object)portType.getName()), NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)FIX_OPERATION_DOES_NOT_EXIST_IN_PORT_TYPE, (Object)portType.getName()));
            } else if (usedOperations.contains(matchingOp)) {
                this.getValidateSupport().fireToDo(Validator.ResultType.ERROR, (Component)bindingOp, NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)"VAL_BINDINGOP_IMPLEMENTS_SAME_OPERATION_IN_PORT_TYPE", (Object)operationName, (Object)binding.getName(), (Object)portType.getName()), NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)"FIX_BINDINGOP_IMPLEMENTS_SAME_OPERATION_IN_PORT_TYPE", (Object)portType.getName()));
            } else {
                BindingInput bindingInput = bindingOp.getBindingInput();
                boolean bindingOpHasInput = bindingInput != null;
                Input portTypeInput = matchingOp.getInput();
                boolean portTypeOpHasInput = portTypeInput != null;
                BindingOutput bindingOutput = bindingOp.getBindingOutput();
                boolean bindingOpHasOutput = bindingOutput != null;
                Output portTypeOutput = matchingOp.getOutput();
                boolean portTypeOpHasOutput = portTypeOutput != null;
                Collection<BindingFault> bindingFaults = bindingOp.getBindingFaults();
                Collection<Fault> matchingFaults = matchingOp.getFaults();
                if (bindingOpHasInput != portTypeOpHasInput) {
                    this.getValidateSupport().fireToDo(Validator.ResultType.ERROR, (Component)bindingOp, NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)VAL_OPERATION_DOES_NOT_MATCH_INPUT_IN_PORT_TYPE, (Object)operationName, (Object)bindingName, (Object)portTypeName), NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)FIX_OPERATION_DOES_NOT_MATCH_INPUT_IN_PORT_TYPE, (Object)operationName));
                } else if (bindingOpHasInput && !this.inputNamesMatch(bindingInput, portTypeInput, operationName)) {
                    this.getValidateSupport().fireToDo(Validator.ResultType.WARNING, (Component)bindingInput, NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)VAL_OPERATION_DOES_NOT_MATCH_INPUT_NAME_IN_PORT_TYPE, (Object)operationName, (Object)bindingName, (Object)portTypeName), NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)FIX_OPERATION_DOES_NOT_MATCH_INPUT_NAME_IN_PORT_TYPE, (Object)operationName));
                }
                if (bindingOpHasOutput != portTypeOpHasOutput) {
                    this.getValidateSupport().fireToDo(Validator.ResultType.ERROR, (Component)bindingOp, NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)VAL_OPERATION_DOES_NOT_MATCH_OUTPUT_IN_PORT_TYPE, (Object)operationName, (Object)bindingName, (Object)portTypeName), NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)FIX_OPERATION_DOES_NOT_MATCH_OUTPUT_IN_PORT_TYPE, (Object)operationName));
                } else if (bindingOpHasOutput && !this.outputNamesMatch(bindingOutput, portTypeOutput, operationName)) {
                    this.getValidateSupport().fireToDo(Validator.ResultType.WARNING, (Component)bindingOutput, NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)VAL_OPERATION_DOES_NOT_MATCH_OUTPUT_NAME_IN_PORT_TYPE, (Object)operationName, (Object)bindingName, (Object)portTypeName), NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)FIX_OPERATION_DOES_NOT_MATCH_OUTPUT_NAME_IN_PORT_TYPE, (Object)operationName));
                }
                if (!this.faultsMatch(bindingFaults, matchingFaults)) {
                    this.getValidateSupport().fireToDo(Validator.ResultType.ERROR, (Component)bindingOp, NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)VAL_OPERATION_DOES_NOT_MATCH_FAULTS_IN_PORT_TYPE, (Object)operationName, (Object)bindingName, (Object)portTypeName), NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)FIX_OPERATION_DOES_NOT_MATCH_FAULTS_IN_PORT_TYPE, (Object)operationName));
                }
            }
        }
        this.visitChildren(bindingOp);
    }

    private boolean inputNamesMatch(BindingInput bindingInput, Input portTypeInput, String operationName) {
        String bindingInputName = bindingInput.getAttribute(WSDLAttribute.NAME);
        String portTypeInputName = portTypeInput.getAttribute(WSDLAttribute.NAME);
        if (bindingInputName != null) {
            return bindingInputName.equals(portTypeInputName);
        }
        return portTypeInputName == null;
    }

    private boolean outputNamesMatch(BindingOutput bindingOutput, Output portTypeOutput, String operationName) {
        String bindingOutputName = bindingOutput.getName();
        String portTypeOutputName = portTypeOutput.getAttribute(WSDLAttribute.NAME);
        if (bindingOutputName != null) {
            return bindingOutputName.equals(portTypeOutput.getName());
        }
        return portTypeOutputName == null;
    }

    private boolean faultsMatch(Collection<BindingFault> bindingFaults, Collection<Fault> portTypeFaults) {
        if (bindingFaults.size() != portTypeFaults.size()) {
            return false;
        }
        if (portTypeFaults.size() == 0) {
            return true;
        }
        HashSet<String> portTypeFaultNames = new HashSet<String>();
        for (Fault portTypeFault : portTypeFaults) {
            portTypeFaultNames.add(portTypeFault.getName());
        }
        for (BindingFault bindingFault : bindingFaults) {
            if (portTypeFaultNames.contains(bindingFault.getName())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void visit(BindingInput bindingIn) {
        this.visitChildren(bindingIn);
    }

    @Override
    public void visit(BindingOutput bindingOut) {
        this.visitChildren(bindingOut);
    }

    @Override
    public void visit(BindingFault bindingFault) {
        this.visitChildren(bindingFault);
    }

    @Override
    public void visit(Documentation doc) {
    }

    @Override
    public void visit(Types types) {
        this.visitChildren(types);
    }

    @Override
    public void visit(ExtensibilityElement ext) {
    }

    private void visitChildren(WSDLComponent w) {
        List coll = w.getChildren();
        if (coll != null) {
            for (WSDLComponent component : coll) {
                component.accept(this);
            }
        }
    }

    private void validateFaultNames(Operation operation) {
        ArrayList<String> faultNames = new ArrayList<String>();
        Collection<Fault> faults = operation.getFaults();
        for (Fault fault : faults) {
            String faultName = fault.getName();
            if (faultName == null) continue;
            if (!faultNames.contains(faultName)) {
                faultNames.add(faultName);
                continue;
            }
            this.getValidateSupport().fireToDo(Validator.ResultType.ERROR, (Component)operation, NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)VAL_DUPLICATE_OPRATION_FAULT_NAME, (Object)faultName, (Object)operation.getName()), NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)FIX_DUPLICATE_OPRATION_FAULT_NAME));
        }
    }

    private void validateParameterOrder(Operation operation) {
        List<String> parts = operation.getParameterOrder();
        if (parts != null) {
            for (String partName : parts) {
                this.validateParameterOrderPart(operation, partName);
            }
        }
        this.validateParameterOrderInOutput(operation);
    }

    private void validateParameterOrderPart(Operation operation, String partName) {
        Input input = operation.getInput();
        Output output = operation.getOutput();
        if (input != null && output != null) {
            Message outMessage;
            Message inMessage;
            Collection<Part> parts;
            Part part;
            boolean foundPart = false;
            NamedComponentReference<Message> inputMessage = input.getMessage();
            NamedComponentReference<Message> outputMessage = output.getMessage();
            if (inputMessage != null && inputMessage.get() != null && (part = this.findMatchingPart(parts = (inMessage = (Message)inputMessage.get()).getParts(), partName)) != null) {
                foundPart = true;
            }
            if (!foundPart && outputMessage != null && outputMessage.get() != null && (part = this.findMatchingPart(parts = (outMessage = (Message)outputMessage.get()).getParts(), partName)) != null) {
                foundPart = true;
            }
            if (!foundPart) {
                this.getValidateSupport().fireToDo(Validator.ResultType.ERROR, (Component)operation, NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)VAL_PARMETER_ORDER_CHECK_PART_EXISTENCE, (Object)partName, (Object)operation.getName()), NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)FIX_PARMETER_ORDER_CHECK_PART_EXISTENCE));
            }
        }
    }

    private void validateParameterOrderInOutput(Operation operation) {
        NamedComponentReference<Message> outputMessage;
        Output output = operation.getOutput();
        if (output != null && (outputMessage = output.getMessage()) != null && outputMessage.get() != null) {
            Message outMessage = (Message)outputMessage.get();
            Collection<Part> outputParts = outMessage.getParts();
            List<String> parts = operation.getParameterOrder();
            if (outputParts != null && parts != null) {
                int matchedOutputPartsCount = 0;
                for (Part p : outputParts) {
                    boolean result;
                    if (p.getName() == null || !(result = parts.contains(p.getName()))) continue;
                    ++matchedOutputPartsCount;
                }
                if (matchedOutputPartsCount < outputParts.size() - 1) {
                    this.getValidateSupport().fireToDo(Validator.ResultType.ERROR, (Component)operation, NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)VAL_PARMETER_ORDER_CHECK_AT_MOST_ONE_OUTPUT_MESSAGE_PART_MISSING, (Object)operation.getName()), NbBundle.getMessage(WSDLSemanticsVisitor.class, (String)FIX_PARMETER_ORDER_CHECK_AT_MOST_ONE_OUTPUT_MESSAGE_PART_MISSING));
                }
            }
        }
    }

    private Part findMatchingPart(Collection<Part> parts, String partName) {
        Part part = null;
        if (partName != null && parts != null) {
            for (Part p : parts) {
                if (!partName.equals(p.getName())) continue;
                part = p;
                break;
            }
        }
        return part;
    }
}

