/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.syntax;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.modules.xml.text.api.XMLDefaultTokenContext;
import org.netbeans.modules.xml.text.syntax.SyntaxElement;
import org.netbeans.modules.xml.text.syntax.XMLTokenIDs;
import org.netbeans.modules.xml.text.syntax.dom.CDATASectionImpl;
import org.netbeans.modules.xml.text.syntax.dom.CommentImpl;
import org.netbeans.modules.xml.text.syntax.dom.DocumentTypeImpl;
import org.netbeans.modules.xml.text.syntax.dom.EmptyTag;
import org.netbeans.modules.xml.text.syntax.dom.EndTag;
import org.netbeans.modules.xml.text.syntax.dom.ProcessingInstructionImpl;
import org.netbeans.modules.xml.text.syntax.dom.StartTag;
import org.netbeans.modules.xml.text.syntax.dom.Tag;
import org.netbeans.modules.xml.text.syntax.dom.TextImpl;
import org.openide.ErrorManager;
import org.openide.util.WeakListeners;

public final class XMLSyntaxSupport
extends ExtSyntaxSupport
implements XMLTokenIDs {
    private String systemId = null;
    private String publicId = null;
    private volatile boolean requestedAutoCompletion = false;
    private char lastInsertedChar = (char)88;
    private final DocumentMonitor documentMonitor = new DocumentMonitor();
    private static final String CDATA_START = "<![CDATA[";
    private static final String CDATA_END = "]]>";

    public XMLSyntaxSupport(BaseDocument doc) {
        super(doc);
        DocumentListener l = WeakListeners.document((DocumentListener)this.documentMonitor, (Object)doc);
        doc.addDocumentListener(l);
    }

    public TokenItem getPreviousToken(int offset) throws BadLocationException {
        if (offset == 0) {
            return null;
        }
        if (offset < 0) {
            throw new BadLocationException("Offset " + offset + " cannot be less than 0.", offset);
        }
        TokenItem item = null;
        int step = 11;
        int len = this.getDocument().getLength();
        if (offset > len) {
            throw new BadLocationException("Offset " + offset + " cannot be higher that document length " + len + " .", offset);
        }
        int from = Math.min(len, offset);
        int to = Math.min(len, offset);
        while (item == null) {
            if ((from = Math.max(from - step, 0)) == 0) {
                to = Math.min(to + step, len);
            }
            item = this.getTokenChain(from, to);
            if (from != 0 || to != len || item != null) continue;
            throw new IllegalStateException("Token at " + offset + " cannot be located!\nInspected range:[" + from + ", " + to + "].");
        }
        while (item.getOffset() + item.getImage().length() < offset) {
            TokenItem next = item.getNext();
            if (next == null) {
                if (item.getOffset() + item.getImage().length() >= len) {
                    return item;
                }
                throw new IllegalStateException("Token at " + offset + " cannot be located!\nPrevious token: " + item);
            }
            item = next;
        }
        return item;
    }

    public SyntaxElement getElementChain(int offset) throws BadLocationException {
        TokenItem item = this.getPreviousToken(offset);
        if (item == null) {
            return null;
        }
        TokenID id = item.getTokenID();
        TokenItem first = item;
        if (id == CHARACTER) {
            while (id == CHARACTER && (item = item.getPrevious()) != null) {
                id = item.getTokenID();
                first = item;
            }
            if (id == XMLDefaultTokenContext.TAG && item.getImage().endsWith(">")) {
                return this.createElement(item.getNext());
            }
            if (id != VALUE && id != TEXT && id != CDATA_SECTION) {
                if (id == XMLDefaultTokenContext.TAG) {
                    if (item.getImage().startsWith("<")) {
                        return this.createElement(item);
                    }
                    while ((id = (item = item.getPrevious()).getTokenID()) != XMLDefaultTokenContext.TAG) {
                    }
                    return this.createElement(item);
                }
                return this.createElement(first);
            }
        }
        if (id == XMLDefaultTokenContext.WS || id == XMLDefaultTokenContext.ARGUMENT || id == XMLDefaultTokenContext.OPERATOR || id == XMLDefaultTokenContext.VALUE) {
            while (!((id = (item = item.getPrevious()).getTokenID()) == XMLDefaultTokenContext.TAG || id == XMLDefaultTokenContext.DECLARATION && item.getImage().trim().length() > 0 || this.isInPI(id, false))) {
            }
        }
        if (id == TEXT) {
            while (id == TEXT || id == CHARACTER) {
                first = item;
                if ((item = item.getPrevious()) == null) break;
                id = item.getTokenID();
            }
            return this.createElement(first);
        }
        if (id == CDATA_SECTION) {
            return this.createElement(item);
        }
        if (id == XMLDefaultTokenContext.TAG) {
            if (item.getImage().startsWith("<")) {
                return this.createElement(item);
            }
            while ((id = (item = item.getPrevious()).getTokenID()) != XMLDefaultTokenContext.TAG) {
            }
            return this.createElement(item);
        }
        if (id == XMLDefaultTokenContext.ERROR) {
            return new SyntaxElement.Error(this, item, XMLSyntaxSupport.getTokenEnd(item));
        }
        if (id == XMLDefaultTokenContext.BLOCK_COMMENT) {
            while (id == XMLDefaultTokenContext.BLOCK_COMMENT && !item.getImage().startsWith("<!--")) {
                first = item;
                item = item.getPrevious();
                id = item.getTokenID();
            }
            return this.createElement(first);
        }
        if (id == XMLDefaultTokenContext.DECLARATION) {
            while (true) {
                first = item;
                if (id == XMLDefaultTokenContext.DECLARATION && item.getImage().startsWith("<!") || (item = item.getPrevious()) == null) break;
                id = item.getTokenID();
            }
            return this.createElement(first);
        }
        if (this.isInPI(id, false)) {
            while ((id = (item = item.getPrevious()).getTokenID()) != XMLDefaultTokenContext.PI_START) {
            }
        }
        if (id == XMLDefaultTokenContext.PI_START) {
            return this.createElement(item);
        }
        return null;
    }

    private boolean isInPI(TokenID id, boolean includeWS) {
        return id == XMLDefaultTokenContext.PI_TARGET || id == XMLDefaultTokenContext.PI_CONTENT || id == XMLDefaultTokenContext.PI_END || includeWS && id == XMLDefaultTokenContext.WS;
    }

    public SyntaxElement createElement(TokenItem item) throws BadLocationException {
        if (item == null) {
            return null;
        }
        TokenID id = item.getTokenID();
        TokenItem first = item;
        int lastOffset = XMLSyntaxSupport.getTokenEnd(item);
        switch (id.getNumericID()) {
            case 8: {
                while (id == XMLDefaultTokenContext.BLOCK_COMMENT) {
                    lastOffset = XMLSyntaxSupport.getTokenEnd(item);
                    if ((item = item.getNext()) == null) break;
                    id = item.getTokenID();
                }
                return new CommentImpl(this, first, lastOffset);
            }
            case 10: {
                boolean seekforDTDEnd = false;
                while (id == XMLDefaultTokenContext.DECLARATION || id == XMLDefaultTokenContext.VALUE || seekforDTDEnd) {
                    lastOffset = XMLSyntaxSupport.getTokenEnd(item);
                    if (seekforDTDEnd) {
                        if (item.getImage().endsWith("]>")) {
                            break;
                        }
                    } else if (id == DECLARATION) {
                        seekforDTDEnd = item.getImage().endsWith("[");
                    }
                    if ((item = item.getNext()) == null) break;
                    id = item.getTokenID();
                }
                return new DocumentTypeImpl(this, first, lastOffset);
            }
            case 3: {
                return new SyntaxElement.Error(this, first, lastOffset);
            }
            case 1: 
            case 11: {
                while (id == TEXT || id == CHARACTER || id == CDATA_SECTION) {
                    lastOffset = XMLSyntaxSupport.getTokenEnd(item);
                    if ((item = item.getNext()) == null) break;
                    id = item.getTokenID();
                }
                return new TextImpl(this, first, lastOffset);
            }
            case 17: {
                return new CDATASectionImpl(this, first, first.getOffset() + first.getImage().length());
            }
            case 4: {
                String text = item.getImage();
                if (text.startsWith("</")) {
                    String name = text.substring(2);
                    TokenID tokenID = id = (item = item.getNext()) == null ? null : item.getTokenID();
                    while (id == XMLDefaultTokenContext.WS) {
                        lastOffset = XMLSyntaxSupport.getTokenEnd(item);
                        id = (item = item.getNext()) == null ? null : item.getTokenID();
                    }
                    if (id == XMLDefaultTokenContext.TAG && item.getImage().equals(">")) {
                        return new EndTag(this, first, XMLSyntaxSupport.getTokenEnd(item), name);
                    }
                    return new EndTag(this, first, lastOffset, name);
                }
                String name = text.substring(1);
                ArrayList<String> attrs = new ArrayList<String>();
                TokenID tokenID = id = (item = item.getNext()) == null ? null : item.getTokenID();
                while (id == XMLDefaultTokenContext.WS || id == XMLDefaultTokenContext.ARGUMENT || id == XMLDefaultTokenContext.OPERATOR || id == XMLDefaultTokenContext.VALUE || id == XMLDefaultTokenContext.CHARACTER) {
                    if (id == XMLDefaultTokenContext.ARGUMENT) {
                        attrs.add(item.getImage());
                    }
                    lastOffset = XMLSyntaxSupport.getTokenEnd(item);
                    if ((item = item.getNext()) == null) break;
                    id = item.getTokenID();
                }
                if (id == XMLDefaultTokenContext.TAG && (item.getImage().equals("/>") || item.getImage().equals(">") || item.getImage().equals("?>"))) {
                    if (item.getImage().equals("/>")) {
                        return new EmptyTag(this, first, XMLSyntaxSupport.getTokenEnd(item), name, attrs);
                    }
                    if (item.getImage().equals("?>")) {
                        return new EmptyTag(this, first, XMLSyntaxSupport.getTokenEnd(item), name, attrs);
                    }
                    return new StartTag(this, first, XMLSyntaxSupport.getTokenEnd(item), name, attrs);
                }
                return new StartTag(this, first, lastOffset, name, attrs);
            }
            case 13: {
                do {
                    lastOffset = XMLSyntaxSupport.getTokenEnd(item);
                } while ((item = item.getNext()) != null && this.isInPI(id = item.getTokenID(), true));
                return new ProcessingInstructionImpl(this, first, lastOffset);
            }
        }
        throw new BadLocationException("Cannot create SyntaxElement at " + item, item.getOffset());
    }

    public String getEndTag(int offset) throws BadLocationException {
        SyntaxElement elem = this.getElementChain(offset);
        if (elem != null) {
            elem = elem.getPrevious();
        } else if (offset > 0) {
            elem = this.getElementChain(offset - 1);
        } else {
            return "";
        }
        int counter = 0;
        while (elem != null) {
            block9: {
                block11: {
                    block10: {
                        if (elem instanceof EmptyTag) break block9;
                        if (!(elem instanceof StartTag)) break block10;
                        ++counter;
                        break block11;
                    }
                    if (!(elem instanceof EndTag)) break block9;
                    --counter;
                }
                if (counter == 1) {
                    String name = ((StartTag)elem).getTagName();
                    return name;
                }
            }
            elem = elem.getPrevious();
        }
        return "";
    }

    public List<String> getPreviousLevelTags(int offset) throws BadLocationException {
        ArrayList<String> result = new ArrayList<String>();
        Stack<String> stack = new Stack<String>();
        Vector<String> children = new Vector<String>();
        SyntaxElement elem = this.getElementChain(offset);
        if (elem != null) {
            elem = elem.getPrevious();
        } else if (offset > 0) {
            elem = this.getElementChain(offset - 1);
        } else {
            return result;
        }
        while (elem != null) {
            if (elem instanceof EndTag) {
                stack.push(((EndTag)elem).getTagName());
            } else if (elem instanceof EmptyTag) {
                if (stack.size() == 0) {
                    children.add(((EmptyTag)elem).getTagName());
                }
            } else if (elem instanceof Tag) {
                String name = ((Tag)elem).getTagName();
                if (stack.empty()) {
                    result.add(name);
                    for (int k = children.size(); k > 0; --k) {
                        result.add((String)children.get(k - 1));
                    }
                    return result;
                }
                if (((String)stack.peek()).equals(name)) {
                    if (stack.size() == 1) {
                        children.add(name);
                    }
                    stack.pop();
                }
            }
            elem = elem.getPrevious();
        }
        result.clear();
        return result;
    }

    public List<String> getFollowingLevelTags(int offset) throws BadLocationException {
        Stack<String> stack = new Stack<String>();
        Vector<String> children = new Vector<String>();
        SyntaxElement elem = this.getElementChain(offset);
        if (elem != null) {
            elem = elem.getNext();
        } else if (offset > 0) {
            elem = this.getElementChain(offset - 1);
        } else {
            return new ArrayList<String>();
        }
        while (elem != null) {
            if (elem instanceof EmptyTag) {
                if (stack.size() == 0) {
                    children.add(((EmptyTag)elem).getTagName());
                }
            } else if (elem instanceof Tag) {
                stack.push(((Tag)elem).getTagName());
            } else if (elem instanceof EndTag) {
                String name = ((EndTag)elem).getTagName();
                if (stack.empty()) {
                    return children;
                }
                if (((String)stack.peek()).equals(name)) {
                    if (stack.size() == 1) {
                        children.add(name);
                    }
                    stack.pop();
                }
            }
            elem = elem.getNext();
        }
        children.clear();
        return children;
    }

    public int checkCompletion(JTextComponent target, String typedText, boolean visible) {
        this.requestedAutoCompletion = false;
        if (!visible) {
            int retVal = 1;
            switch (typedText.charAt(typedText.length() - 1)) {
                case '/': {
                    int dotPos = target.getCaret().getDot();
                    BaseDocument doc = (BaseDocument)target.getDocument();
                    if (dotPos < 2) break;
                    try {
                        String txtBeforeSpace = doc.getText(dotPos - 2, 2);
                        if (!txtBeforeSpace.equals("</")) break;
                        retVal = 0;
                    }
                    catch (BadLocationException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                    break;
                }
                case '\"': 
                case '&': 
                case '\'': 
                case '<': {
                    retVal = 0;
                    break;
                }
                case '>': {
                    int dotPos = target.getCaret().getDot();
                    try {
                        SyntaxElement sel = this.getElementChain(dotPos);
                        if (!(sel instanceof StartTag)) break;
                        retVal = 0;
                        break;
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
            if (this.noCompletion(target)) {
                return 4;
            }
            if (retVal == 0) {
                this.requestedAutoCompletion = true;
            }
            return retVal;
        }
        switch (typedText.charAt(0)) {
            case ';': 
            case '>': {
                return 4;
            }
        }
        return 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean noCompletion(JTextComponent target) {
        if (target == null || target.getCaret() == null) {
            return false;
        }
        int offset = target.getCaret().getDot();
        if (offset < 0) {
            return false;
        }
        BaseDocument document = (BaseDocument)target.getDocument();
        document.readLock();
        try {
            TokenHierarchy th = TokenHierarchy.get((Document)document);
            TokenSequence ts = th.tokenSequence();
            if (ts == null) {
                boolean bl = false;
                return bl;
            }
            ts.move(offset);
            Token token = ts.token();
            if (token == null) {
                ts.moveNext();
                token = ts.token();
                if (token == null) {
                    boolean bl = false;
                    return bl;
                }
            }
            if (token.id() == XMLTokenId.CDATA_SECTION || token.id() == XMLTokenId.BLOCK_COMMENT || token.id() == XMLTokenId.PI_START || token.id() == XMLTokenId.PI_END || token.id() == XMLTokenId.PI_CONTENT || token.id() == XMLTokenId.PI_TARGET) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            document.readUnlock();
        }
        return false;
    }

    public boolean requestedAutoCompletion() {
        return this.requestedAutoCompletion;
    }

    static int getTokenEnd(TokenItem item) {
        return item.getOffset() + item.getImage().length();
    }

    public final char lastTypedChar() {
        return this.lastInsertedChar;
    }

    public int[] findMatchingBlock(int offset, boolean simpleSearch) throws BadLocationException {
        return null;
    }

    public int[] findMatch(int offset, boolean simpleSearch) throws BadLocationException {
        block46: {
            String tokenImage;
            TokenItem toki;
            TokenItem token;
            TokenItem tokenOnOffset = token = this.getTokenChain(offset, offset + 1);
            if (token != null && token.getTokenID() == XMLTokenIDs.TAG && token.getImage().endsWith(">")) {
                token = token.getPrevious();
            }
            if (tokenOnOffset == null) {
                return null;
            }
            if (tokenOnOffset.getTokenID() == XMLTokenIDs.DECLARATION) {
                TokenItem toki2;
                String tokenImage2 = tokenOnOffset.getImage();
                if (tokenImage2.startsWith("<!")) {
                    toki2 = tokenOnOffset;
                    while ((toki2 = toki2.getNext()) != null && toki2.getTokenID() != XMLTokenIDs.DECLARATION) {
                    }
                    if (toki2 != null && toki2.getTokenID() == XMLTokenIDs.DECLARATION && toki2.getImage().endsWith(">")) {
                        int start = toki2.getOffset();
                        int end = toki2.getOffset() + toki2.getImage().length();
                        return new int[]{start, end};
                    }
                }
                if (tokenImage2.endsWith(">") && offset >= tokenOnOffset.getOffset() + tokenOnOffset.getImage().length() - ">".length()) {
                    toki2 = tokenOnOffset;
                    while ((toki2 = toki2.getPrevious()) != null && toki2.getTokenID() != XMLTokenIDs.DECLARATION) {
                    }
                    if (toki2 != null && toki2.getTokenID() == XMLTokenIDs.DECLARATION && toki2.getImage().startsWith("<!")) {
                        int start = toki2.getOffset();
                        int end = toki2.getOffset() + "<!".length();
                        return new int[]{start, end};
                    }
                }
                return null;
            }
            if (tokenOnOffset.getTokenID() == XMLTokenIDs.PI_START || tokenOnOffset.getTokenID() == XMLTokenIDs.PI_TARGET) {
                toki = tokenOnOffset;
                while ((toki = toki.getNext()) != null && toki.getTokenID() != XMLTokenIDs.PI_END) {
                }
                if (toki != null && toki.getTokenID() == XMLTokenIDs.PI_END) {
                    int start = toki.getOffset();
                    int end = toki.getOffset() + toki.getImage().length();
                    return new int[]{start, end};
                }
            } else if (tokenOnOffset.getTokenID() == XMLTokenIDs.PI_END) {
                toki = tokenOnOffset;
                while ((toki = toki.getPrevious()) != null && toki.getTokenID() != XMLTokenIDs.PI_START) {
                }
                if (toki != null && toki.getTokenID() == XMLTokenIDs.PI_START) {
                    int start = toki.getOffset();
                    int end = toki.getOffset() + toki.getImage().length() + toki.getNext().getImage().length();
                    return new int[]{start, end};
                }
            }
            if (tokenOnOffset.getTokenID() == XMLTokenIDs.CDATA_SECTION) {
                tokenImage = tokenOnOffset.getImage();
                TokenItem toki3 = tokenOnOffset;
                if (tokenImage.startsWith(CDATA_START) && offset < tokenOnOffset.getOffset() + CDATA_START.length()) {
                    int start = toki3.getOffset() + toki3.getImage().length() - CDATA_END.length();
                    int end = toki3.getOffset() + toki3.getImage().length();
                    return new int[]{start, end};
                }
                if (tokenImage.endsWith(CDATA_END) && offset >= tokenOnOffset.getOffset() + tokenOnOffset.getImage().length() - CDATA_END.length()) {
                    int start = toki3.getOffset();
                    int end = toki3.getOffset() + CDATA_START.length();
                    return new int[]{start, end};
                }
                return null;
            }
            if (tokenOnOffset.getTokenID() == XMLTokenIDs.BLOCK_COMMENT) {
                TokenItem toki4;
                tokenImage = tokenOnOffset.getImage();
                if (tokenImage.startsWith("<!--") && offset < tokenOnOffset.getOffset() + "<!--".length()) {
                    for (toki4 = tokenOnOffset; toki4 != null && toki4.getTokenID() == XMLTokenIDs.BLOCK_COMMENT; toki4 = toki4.getNext()) {
                        if (!toki4.getImage().endsWith("-->")) continue;
                        int start = toki4.getOffset() + toki4.getImage().length() - "-->".length();
                        int end = toki4.getOffset() + toki4.getImage().length();
                        return new int[]{start, end};
                    }
                }
                if (tokenImage.endsWith("-->") && offset >= tokenOnOffset.getOffset() + tokenOnOffset.getImage().length() - "-->".length()) {
                    while (toki4 != null && toki4.getTokenID() == XMLTokenIDs.BLOCK_COMMENT) {
                        if (toki4.getImage().startsWith("<!--")) {
                            int start = toki4.getOffset();
                            int end = toki4.getOffset() + "<!--".length();
                            return new int[]{start, end};
                        }
                        toki4 = toki4.getPrevious();
                    }
                }
                return null;
            }
            boolean isInside = false;
            if (token != null) {
                if (token.getImage().startsWith("<")) {
                    isInside = true;
                } else {
                    while (token != null && token.getTokenID() != XMLTokenIDs.TAG && !token.getImage().startsWith("<")) {
                        token = token.getPrevious();
                    }
                    if (token != null && token.getTokenID() == XMLTokenIDs.TAG && token.getImage().startsWith("<")) {
                        isInside = true;
                    }
                }
            }
            if (token == null || !isInside) break block46;
            int poss = -1;
            if (token.getTokenID() == XMLTokenIDs.TAG && token.getImage().startsWith("</")) {
                String tag = token.getImage().substring(2).trim().toLowerCase();
                while (token != null) {
                    if (token.getTokenID() == XMLTokenIDs.TAG && !">".equals(token.getImage())) {
                        if (token.getImage().substring(1).trim().toLowerCase().equals(tag) && !this.isSingletonTag(token)) {
                            if (poss == 0) {
                                int start = token.getOffset();
                                int end = token.getOffset() + token.getImage().length();
                                TokenItem next = token.getNext();
                                if (next == null || next.getTokenID() != XMLTokenIDs.TAG || ">".equals(next.getImage())) {
                                    // empty if block
                                }
                                return new int[]{start, ++end};
                            }
                            --poss;
                        } else if (token.getImage().substring(2).toLowerCase().indexOf(tag) > -1 && !this.isSingletonTag(token)) {
                            ++poss;
                        }
                    }
                    token = token.getPrevious();
                }
            } else {
                if (this.isSingletonTag(token)) {
                    return null;
                }
                String tag = token.getImage().substring(1).toLowerCase();
                while (token != null) {
                    if (token.getTokenID() == XMLTokenIDs.TAG && !">".equals(token.getImage())) {
                        if (token.getImage().substring(2).trim().toLowerCase().equals(tag)) {
                            if (poss == 0) {
                                int start = token.getOffset();
                                int end = token.getOffset() + token.getImage().length() + 1;
                                return new int[]{start, end};
                            }
                            --poss;
                        } else if (token.getImage().substring(1).toLowerCase().equals(tag) && !this.isSingletonTag(token)) {
                            ++poss;
                        }
                    }
                    token = token.getNext();
                }
            }
        }
        return super.findMatchingBlock(offset, simpleSearch);
    }

    public boolean isSingletonTag(TokenItem tagTokenItem) {
        for (TokenItem ti = tagTokenItem; ti != null; ti = ti.getNext()) {
            if (ti.getTokenID() == XMLTokenIDs.TAG) {
                if ("/>".equals(ti.getImage())) {
                    return true;
                }
                if (">".equals(ti.getImage())) {
                    return false;
                }
            }
            if (ti.getTokenID() == XMLTokenIDs.TEXT) break;
        }
        return false;
    }

    private class DocumentMonitor
    implements DocumentListener {
        private DocumentMonitor() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            int start = e.getOffset();
            int len = e.getLength();
            try {
                String s = e.getDocument().getText(start + len - 1, 1);
                XMLSyntaxSupport.this.lastInsertedChar = s.charAt(0);
            }
            catch (BadLocationException e1) {
                ErrorManager err = ErrorManager.getDefault();
                err.notify((Throwable)e1);
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
        }
    }
}

