/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.model.visitor;

import java.util.List;
import org.netbeans.modules.xml.schema.model.GlobalAttribute;
import org.netbeans.modules.xml.schema.model.GlobalAttributeGroup;
import org.netbeans.modules.xml.schema.model.GlobalComplexType;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalGroup;
import org.netbeans.modules.xml.schema.model.GlobalSimpleType;
import org.netbeans.modules.xml.schema.model.Notation;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.visitor.DefaultSchemaVisitor;
import org.netbeans.modules.xml.xam.NamedReferenceable;

public class FindGlobalReferenceVisitor<T extends NamedReferenceable>
extends DefaultSchemaVisitor {
    private Class<T> elementType;
    private String localName;
    private Schema schema;
    private T refType;
    private boolean found;

    public T find(Class<T> elementType, String localName, Schema schema) {
        if (elementType == null || localName == null || schema == null) {
            throw new IllegalArgumentException("elementType == null");
        }
        this.elementType = elementType;
        this.localName = localName;
        this.schema = schema;
        this.found = false;
        schema.accept(this);
        return this.refType;
    }

    @Override
    public void visit(Schema schema) {
        List ch = schema.getChildren();
        for (SchemaComponent c : ch) {
            c.accept(this);
            if (!this.found) continue;
            return;
        }
    }

    @Override
    public void visit(GlobalAttributeGroup e) {
        this.findReference(GlobalAttributeGroup.class, e);
    }

    @Override
    public void visit(GlobalGroup e) {
        this.findReference(GlobalGroup.class, e);
    }

    @Override
    public void visit(GlobalAttribute e) {
        this.findReference(GlobalAttribute.class, e);
    }

    @Override
    public void visit(GlobalElement e) {
        this.findReference(GlobalElement.class, e);
    }

    @Override
    public void visit(GlobalSimpleType e) {
        this.findReference(GlobalSimpleType.class, e);
    }

    @Override
    public void visit(GlobalComplexType e) {
        this.findReference(GlobalComplexType.class, e);
    }

    @Override
    public void visit(Notation e) {
        this.findReference(Notation.class, e);
    }

    private void findReference(Class<? extends NamedReferenceable> refClass, NamedReferenceable n) {
        if (this.elementType.isAssignableFrom(refClass) && this.localName.equals(n.getName())) {
            this.refType = (NamedReferenceable)this.elementType.cast(n);
            this.found = true;
        }
    }
}

