/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.retriever.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.xml.retriever.impl.ResourceRedirectException;
import org.netbeans.modules.xml.retriever.impl.ResourceRetriever;

public class URLResourceRetriever
implements ResourceRetriever {
    private static final Map<String, String> rewriteURIMap = new HashMap<String, String>();
    private static final String HTTP_REDIRECT_LOCATION = "Location";
    private static final String URI_SCHEME = "http";
    long streamLength = 0L;
    URL effectiveURL = null;

    @Override
    public boolean accept(String baseAddr, String currentAddr) throws URISyntaxException {
        URI baseURI;
        URI currURI = new URI(currentAddr);
        if (currURI.isAbsolute() && currURI.getScheme().equalsIgnoreCase(URI_SCHEME)) {
            return true;
        }
        return baseAddr != null && !currURI.isAbsolute() && (baseURI = new URI(baseAddr)).getScheme().equalsIgnoreCase(URI_SCHEME);
    }

    @Override
    public HashMap<String, InputStream> retrieveDocument(String baseAddress, String documentAddress) throws IOException, URISyntaxException {
        String effAddr = this.getEffectiveAddress(baseAddress, documentAddress);
        if (effAddr == null) {
            return null;
        }
        URI currURI = new URI(effAddr);
        HashMap<String, InputStream> result = null;
        InputStream is = this.getInputStreamOfURL(currURI.toURL(), ProxySelector.getDefault().select(currURI).get(0));
        result = new HashMap<String, InputStream>();
        result.put(this.effectiveURL.toString(), is);
        return result;
    }

    protected void configureURLConnection(URLConnection ucn) {
    }

    private HttpURLConnection doConfigureURLConnection(URLConnection ucn) {
        assert (ucn instanceof HttpURLConnection);
        HttpURLConnection hucn = (HttpURLConnection)ucn;
        HttpURLConnection.setFollowRedirects(false);
        this.configureURLConnection(ucn);
        return hucn;
    }

    public InputStream getInputStreamOfURL(URL downloadURL, Proxy proxy) throws IOException {
        URLConnection ucn = null;
        while (true) {
            boolean isRedirect;
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            ucn = proxy != null ? downloadURL.openConnection(proxy) : downloadURL.openConnection();
            HttpURLConnection hucn = this.doConfigureURLConnection(ucn);
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            ucn.connect();
            int rc = hucn.getResponseCode();
            boolean bl = isRedirect = rc == 302 || rc == 301;
            if (!isRedirect) break;
            String addr = hucn.getHeaderField(HTTP_REDIRECT_LOCATION);
            URL newURL = new URL(addr);
            if (!downloadURL.getProtocol().equalsIgnoreCase(newURL.getProtocol())) {
                throw new ResourceRedirectException(newURL);
            }
            downloadURL = newURL;
        }
        ucn.setReadTimeout(10000);
        InputStream is = ucn.getInputStream();
        this.streamLength = ucn.getContentLength();
        this.effectiveURL = ucn.getURL();
        return is;
    }

    @Override
    public long getStreamLength() {
        return this.streamLength;
    }

    @Override
    public String getEffectiveAddress(String baseAddress, String documentAddress) throws IOException, URISyntaxException {
        return URLResourceRetriever.resolveURL(baseAddress, documentAddress, true);
    }

    public static String resolveURL(String baseAddress, String documentAddress) throws URISyntaxException {
        return URLResourceRetriever.resolveURL(baseAddress, documentAddress, false);
    }

    static String resolveURL(String baseAddress, String documentAddress, boolean rewrite) throws URISyntaxException {
        URI currURI = new URI(documentAddress);
        String result = null;
        if (currURI.isAbsolute()) {
            String rewritten = rewriteURIMap.get(documentAddress);
            result = rewrite && rewritten != null ? rewritten : currURI.toString();
            return result;
        }
        if (baseAddress != null) {
            URI baseURI = new URI(baseAddress);
            URI finalURI = baseURI.resolve(currURI);
            result = finalURI.toString();
            return result;
        }
        return null;
    }

    static {
        rewriteURIMap.put("http://www.w3.org/2001/XMLSchema", "http://www.w3.org/2001/XMLSchema.xsd");
        rewriteURIMap.put("http://www.w3.org/1999/XSL/Transform", "http://www.w3.org/2007/schema-for-xslt20.xsd");
    }
}

