/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.project;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.spi.project.ProjectConfiguration;
import org.openide.util.Lookup;
import org.openide.util.Parameters;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public final class ProjectActionContext {
    private final Project project;
    private String projectAction;
    private ProjectConfiguration configuration;
    private Map<String, String> properties;
    private Set<String> profiles;
    private Lookup lookup = Lookup.EMPTY;

    ProjectActionContext(Project project) {
        this.project = project;
    }

    @NonNull
    public Project getProject() {
        return this.project;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    @CheckForNull
    public String getProjectAction() {
        return this.projectAction;
    }

    @CheckForNull
    public ProjectConfiguration getConfiguration() {
        return this.configuration;
    }

    @NonNull
    public Map<String, String> getProperties() {
        return this.properties == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.properties);
    }

    @NonNull
    public Set<String> getProfiles() {
        return this.profiles == null ? Collections.emptySet() : Collections.unmodifiableSet(this.profiles);
    }

    @NonNull
    public Builder newDerivedBuilder() {
        return ProjectActionContext.newBuilder(this.project).forProjectAction(this.projectAction).useConfiguration(this.configuration).withProfiles(this.profiles).withProperties(this.properties);
    }

    @NonNull
    public static Builder newBuilder(Project p) {
        return new Builder(p);
    }

    @NonNull
    public static ProjectActionContext find(Project p) {
        for (ProjectActionContext pac : Lookup.getDefault().lookupAll(ProjectActionContext.class)) {
            if (p != pac.getProject()) continue;
            return pac;
        }
        return new ProjectActionContext(p);
    }

    public void apply(Runnable r, ProjectActionContext ... otherProjectContexts) {
        Lookup add;
        if (otherProjectContexts == null || otherProjectContexts.length == 0) {
            add = Lookups.fixed((Object[])new Object[]{this});
        } else {
            Object[] all = Arrays.copyOf(otherProjectContexts, otherProjectContexts.length + 1);
            all[all.length - 1] = this;
            add = Lookups.fixed((Object[])all);
        }
        ProxyLookup localDefLookup = new ProxyLookup(new Lookup[]{add, Lookup.getDefault()});
        Lookups.executeWith((Lookup)localDefLookup, (Runnable)r);
    }

    private static <E extends Throwable> void sneakyThrow(Throwable e) throws E {
        throw e;
    }

    public <V, E extends Exception> V apply(ProjectCallback<V, E> r, ProjectActionContext ... otherProjectContexts) throws E {
        Lookup add;
        if (otherProjectContexts == null || otherProjectContexts.length == 0) {
            add = Lookups.fixed((Object[])new Object[]{this});
        } else {
            Object[] all = Arrays.copyOf(otherProjectContexts, otherProjectContexts.length + 1);
            all[all.length - 1] = this;
            add = Lookups.fixed((Object[])all);
        }
        ProxyLookup localDefLookup = new ProxyLookup(new Lookup[]{add, Lookup.getDefault()});
        Object[] res = new Object[1];
        Exception[] t = new Exception[1];
        Lookups.executeWith((Lookup)localDefLookup, () -> {
            try {
                res[0] = r.call();
            }
            catch (Error | RuntimeException td) {
                throw td;
            }
            catch (Exception ex) {
                t[0] = ex;
            }
        });
        if (t[0] != null) {
            ProjectActionContext.sneakyThrow(t[0]);
            return null;
        }
        return (V)res[0];
    }

    public int hashCode() {
        int hash = 5;
        hash = 59 * hash + Objects.hashCode(this.project);
        hash = 59 * hash + Objects.hashCode(this.projectAction);
        hash = 59 * hash + Objects.hashCode(this.configuration);
        hash = 59 * hash + Objects.hashCode(this.properties);
        hash = 59 * hash + Objects.hashCode(this.profiles);
        hash = 59 * hash + Objects.hashCode(this.lookup);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProjectActionContext other = (ProjectActionContext)obj;
        if (!Objects.equals(this.projectAction, other.projectAction)) {
            return false;
        }
        if (!Objects.equals(this.project, other.project)) {
            return false;
        }
        if (!Objects.equals(this.configuration, other.configuration)) {
            return false;
        }
        if (!Objects.equals(this.properties, other.properties)) {
            return false;
        }
        if (!Objects.equals(this.lookup, other.lookup)) {
            return false;
        }
        return Objects.equals(this.profiles, other.profiles);
    }

    @FunctionalInterface
    public static interface ProjectCallback<V, E extends Exception>
    extends Callable<V> {
        @Override
        public V call() throws E;
    }

    public static final class Builder {
        private ProjectActionContext ctx;

        Builder(Project p) {
            this.ctx = new ProjectActionContext(p);
        }

        public Builder withLookup(Lookup lkp) {
            Parameters.notNull((CharSequence)"lkp", (Object)lkp);
            if (this.ctx.lookup == lkp) {
                return this;
            }
            this.ctx.lookup = lkp;
            return this;
        }

        @NonNull
        public Builder forProjectAction(String projectAction) {
            this.ctx.projectAction = projectAction;
            return this;
        }

        @NonNull
        public Builder useConfiguration(ProjectConfiguration configuration) {
            this.ctx.configuration = configuration;
            return this;
        }

        @NonNull
        public Builder withProperties(Map<String, String> properties) {
            if (properties == null) {
                return this;
            }
            if (this.ctx.properties == null) {
                this.ctx.properties = new HashMap();
            }
            this.ctx.properties.putAll(properties);
            return this;
        }

        @NonNull
        public Builder withProfiles(Collection<String> profiles) {
            if (profiles == null) {
                return this;
            }
            if (this.ctx.profiles == null) {
                this.ctx.profiles = new HashSet();
            }
            this.ctx.profiles.addAll(profiles);
            return this;
        }

        @NonNull
        public Builder withProperty(String n, String v) {
            if (this.ctx.properties == null) {
                this.ctx.properties = new HashMap();
            }
            this.ctx.properties.put(n, v);
            return this;
        }

        @NonNull
        public Builder withProfiles(String ... profiles) {
            return this.withProfiles(Arrays.asList(profiles));
        }

        @NonNull
        public ProjectActionContext context() {
            return this.ctx;
        }
    }
}

