/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.project;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.projectapi.AuxiliaryConfigBasedPreferencesProvider;
import org.netbeans.modules.projectapi.AuxiliaryConfigImpl;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.CacheDirectoryProvider;
import org.netbeans.spi.project.DependencyProjectProvider;
import org.netbeans.spi.project.ProjectContainerProvider;
import org.netbeans.spi.project.ProjectInformationProvider;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.GenericSources;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.Parameters;

public class ProjectUtils {
    private static final Logger LOG = Logger.getLogger(ProjectUtils.class.getName());

    private ProjectUtils() {
    }

    public static ProjectInformation getInformation(@NonNull Project p) {
        ProjectInformationProvider pip = (ProjectInformationProvider)Lookup.getDefault().lookup(ProjectInformationProvider.class);
        if (pip == null) {
            throw new IllegalStateException("No ProjectInformationProvider found in global Lookup.");
        }
        return pip.getProjectInformation(p);
    }

    public static Sources getSources(@NonNull Project p) {
        Parameters.notNull((CharSequence)"p", (Object)p);
        Lookup l = p.getLookup();
        Sources s = (Sources)l.lookup(Sources.class);
        if (s != null) {
            return s;
        }
        return GenericSources.genericOnly(p);
    }

    public static boolean hasSubprojectCycles(final Project master, final Project candidate) {
        return (Boolean)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Boolean>(){

            public Boolean run() {
                return ProjectUtils.visit(new HashMap(), master, master, candidate);
            }
        });
    }

    public static Set<Project> getDependencyProjects(@NonNull Project root, boolean recursive) {
        DependencyProjectProvider prov = (DependencyProjectProvider)root.getLookup().lookup(DependencyProjectProvider.class);
        if (prov != null) {
            HashSet<Project> toRet = new HashSet<Project>();
            DependencyProjectProvider.Result res = prov.getDependencyProjects();
            toRet.addAll(res.getProjects());
            if (recursive && !res.isRecursive()) {
                for (Project project : res.getProjects()) {
                    Set<Project> subs = ProjectUtils.getDependencyProjects(project, recursive);
                    if (subs == null) continue;
                    toRet.addAll(subs);
                }
            }
            return toRet;
        }
        return null;
    }

    public static Set<Project> getContainedProjects(@NonNull Project root, boolean recursive) {
        ProjectContainerProvider prov = (ProjectContainerProvider)root.getLookup().lookup(ProjectContainerProvider.class);
        if (prov != null) {
            HashSet<Project> toRet = new HashSet<Project>();
            ProjectContainerProvider.Result res = prov.getContainedProjects();
            toRet.addAll(res.getProjects());
            if (recursive && !res.isRecursive()) {
                for (Project project : res.getProjects()) {
                    Set<Project> subs = ProjectUtils.getContainedProjects(project, recursive);
                    if (subs == null) continue;
                    toRet.addAll(subs);
                }
            }
            return toRet;
        }
        return null;
    }

    public static Preferences getPreferences(@NonNull Project project, @NonNull Class clazz, boolean shared) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        Parameters.notNull((CharSequence)"clazz", (Object)clazz);
        return AuxiliaryConfigBasedPreferencesProvider.getPreferences(project, clazz, shared);
    }

    private static boolean visit(@NonNull Map<Project, Boolean> encountered, @NonNull Project curr, Project master, @NullAllowed Project candidate) {
        if (encountered.containsKey(curr)) {
            if (encountered.get(curr).booleanValue()) {
                return false;
            }
            LOG.log(Level.FINE, "Encountered cycle in {0} from {1} at {2} via {3}", new Object[]{master, candidate, curr, encountered});
            return true;
        }
        encountered.put(curr, false);
        SubprojectProvider spp = (SubprojectProvider)curr.getLookup().lookup(SubprojectProvider.class);
        if (spp != null) {
            Set<? extends Project> subprojects = spp.getSubprojects();
            LOG.log(Level.FINEST, "Found subprojects {0} from {1}", new Object[]{subprojects, curr});
            for (Project project : subprojects) {
                if (ProjectUtils.visit(encountered, project, master, candidate)) {
                    return true;
                }
                if (candidate != project) continue;
                candidate = null;
            }
        }
        if (candidate != null && curr == master && ProjectUtils.visit(encountered, candidate, master, candidate)) {
            return true;
        }
        assert (!encountered.get(curr).booleanValue());
        encountered.put(curr, true);
        return false;
    }

    public static AuxiliaryConfiguration getAuxiliaryConfiguration(@NonNull Project project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        return new AuxiliaryConfigImpl(project);
    }

    public static FileObject getCacheDirectory(@NonNull Project project, @NonNull Class<?> owner) throws IOException {
        CacheDirectoryProvider cdp = (CacheDirectoryProvider)project.getLookup().lookup(CacheDirectoryProvider.class);
        FileObject d = cdp != null ? cdp.getCacheDirectory() : FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)String.format("Projects/extra/%s-%08x", ProjectUtils.getInformation(project).getName().replace('/', '_'), project.getProjectDirectory().getPath().hashCode()));
        return FileUtil.createFolder((FileObject)d, (String)AuxiliaryConfigBasedPreferencesProvider.findCNBForClass(owner));
    }
}

