/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.libraries;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.api.annotations.common.NonNull;
import org.openide.filesystems.FileObject;
import org.openide.util.Parameters;

final class FileLockManager {
    private static volatile FileLockManager INSTANCE;
    private final Map<FileObject, ReadWriteLock> locks = Collections.synchronizedMap(new WeakHashMap());

    private FileLockManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T readAction(@NonNull FileObject file, @NonNull Callable<T> action) throws Exception {
        Parameters.notNull((CharSequence)"file", (Object)file);
        Parameters.notNull((CharSequence)"action", action);
        ReadWriteLock lck = this.getLock(file);
        lck.readLock().lock();
        try {
            T t = action.call();
            return t;
        }
        finally {
            lck.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T writeAction(@NonNull FileObject file, @NonNull Callable<T> action) throws Exception {
        Parameters.notNull((CharSequence)"file", (Object)file);
        Parameters.notNull((CharSequence)"action", action);
        ReadWriteLock lck = this.getLock(file);
        lck.writeLock().lock();
        try {
            T t = action.call();
            return t;
        }
        finally {
            lck.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private ReadWriteLock getLock(@NonNull FileObject file) {
        Map<FileObject, ReadWriteLock> map = this.locks;
        synchronized (map) {
            ReadWriteLock lck = this.locks.get(file);
            if (lck == null) {
                lck = new ReentrantReadWriteLock();
                this.locks.put(file, lck);
            }
            return lck;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    static FileLockManager getDefault() {
        FileLockManager res = INSTANCE;
        if (res != null) return res;
        Class<FileLockManager> clazz = FileLockManager.class;
        synchronized (FileLockManager.class) {
            res = INSTANCE;
            if (res != null) return res;
            INSTANCE = new FileLockManager();
            return INSTANCE;
        }
    }
}

