/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.project.libraries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.project.libraries.LibraryAccessor;
import org.netbeans.spi.project.libraries.ArealLibraryProvider;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryImplementation2;
import org.netbeans.spi.project.libraries.LibraryProvider;
import org.netbeans.spi.project.libraries.LibraryStorageArea;
import org.netbeans.spi.project.libraries.LibraryStorageAreaCache;
import org.netbeans.spi.project.libraries.LibraryTypeProvider;
import org.netbeans.spi.project.libraries.WritableLibraryProvider;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

public final class LibraryManager {
    public static final String PROP_LIBRARIES = "libraries";
    private static LibraryManager instance;
    private Lookup.Result<LibraryProvider> result;
    private final Collection<LibraryProvider> currentStorages = new ArrayList<LibraryProvider>();
    private final PropertyChangeListener plistener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (LibraryManager.PROP_LIBRARIES.equals(evt.getPropertyName())) {
                LibraryManager.this.resetCache();
            }
        }
    };
    private final PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private static final PropertyChangeSupport openLibraryManagerListListeners;
    private static final PropertyChangeListener AREAL_LIBRARY_PROVIDER_LISTENER;
    public static final String PROP_OPEN_LIBRARY_MANAGERS = "openManagers";
    private static Lookup.Result<ArealLibraryProvider> areaProvidersLookupResult;
    private static Collection<? extends ArealLibraryProvider> currentAreaProviders;
    private Collection<Library> cache;
    private final ArealLibraryProvider alp;
    private final LibraryStorageArea area;
    private LookupListener lookupListener;
    private long eventId;

    private LibraryManager() {
        this.alp = null;
        this.area = LibraryStorageArea.GLOBAL;
    }

    private LibraryManager(@NonNull ArealLibraryProvider alp, @NonNull LibraryStorageArea area) {
        Parameters.notNull((CharSequence)"alp", (Object)alp);
        Parameters.notNull((CharSequence)"area", (Object)area);
        this.alp = alp;
        this.area = area;
        LibraryProvider lp = LibraryAccessor.getLibraries(alp, area);
        lp.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.plistener, (Object)lp));
        this.currentStorages.add(lp);
    }

    public String getDisplayName() {
        return this.area.getDisplayName();
    }

    public URL getLocation() {
        return this.area.getLocation();
    }

    public Library getLibrary(String name) {
        Parameters.notNull((CharSequence)"name", (Object)name);
        Library[] libs = this.getLibraries();
        for (int i = 0; i < libs.length; ++i) {
            if (!name.equals(libs[i].getName())) continue;
            return libs[i];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Library[] getLibraries() {
        long myId;
        Collection<LibraryProvider<Object>> instances;
        ArrayList<Library> l = new ArrayList<Library>();
        Object object = this;
        synchronized (object) {
            if (this.cache != null) {
                return this.cache.toArray(new Library[0]);
            }
            if (this.area == LibraryStorageArea.GLOBAL) {
                if (this.result == null) {
                    this.result = Lookup.getDefault().lookupResult(LibraryProvider.class);
                    this.lookupListener = new LookupListener(){

                        public void resultChanged(LookupEvent ev) {
                            LibraryManager.this.resetCache();
                        }
                    };
                    this.result.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.lookupListener, this.result));
                }
                instances = this.result.allInstances();
                HashSet<LibraryProvider> hashSet = new HashSet<LibraryProvider>(instances);
                hashSet.removeAll(this.currentStorages);
                HashSet<LibraryProvider> removed = new HashSet<LibraryProvider>(this.currentStorages);
                removed.removeAll(instances);
                this.currentStorages.clear();
                for (LibraryProvider<Object> libraryProvider : instances) {
                    this.currentStorages.add(libraryProvider);
                }
                for (LibraryProvider<Object> libraryProvider : removed) {
                    libraryProvider.removePropertyChangeListener(this.plistener);
                }
                for (LibraryProvider<Object> libraryProvider : hashSet) {
                    libraryProvider.addPropertyChangeListener(this.plistener);
                }
            } else {
                instances = Collections.singleton(this.currentStorages.iterator().next());
            }
            myId = this.eventId;
        }
        assert (instances != null);
        for (LibraryProvider libraryProvider : instances) {
            for (LibraryImplementation impl : libraryProvider.getLibraries()) {
                l.add(new Library(impl, this));
            }
        }
        object = this;
        synchronized (object) {
            assert (l != null);
            if (this.eventId == myId) {
                this.cache = l;
                return this.cache.toArray(new Library[0]);
            }
            return l.toArray(new Library[0]);
        }
    }

    @Deprecated
    public void addLibrary(Library library) throws IOException, IllegalArgumentException {
        Parameters.notNull((CharSequence)"library", (Object)library);
        if (LibrariesSupport.getLibraryTypeProvider(library.getType()) == null) {
            throw new IllegalArgumentException("Trying to add a library of unknown type: " + library.getType());
        }
        String newLibraryName = library.getName();
        if (newLibraryName == null || this.getLibrary(newLibraryName) != null) {
            throw new IllegalArgumentException("Library hasn't name or the name is already used: " + newLibraryName);
        }
        Collection providers = Lookup.getDefault().lookupAll(WritableLibraryProvider.class);
        assert (providers.size() == 1);
        ((WritableLibraryProvider)providers.iterator().next()).addLibrary(library.getLibraryImplementation());
    }

    public Library createLibrary(String type, String name, Map<String, List<URL>> contents) throws IOException {
        return this.createLibrary(type, name, null, null, contents);
    }

    public Library createLibrary(@NonNull String type, @NonNull String name, @NullAllowed String displayName, @NullAllowed String description, @NonNull Map<String, List<URL>> contents) throws IOException {
        return this.createLibrary(type, name, displayName, description, contents, Collections.emptyMap());
    }

    public Library createLibrary(@NonNull String type, @NonNull String name, @NullAllowed String displayName, @NullAllowed String description, @NonNull Map<String, List<URL>> contents, @NonNull Map<String, String> properties) throws IOException {
        LibraryImplementation impl;
        Parameters.notNull((CharSequence)"properties", properties);
        if (this.getLibrary(name) != null) {
            throw new IllegalArgumentException("Name already in use: " + name);
        }
        if (this.area == LibraryStorageArea.GLOBAL) {
            LibraryTypeProvider ltp = LibrariesSupport.getLibraryTypeProvider(type);
            if (ltp == null) {
                throw new IllegalArgumentException("Trying to add a library of unknown type: " + type);
            }
            impl = ltp.createLibrary();
            impl.setName(name);
            impl.setDescription(description);
            LibrariesSupport.setDisplayName(impl, displayName);
            LibrariesSupport.setProperties(impl, properties);
            for (Map.Entry<String, List<URL>> entry : contents.entrySet()) {
                impl.setContent(entry.getKey(), entry.getValue());
            }
            ((WritableLibraryProvider)Lookup.getDefault().lookup(WritableLibraryProvider.class)).addLibrary(impl);
        } else {
            HashMap<String, List<URI>> cont = new HashMap<String, List<URI>>();
            for (Map.Entry<String, List<URL>> entry : contents.entrySet()) {
                cont.put(entry.getKey(), LibrariesSupport.convertURLsToURIs(entry.getValue(), LibrariesSupport.ConversionMode.WARN));
            }
            impl = LibraryAccessor.createLibrary(this.alp, type, name, this.area, cont);
            impl.setDescription(description);
            LibrariesSupport.setDisplayName(impl, displayName);
            LibrariesSupport.setProperties(impl, properties);
        }
        return new Library(impl, this);
    }

    public Library createURILibrary(String type, String name, Map<String, List<URI>> contents) throws IOException {
        return this.createURILibrary(type, name, null, null, contents);
    }

    public Library createURILibrary(@NonNull String type, @NonNull String name, @NullAllowed String displayName, @NullAllowed String description, @NonNull Map<String, List<URI>> contents) throws IOException {
        return this.createURILibrary(type, name, displayName, description, contents, Collections.emptyMap());
    }

    public Library createURILibrary(@NonNull String type, @NonNull String name, @NullAllowed String displayName, @NullAllowed String description, @NonNull Map<String, List<URI>> contents, @NonNull Map<String, String> properties) throws IOException {
        LibraryImplementation impl;
        Parameters.notNull((CharSequence)"properties", properties);
        if (this.getLibrary(name) != null) {
            throw new IllegalArgumentException("Name already in use: " + name);
        }
        if (this.area == LibraryStorageArea.GLOBAL) {
            LibraryTypeProvider ltp = LibrariesSupport.getLibraryTypeProvider(type);
            if (ltp == null) {
                throw new IllegalArgumentException("Trying to add a library of unknown type: " + type);
            }
            impl = ltp.createLibrary();
            impl.setName(name);
            LibrariesSupport.setDisplayName(impl, displayName);
            LibrariesSupport.setProperties(impl, properties);
            for (Map.Entry<String, List<URI>> entry : contents.entrySet()) {
                impl.setContent(entry.getKey(), LibrariesSupport.convertURIsToURLs(entry.getValue(), LibrariesSupport.ConversionMode.FAIL));
            }
            ((WritableLibraryProvider)Lookup.getDefault().lookup(WritableLibraryProvider.class)).addLibrary(impl);
        } else {
            impl = LibraryAccessor.createLibrary(this.alp, type, name, this.area, contents);
            LibrariesSupport.setDisplayName(impl, displayName);
            LibrariesSupport.setProperties(impl, properties);
        }
        return new Library(impl, this);
    }

    public void removeLibrary(Library library) throws IOException, IllegalArgumentException {
        Parameters.notNull((CharSequence)"library", (Object)library);
        if (this.area == LibraryStorageArea.GLOBAL) {
            Collection providers = Lookup.getDefault().lookupAll(WritableLibraryProvider.class);
            assert (providers.size() == 1);
            ((WritableLibraryProvider)providers.iterator().next()).removeLibrary(library.getLibraryImplementation());
        } else {
            assert (library.getLibraryImplementation() instanceof LibraryImplementation2);
            LibraryAccessor.remove(this.alp, (LibraryImplementation2)library.getLibraryImplementation());
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        Parameters.notNull((CharSequence)"listener", (Object)listener);
        this.listeners.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        Parameters.notNull((CharSequence)"listener", (Object)listener);
        this.listeners.removePropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void resetCache() {
        LibraryManager libraryManager = this;
        synchronized (libraryManager) {
            this.cache = null;
            ++this.eventId;
        }
        this.listeners.firePropertyChange(PROP_LIBRARIES, null, null);
    }

    public static synchronized LibraryManager getDefault() {
        if (instance == null) {
            instance = new LibraryManager();
        }
        return instance;
    }

    public static LibraryManager forLocation(URL location) throws IllegalArgumentException {
        for (ArealLibraryProvider alp : Lookup.getDefault().lookupAll(ArealLibraryProvider.class)) {
            Object area = alp.loadArea(location);
            if (area == null) continue;
            return new LibraryManager(alp, (LibraryStorageArea)area);
        }
        throw new IllegalArgumentException(location.toExternalForm());
    }

    public static Collection<LibraryManager> getOpenManagers() {
        ArrayList<LibraryManager> managers = new ArrayList<LibraryManager>();
        managers.add(LibraryManager.getDefault());
        HashSet<URL> locations = new HashSet<URL>();
        Collection alps = Lookup.getDefault().lookupAll(ArealLibraryProvider.class);
        for (ArealLibraryProvider alp : alps) {
            for (LibraryStorageArea libraryStorageArea : LibraryAccessor.getOpenAreas(alp)) {
                if (!locations.add(libraryStorageArea.getLocation())) continue;
                managers.add(new LibraryManager(alp, libraryStorageArea));
            }
        }
        for (LibraryStorageAreaCache lsaCache : Lookup.getDefault().lookupAll(LibraryStorageAreaCache.class)) {
            for (ArealLibraryProvider arealLibraryProvider : alps) {
                for (URL uRL : lsaCache.getCachedAreas()) {
                    Object area = arealLibraryProvider.loadArea(uRL);
                    if (area == null) continue;
                    assert (area.getLocation().equals(uRL)) : "Bad location " + area.getLocation() + " does not match " + uRL + " from " + arealLibraryProvider.getClass().getName();
                    if (!locations.add(uRL)) continue;
                    managers.add(new LibraryManager(arealLibraryProvider, (LibraryStorageArea)area));
                }
            }
        }
        return managers;
    }

    public static synchronized void addOpenManagersPropertyChangeListener(PropertyChangeListener listener) {
        Parameters.notNull((CharSequence)"listener", (Object)listener);
        if (areaProvidersLookupResult == null) {
            areaProvidersLookupResult = Lookup.getDefault().lookupResult(ArealLibraryProvider.class);
            LibraryManager.attachListeners(areaProvidersLookupResult.allInstances());
            areaProvidersLookupResult.addLookupListener(new LookupListener(){

                public void resultChanged(LookupEvent ev) {
                    LibraryManager.attachListeners(areaProvidersLookupResult.allInstances());
                }
            });
        }
        openLibraryManagerListListeners.addPropertyChangeListener(listener);
    }

    private static synchronized void attachListeners(Collection<? extends ArealLibraryProvider> currentProviders) {
        for (ArealLibraryProvider arealLibraryProvider : currentAreaProviders) {
            arealLibraryProvider.removePropertyChangeListener(AREAL_LIBRARY_PROVIDER_LISTENER);
        }
        for (ArealLibraryProvider arealLibraryProvider : currentProviders) {
            arealLibraryProvider.addPropertyChangeListener(AREAL_LIBRARY_PROVIDER_LISTENER);
        }
        currentAreaProviders = currentProviders;
    }

    public static void removeOpenManagersPropertyChangeListener(PropertyChangeListener listener) {
        Parameters.notNull((CharSequence)"listener", (Object)listener);
        openLibraryManagerListListeners.removePropertyChangeListener(listener);
    }

    public String toString() {
        URL loc = this.getLocation();
        return "LibraryManager[" + (loc != null ? loc : "default") + "]";
    }

    @NonNull
    LibraryStorageArea getArea() {
        return this.area;
    }

    static {
        openLibraryManagerListListeners = new PropertyChangeSupport(LibraryManager.class);
        AREAL_LIBRARY_PROVIDER_LISTENER = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                openLibraryManagerListListeners.firePropertyChange(LibraryManager.PROP_OPEN_LIBRARY_MANAGERS, null, null);
            }
        };
        areaProvidersLookupResult = null;
        currentAreaProviders = new ArrayList<ArealLibraryProvider>();
    }
}

