/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.parsing.impl.indexing.IndexabilityQueryContextAccessor;
import org.netbeans.modules.parsing.spi.indexing.IndexabilityQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

final class IndexabilityQuery {
    private static final Logger LOG = Logger.getLogger(IndexabilityQuery.class.getName());
    private static final IndexabilityQueryContextAccessor CONTEXT_CREATOR = IndexabilityQueryContextAccessor.getInstance();
    private static final IndexabilityQuery INSTANCE = new IndexabilityQuery();
    private final ResultListener resultListener = new ResultListener();
    private final IqiChangedListener vqiListener = new IqiChangedListener();
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private volatile List<IndexabilityQueryImplementation> cachedIqiInstances = null;
    private Lookup.Result<IndexabilityQueryImplementation> iqiResult = null;

    public static final IndexabilityQuery getInstance() {
        return INSTANCE;
    }

    private IndexabilityQuery() {
    }

    public boolean preventIndexing(FileObject fileObject) {
        IndexabilityQueryImplementation.IndexabilityQueryContext iqc = CONTEXT_CREATOR.createContext(fileObject.toURL(), null, null);
        for (IndexabilityQueryImplementation iqi : this.getIqiInstances()) {
            if (!iqi.preventIndexing(iqc)) continue;
            return true;
        }
        return false;
    }

    public boolean preventIndexing(String indexerName, URL indexable, URL rootUrl) {
        IndexabilityQueryImplementation.IndexabilityQueryContext iqc = CONTEXT_CREATOR.createContext(indexable, indexerName, rootUrl);
        for (IndexabilityQueryImplementation iqi : this.getIqiInstances()) {
            if (!iqi.preventIndexing(iqc)) continue;
            return true;
        }
        return false;
    }

    public String getState() {
        return this.getIqiInstances().stream().map(iqi -> iqi.getName() + "-" + iqi.getVersion() + "-" + iqi.getStateIdentifier()).collect(Collectors.joining(","));
    }

    private Set<String> decodeState(String input) {
        try {
            return Arrays.stream(input.split(",")).map(s -> s.trim()).collect(Collectors.toSet());
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to parse IndexabilityQuery state from '" + input + "'", ex);
            return Collections.EMPTY_SET;
        }
    }

    public boolean isSameState(String reference) {
        return Objects.equals(this.decodeState(reference), this.decodeState(this.getState()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener l) {
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener l) {
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange(ChangeEvent event) {
        ArrayList<ChangeListener> lists;
        assert (event != null);
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            lists = new ArrayList<ChangeListener>(this.listeners);
        }
        for (ChangeListener listener : lists) {
            try {
                listener.stateChanged(event);
            }
            catch (RuntimeException x) {
                Exceptions.printStackTrace((Throwable)x);
            }
        }
    }

    private synchronized List<IndexabilityQueryImplementation> getIqiInstances() {
        if (this.cachedIqiInstances == null) {
            this.iqiResult = Lookup.getDefault().lookupResult(IndexabilityQueryImplementation.class);
            this.iqiResult.addLookupListener((LookupListener)this.resultListener);
            this.setupChangeListeners(null, new ArrayList<IndexabilityQueryImplementation>(this.iqiResult.allInstances()));
        }
        return this.cachedIqiInstances;
    }

    private synchronized void setupChangeListeners(List<IndexabilityQueryImplementation> oldVqiInstances, List<IndexabilityQueryImplementation> newVqiInstances) {
        if (oldVqiInstances != null) {
            HashSet<IndexabilityQueryImplementation> removed = new HashSet<IndexabilityQueryImplementation>(oldVqiInstances);
            removed.removeAll(newVqiInstances);
            for (IndexabilityQueryImplementation vqi : removed) {
                vqi.removeChangeListener(this.vqiListener);
            }
        }
        HashSet<IndexabilityQueryImplementation> added = new HashSet<IndexabilityQueryImplementation>(newVqiInstances);
        if (oldVqiInstances != null) {
            added.removeAll(oldVqiInstances);
        }
        for (IndexabilityQueryImplementation vqi : added) {
            vqi.addChangeListener(this.vqiListener);
        }
        this.cachedIqiInstances = newVqiInstances;
    }

    private class ResultListener
    implements LookupListener {
        private ResultListener() {
        }

        public void resultChanged(LookupEvent ev) {
            IndexabilityQuery.this.setupChangeListeners(IndexabilityQuery.this.cachedIqiInstances, new ArrayList(IndexabilityQuery.this.iqiResult.allInstances()));
            IndexabilityQuery.this.fireChange(new ChangeEvent(IndexabilityQuery.this));
        }
    }

    private class IqiChangedListener
    implements ChangeListener {
        private IqiChangedListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            IndexabilityQuery.this.fireChange(e);
        }
    }
}

