/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.bindings;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.modules.lsp.client.LSPBindings;
import org.netbeans.modules.lsp.client.Utils;
import org.netbeans.modules.lsp.client.bindings.LspStructureNavigatorPanel;
import org.netbeans.modules.lsp.client.bindings.NavigatorPanelImpl;
import org.netbeans.spi.lsp.StructureProvider;
import org.netbeans.spi.navigator.NavigatorPanel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

public final class LspNavigatorPanelDynamicRegistration
implements NavigatorPanel.DynamicRegistration {
    public Collection<? extends NavigatorPanel> panelsFor(URI uri) {
        try {
            FileObject file = URLMapper.findFileObject((URL)uri.toURL());
            if (file != null) {
                List<LSPBindings> bindings = LSPBindings.getBindings(file);
                if (!bindings.isEmpty()) {
                    return bindings.stream().filter(server -> Utils.isEnabled(Utils.getCapabilities(server).getDocumentSymbolProvider())).map(NavigatorPanelImpl::new).toList();
                }
                String mime = file.getMIMEType();
                for (StructureProvider sp : MimeLookup.getLookup((String)mime).lookupAll(StructureProvider.class)) {
                    FileObject mimeFolder;
                    if (sp == null) continue;
                    FileObject navigators = FileUtil.getConfigFile((String)"Navigator/Panels");
                    if (navigators != null && (mimeFolder = navigators.getFileObject(mime)) != null && mimeFolder.getChildren().length > 0) {
                        return Collections.emptyList();
                    }
                    return Collections.singletonList(LspStructureNavigatorPanel.INSTANCE);
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return Collections.emptyList();
    }
}

