/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.bindings;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.ApplyWorkspaceEditResponse;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.ConfigurationItem;
import org.eclipse.lsp4j.ConfigurationParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.MessageActionItem;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.ProgressParams;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.ShowMessageRequestParams;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.WorkDoneProgressBegin;
import org.eclipse.lsp4j.WorkDoneProgressCreateParams;
import org.eclipse.lsp4j.WorkDoneProgressEnd;
import org.eclipse.lsp4j.WorkDoneProgressNotification;
import org.eclipse.lsp4j.WorkDoneProgressReport;
import org.eclipse.lsp4j.jsonrpc.Endpoint;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageClient;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.lsp.client.LSPBindings;
import org.netbeans.modules.lsp.client.Utils;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.HintsController;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class LanguageClientImpl
implements LanguageClient,
Endpoint {
    private static final Logger LOG = Logger.getLogger(LanguageClientImpl.class.getName());
    private static final RequestProcessor WORKER = new RequestProcessor(LanguageClientImpl.class.getName(), 1, false, false);
    private LSPBindings bindings;
    private boolean allowCodeActions;
    private final Map<Object, ProgressHandle> key2Progress = new HashMap<Object, ProgressHandle>();
    private static final Map<DiagnosticSeverity, Severity> severityMap = new EnumMap<DiagnosticSeverity, Severity>(DiagnosticSeverity.class);

    public void setBindings(LSPBindings bindings) {
        this.bindings = bindings;
        ServerCapabilities serverCapabilities = bindings.getInitResult().getCapabilities();
        Either codeActions = serverCapabilities.getCodeActionProvider();
        this.allowCodeActions = codeActions != null && (!codeActions.isLeft() || (Boolean)codeActions.getLeft() != false);
    }

    public void telemetryEvent(Object arg0) {
        System.err.println("telemetry: " + arg0);
    }

    public CompletableFuture<Void> createProgress(WorkDoneProgressCreateParams params) {
        return CompletableFuture.completedFuture(null);
    }

    public void notifyProgress(ProgressParams params) {
        Either value = params.getValue();
        if (value.isRight()) {
            return;
        }
        WorkDoneProgressNotification n = (WorkDoneProgressNotification)value.getLeft();
        SwingUtilities.invokeLater(() -> {
            switch (n.getKind()) {
                case begin: {
                    WorkDoneProgressBegin progress = (WorkDoneProgressBegin)n;
                    ProgressHandle handle = ProgressHandle.createHandle((String)progress.getTitle());
                    this.key2Progress.put(params.getToken().get(), handle);
                    handle.start();
                    handle.progress(progress.getMessage());
                    break;
                }
                case report: {
                    WorkDoneProgressReport progress = (WorkDoneProgressReport)n;
                    ProgressHandle handle = this.key2Progress.get(params.getToken().get());
                    if (progress.getPercentage() != null) {
                        handle.switchToDeterminate(100);
                        handle.progress(progress.getPercentage().intValue());
                    } else {
                        handle.switchToIndeterminate();
                    }
                    if (progress.getMessage() == null) break;
                    handle.progress(progress.getMessage());
                    break;
                }
                case end: {
                    WorkDoneProgressEnd progress = (WorkDoneProgressEnd)n;
                    ProgressHandle handle = this.key2Progress.get(params.getToken().get());
                    handle.finish();
                    break;
                }
            }
        });
    }

    public void publishDiagnostics(PublishDiagnosticsParams pdp) {
        try {
            StyledDocument doc;
            FileObject file = URLMapper.findFileObject((URL)new URI(pdp.getUri()).toURL());
            EditorCookie ec = file != null ? (EditorCookie)file.getLookup().lookup(EditorCookie.class) : null;
            StyledDocument styledDocument = doc = ec != null ? ec.getDocument() : null;
            if (doc == null) {
                return;
            }
            assert (file != null);
            List diags = pdp.getDiagnostics().stream().map(d -> {
                DiagnosticFixList fixList = this.allowCodeActions ? new DiagnosticFixList(pdp.getUri(), (Diagnostic)d) : ErrorDescriptionFactory.lazyListForFixes(Collections.emptyList());
                return ErrorDescriptionFactory.createErrorDescription((Severity)severityMap.get(d.getSeverity()), (String)d.getMessage(), (LazyFixList)fixList, (FileObject)file, (int)Utils.getOffset(doc, d.getRange().getStart()), (int)Utils.getOffset(doc, d.getRange().getEnd()));
            }).collect(Collectors.toList());
            HintsController.setErrors((Document)doc, (String)LanguageClientImpl.class.getName(), diags);
        }
        catch (MalformedURLException | URISyntaxException ex) {
            LOG.log(Level.FINE, null, ex);
        }
    }

    public CompletableFuture<ApplyWorkspaceEditResponse> applyEdit(ApplyWorkspaceEditParams params) {
        Utils.applyWorkspaceEdit(params.getEdit());
        return CompletableFuture.completedFuture(new ApplyWorkspaceEditResponse(true));
    }

    public void showMessage(MessageParams arg0) {
        int messageType;
        switch (Optional.ofNullable(arg0.getType()).orElse(MessageType.Log)) {
            default: {
                messageType = 1;
                break;
            }
            case Warning: {
                messageType = 2;
                break;
            }
            case Error: {
                messageType = 0;
            }
        }
        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)arg0.getMessage(), messageType);
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
    }

    public CompletableFuture<MessageActionItem> showMessageRequest(ShowMessageRequestParams arg0) {
        int messageType;
        switch (Optional.ofNullable(arg0.getType()).orElse(MessageType.Log)) {
            default: {
                messageType = 1;
                break;
            }
            case Warning: {
                messageType = 2;
                break;
            }
            case Error: {
                messageType = 0;
            }
        }
        NotifyDescriptor.QuickPick nd = new NotifyDescriptor.QuickPick(arg0.getMessage(), "Please select", arg0.getActions().stream().map(mai -> new NotifyDescriptor.QuickPick.Item(mai.getTitle(), mai.getTitle())).collect(Collectors.toList()), false);
        nd.setMessageType(messageType);
        return DialogDisplayer.getDefault().notifyFuture((NotifyDescriptor)nd).thenApply(nd2 -> new MessageActionItem(nd2.getItems().stream().filter(i -> i.isSelected()).findFirst().map(i -> i.getLabel()).orElse("")));
    }

    public void logMessage(MessageParams arg0) {
        switch (Optional.ofNullable(arg0.getType()).orElse(MessageType.Log)) {
            case Log: 
            case Info: {
                LOG.info(arg0.getMessage());
                break;
            }
            case Warning: {
                LOG.warning(arg0.getMessage());
                break;
            }
            case Error: {
                LOG.severe(arg0.getMessage());
            }
        }
    }

    public CompletableFuture<List<Object>> configuration(ConfigurationParams configurationParams) {
        CompletableFuture<List<Object>> result = new CompletableFuture<List<Object>>();
        WORKER.post(() -> {
            ArrayList<Object> outcome = new ArrayList<Object>();
            for (ConfigurationItem ci : configurationParams.getItems()) {
                outcome.add(null);
            }
            result.complete(outcome);
        });
        return result;
    }

    public CompletableFuture<?> request(String method, Object parameter) {
        LOG.log(Level.WARNING, "Received unhandled request: {0}: {1}", new Object[]{method, parameter});
        return CompletableFuture.completedFuture(null);
    }

    public void notify(String method, Object parameter) {
        LOG.log(Level.WARNING, "Received unhandled notification: {0}: {1}", new Object[]{method, parameter});
    }

    static {
        severityMap.put(DiagnosticSeverity.Error, Severity.ERROR);
        severityMap.put(DiagnosticSeverity.Hint, Severity.HINT);
        severityMap.put(DiagnosticSeverity.Information, Severity.HINT);
        severityMap.put(DiagnosticSeverity.Warning, Severity.WARNING);
    }

    private final class DiagnosticFixList
    implements LazyFixList {
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private final String fileUri;
        private final Diagnostic diagnostic;
        private List<Fix> fixes;
        private boolean computing;
        private boolean computed;

        public DiagnosticFixList(String fileUri, Diagnostic diagnostic) {
            this.fileUri = fileUri;
            this.diagnostic = diagnostic;
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.pcs.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.pcs.removePropertyChangeListener(l);
        }

        public boolean probablyContainsFixes() {
            return true;
        }

        public synchronized List<Fix> getFixes() {
            if (!this.computing && !this.computed) {
                this.computing = true;
                LanguageClientImpl.this.bindings.runOnBackground(() -> {
                    try {
                        List commands = (List)LanguageClientImpl.this.bindings.getTextDocumentService().codeAction(new CodeActionParams(new TextDocumentIdentifier(this.fileUri), this.diagnostic.getRange(), new CodeActionContext(Collections.singletonList(this.diagnostic)))).get();
                        List newFixes = Collections.emptyList();
                        if (commands != null) {
                            newFixes = commands.stream().map(cmd -> new CommandBasedFix((Either<Command, CodeAction>)cmd)).collect(Collectors.toList());
                        }
                        DiagnosticFixList diagnosticFixList = this;
                        synchronized (diagnosticFixList) {
                            this.fixes = Collections.unmodifiableList(newFixes);
                            this.computed = true;
                            this.computing = false;
                        }
                        this.pcs.firePropertyChange("computed", null, null);
                        this.pcs.firePropertyChange("fixes", null, null);
                    }
                    catch (InterruptedException | ExecutionException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                });
            }
            return this.fixes;
        }

        public synchronized boolean isComputed() {
            return this.computed;
        }

        private class CommandBasedFix
        implements Fix {
            private final Either<Command, CodeAction> cmd;

            public CommandBasedFix(Either<Command, CodeAction> cmd) {
                this.cmd = cmd;
            }

            public String getText() {
                return this.cmd.isLeft() ? ((Command)this.cmd.getLeft()).getTitle() : ((CodeAction)this.cmd.getRight()).getTitle();
            }

            public ChangeInfo implement() throws Exception {
                Utils.applyCodeAction(LanguageClientImpl.this.bindings, this.cmd);
                return null;
            }
        }
    }
}

